/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class JsonValuesOperationResponse extends ProtocolRestJsonResponse implements
        ToCopyableBuilder<JsonValuesOperationResponse.Builder, JsonValuesOperationResponse> {
    private final String jsonValueHeaderMember;

    private final String jsonValueMember;

    private JsonValuesOperationResponse(BuilderImpl builder) {
        super(builder);
        this.jsonValueHeaderMember = builder.jsonValueHeaderMember;
        this.jsonValueMember = builder.jsonValueMember;
    }

    /**
     * Returns the value of the JsonValueHeaderMember property for this object.
     * 
     * @return The value of the JsonValueHeaderMember property for this object.
     */
    public String jsonValueHeaderMember() {
        return jsonValueHeaderMember;
    }

    /**
     * Returns the value of the JsonValueMember property for this object.
     * 
     * @return The value of the JsonValueMember property for this object.
     */
    public String jsonValueMember() {
        return jsonValueMember;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jsonValueHeaderMember());
        hashCode = 31 * hashCode + Objects.hashCode(jsonValueMember());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JsonValuesOperationResponse)) {
            return false;
        }
        JsonValuesOperationResponse other = (JsonValuesOperationResponse) obj;
        return Objects.equals(jsonValueHeaderMember(), other.jsonValueHeaderMember())
                && Objects.equals(jsonValueMember(), other.jsonValueMember());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (jsonValueHeaderMember() != null) {
            sb.append("JsonValueHeaderMember: ").append(jsonValueHeaderMember()).append(",");
        }
        if (jsonValueMember() != null) {
            sb.append("JsonValueMember: ").append(jsonValueMember()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JsonValueHeaderMember":
            return Optional.of(clazz.cast(jsonValueHeaderMember()));
        case "JsonValueMember":
            return Optional.of(clazz.cast(jsonValueMember()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ProtocolRestJsonResponse.Builder, CopyableBuilder<Builder, JsonValuesOperationResponse> {
        /**
         * Sets the value of the JsonValueHeaderMember property for this object.
         *
         * @param jsonValueHeaderMember
         *        The new value for the JsonValueHeaderMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonValueHeaderMember(String jsonValueHeaderMember);

        /**
         * Sets the value of the JsonValueMember property for this object.
         *
         * @param jsonValueMember
         *        The new value for the JsonValueMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonValueMember(String jsonValueMember);
    }

    static final class BuilderImpl extends ProtocolRestJsonResponse.BuilderImpl implements Builder {
        private String jsonValueHeaderMember;

        private String jsonValueMember;

        private BuilderImpl() {
        }

        private BuilderImpl(JsonValuesOperationResponse model) {
            jsonValueHeaderMember(model.jsonValueHeaderMember);
            jsonValueMember(model.jsonValueMember);
        }

        public final String getJsonValueHeaderMember() {
            return jsonValueHeaderMember;
        }

        @Override
        public final Builder jsonValueHeaderMember(String jsonValueHeaderMember) {
            this.jsonValueHeaderMember = jsonValueHeaderMember;
            return this;
        }

        public final void setJsonValueHeaderMember(String jsonValueHeaderMember) {
            this.jsonValueHeaderMember = jsonValueHeaderMember;
        }

        public final String getJsonValueMember() {
            return jsonValueMember;
        }

        @Override
        public final Builder jsonValueMember(String jsonValueMember) {
            this.jsonValueMember = jsonValueMember;
            return this;
        }

        public final void setJsonValueMember(String jsonValueMember) {
            this.jsonValueMember = jsonValueMember;
        }

        @Override
        public JsonValuesOperationResponse build() {
            return new JsonValuesOperationResponse(this);
        }
    }
}
