/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.transform;

import java.util.Map;
import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.protocolrestxml.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringUtils;

/**
 * MembersInQueryParamsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class MembersInQueryParamsRequestMarshaller implements
        Marshaller<Request<MembersInQueryParamsRequest>, MembersInQueryParamsRequest> {

    public Request<MembersInQueryParamsRequest> marshall(MembersInQueryParamsRequest membersInQueryParamsRequest) {

        if (membersInQueryParamsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<MembersInQueryParamsRequest> request = new DefaultRequest<MembersInQueryParamsRequest>(
                membersInQueryParamsRequest, "ProtocolRestXmlClient");

        request.setHttpMethod(HttpMethodName.POST);

        String uriResourcePath = "/2016-03-11/membersInQueryParams?StaticQueryParam=foo";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        request.setResourcePath(uriResourcePath);

        if (membersInQueryParamsRequest.stringQueryParam() != null) {
            request.addParameter("String", StringUtils.fromString(membersInQueryParamsRequest.stringQueryParam()));
        }

        if (membersInQueryParamsRequest.booleanQueryParam() != null) {
            request.addParameter("Boolean", StringUtils.fromBoolean(membersInQueryParamsRequest.booleanQueryParam()));
        }

        if (membersInQueryParamsRequest.integerQueryParam() != null) {
            request.addParameter("Integer", StringUtils.fromInteger(membersInQueryParamsRequest.integerQueryParam()));
        }

        if (membersInQueryParamsRequest.longQueryParam() != null) {
            request.addParameter("Long", StringUtils.fromLong(membersInQueryParamsRequest.longQueryParam()));
        }

        if (membersInQueryParamsRequest.floatQueryParam() != null) {
            request.addParameter("Float", StringUtils.fromFloat(membersInQueryParamsRequest.floatQueryParam()));
        }

        if (membersInQueryParamsRequest.doubleQueryParam() != null) {
            request.addParameter("Double", StringUtils.fromDouble(membersInQueryParamsRequest.doubleQueryParam()));
        }

        if (membersInQueryParamsRequest.timestampQueryParam() != null) {
            request.addParameter("Timestamp", StringUtils.fromInstant(membersInQueryParamsRequest.timestampQueryParam()));
        }

        if (membersInQueryParamsRequest.listOfStrings() != null && !(membersInQueryParamsRequest.listOfStrings().isEmpty())) {
            for (String value : membersInQueryParamsRequest.listOfStrings()) {
                request.addParameter("item", StringUtils.fromString(value));
            }
        }

        java.util.Map<String, String> mapOfStringToString = membersInQueryParamsRequest.mapOfStringToString();
        if (mapOfStringToString != null) {
            for (Map.Entry<String, String> entry : mapOfStringToString.entrySet()) {
                if (entry.getValue() != null) {
                    request.addParameter(StringUtils.fromString(entry.getKey()), StringUtils.fromString(entry.getValue()));
                }
            }
        }

        return request;
    }

}