/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class OperationWithGreedyLabelRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<OperationWithGreedyLabelRequest.Builder, OperationWithGreedyLabelRequest> {
    private final String nonGreedyPathParam;

    private final String greedyPathParam;

    private OperationWithGreedyLabelRequest(BuilderImpl builder) {
        this.nonGreedyPathParam = builder.nonGreedyPathParam;
        this.greedyPathParam = builder.greedyPathParam;
    }

    /**
     * Returns the value of the NonGreedyPathParam property for this object.
     * 
     * @return The value of the NonGreedyPathParam property for this object.
     */
    public String nonGreedyPathParam() {
        return nonGreedyPathParam;
    }

    /**
     * Returns the value of the GreedyPathParam property for this object.
     * 
     * @return The value of the GreedyPathParam property for this object.
     */
    public String greedyPathParam() {
        return greedyPathParam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nonGreedyPathParam());
        hashCode = 31 * hashCode + Objects.hashCode(greedyPathParam());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationWithGreedyLabelRequest)) {
            return false;
        }
        OperationWithGreedyLabelRequest other = (OperationWithGreedyLabelRequest) obj;
        return Objects.equals(nonGreedyPathParam(), other.nonGreedyPathParam())
                && Objects.equals(greedyPathParam(), other.greedyPathParam());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (nonGreedyPathParam() != null) {
            sb.append("NonGreedyPathParam: ").append(nonGreedyPathParam()).append(",");
        }
        if (greedyPathParam() != null) {
            sb.append("GreedyPathParam: ").append(greedyPathParam()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NonGreedyPathParam":
            return Optional.of(clazz.cast(nonGreedyPathParam()));
        case "GreedyPathParam":
            return Optional.of(clazz.cast(greedyPathParam()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, OperationWithGreedyLabelRequest> {
        /**
         * Sets the value of the NonGreedyPathParam property for this object.
         *
         * @param nonGreedyPathParam
         *        The new value for the NonGreedyPathParam property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonGreedyPathParam(String nonGreedyPathParam);

        /**
         * Sets the value of the GreedyPathParam property for this object.
         *
         * @param greedyPathParam
         *        The new value for the GreedyPathParam property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greedyPathParam(String greedyPathParam);
    }

    static final class BuilderImpl implements Builder {
        private String nonGreedyPathParam;

        private String greedyPathParam;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationWithGreedyLabelRequest model) {
            nonGreedyPathParam(model.nonGreedyPathParam);
            greedyPathParam(model.greedyPathParam);
        }

        public final String getNonGreedyPathParam() {
            return nonGreedyPathParam;
        }

        @Override
        public final Builder nonGreedyPathParam(String nonGreedyPathParam) {
            this.nonGreedyPathParam = nonGreedyPathParam;
            return this;
        }

        public final void setNonGreedyPathParam(String nonGreedyPathParam) {
            this.nonGreedyPathParam = nonGreedyPathParam;
        }

        public final String getGreedyPathParam() {
            return greedyPathParam;
        }

        @Override
        public final Builder greedyPathParam(String greedyPathParam) {
            this.greedyPathParam = greedyPathParam;
            return this;
        }

        public final void setGreedyPathParam(String greedyPathParam) {
            this.greedyPathParam = greedyPathParam;
        }

        @Override
        public OperationWithGreedyLabelRequest build() {
            return new OperationWithGreedyLabelRequest(this);
        }
    }
}
