/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class OperationWithExplicitPayloadStructureRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<OperationWithExplicitPayloadStructureRequest.Builder, OperationWithExplicitPayloadStructureRequest> {
    private final SimpleStruct payloadMember;

    private OperationWithExplicitPayloadStructureRequest(BuilderImpl builder) {
        this.payloadMember = builder.payloadMember;
    }

    /**
     * Returns the value of the PayloadMember property for this object.
     * 
     * @return The value of the PayloadMember property for this object.
     */
    public SimpleStruct payloadMember() {
        return payloadMember;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((payloadMember() == null) ? 0 : payloadMember().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationWithExplicitPayloadStructureRequest)) {
            return false;
        }
        OperationWithExplicitPayloadStructureRequest other = (OperationWithExplicitPayloadStructureRequest) obj;
        if (other.payloadMember() == null ^ this.payloadMember() == null) {
            return false;
        }
        if (other.payloadMember() != null && !other.payloadMember().equals(this.payloadMember())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (payloadMember() != null) {
            sb.append("PayloadMember: ").append(payloadMember()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PayloadMember":
            return Optional.of(clazz.cast(payloadMember()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, OperationWithExplicitPayloadStructureRequest> {
        /**
         * Sets the value of the PayloadMember property for this object.
         *
         * @param payloadMember
         *        The new value for the PayloadMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadMember(SimpleStruct payloadMember);
    }

    static final class BuilderImpl implements Builder {
        private SimpleStruct payloadMember;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationWithExplicitPayloadStructureRequest model) {
            payloadMember(model.payloadMember);
        }

        public final SimpleStruct.Builder getPayloadMember() {
            return payloadMember != null ? payloadMember.toBuilder() : null;
        }

        @Override
        public final Builder payloadMember(SimpleStruct payloadMember) {
            this.payloadMember = payloadMember;
            return this;
        }

        public final void setPayloadMember(SimpleStruct.BuilderImpl payloadMember) {
            this.payloadMember = payloadMember != null ? payloadMember.build() : null;
        }

        @Override
        public OperationWithExplicitPayloadStructureRequest build() {
            return new OperationWithExplicitPayloadStructureRequest(this);
        }
    }
}
