/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import software.amazon.awssdk.core.async.AsyncRequestProvider;
import software.amazon.awssdk.core.async.AsyncResponseHandler;
import software.amazon.awssdk.services.protocolrestjson.model.AllTypesRequest;
import software.amazon.awssdk.services.protocolrestjson.model.AllTypesResponse;
import software.amazon.awssdk.services.protocolrestjson.model.DeleteOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.DeleteOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.HeadOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.HeadOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.JsonValuesOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.JsonValuesOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MapOfStringToListOfStringInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MapOfStringToListOfStringInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInHeadersRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInHeadersResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MultiLocationOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MultiLocationOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.NestedContainersRequest;
import software.amazon.awssdk.services.protocolrestjson.model.NestedContainersResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadBlobRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadBlobResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadStructureRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadStructureResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithGreedyLabelRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithGreedyLabelResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithModeledContentTypeRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithModeledContentTypeResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithNoInputOrOutputRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithNoInputOrOutputResponse;
import software.amazon.awssdk.services.protocolrestjson.model.QueryParamWithoutValueRequest;
import software.amazon.awssdk.services.protocolrestjson.model.QueryParamWithoutValueResponse;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingInputOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingInputOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingOutputOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingOutputOperationResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing AmazonProtocolRestJson asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolRestJsonAsyncClient extends SdkAutoCloseable {
    /**
     * Create a {@link ProtocolRestJsonAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.core.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from
     * the {@link software.amazon.awssdk.core.auth.DefaultCredentialsProvider}.
     */
    static ProtocolRestJsonAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolRestJsonAsyncClient}.
     */
    static ProtocolRestJsonAsyncClientBuilder builder() {
        return new DefaultProtocolRestJsonAsyncClientBuilder();
    }

    /**
     * Invokes the AllTypes operation asynchronously.
     *
     * @param allTypesRequest
     * @return A Java Future containing the result of the AllTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.AllTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllTypesResponse> allTypes(AllTypesRequest allTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the DeleteOperation operation asynchronously.
     *
     * @param deleteOperationRequest
     * @return A Java Future containing the result of the DeleteOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.DeleteOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/DeleteOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteOperationResponse> deleteOperation(DeleteOperationRequest deleteOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the HeadOperation operation asynchronously.
     *
     * @param headOperationRequest
     * @return A Java Future containing the result of the HeadOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.HeadOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/HeadOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<HeadOperationResponse> headOperation(HeadOperationRequest headOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the IdempotentOperation operation asynchronously.
     *
     * @param idempotentOperationRequest
     * @return A Java Future containing the result of the IdempotentOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.IdempotentOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/IdempotentOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<IdempotentOperationResponse> idempotentOperation(
            IdempotentOperationRequest idempotentOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the JsonValuesOperation operation asynchronously.
     *
     * @param jsonValuesOperationRequest
     * @return A Java Future containing the result of the JsonValuesOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.JsonValuesOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/JsonValuesOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<JsonValuesOperationResponse> jsonValuesOperation(
            JsonValuesOperationRequest jsonValuesOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation asynchronously.
     *
     * @param mapOfStringToListOfStringInQueryParamsRequest
     * @return A Java Future containing the result of the MapOfStringToListOfStringInQueryParams operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MapOfStringToListOfStringInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MapOfStringToListOfStringInQueryParams"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MapOfStringToListOfStringInQueryParamsResponse> mapOfStringToListOfStringInQueryParams(
            MapOfStringToListOfStringInQueryParamsRequest mapOfStringToListOfStringInQueryParamsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInHeaders operation asynchronously.
     *
     * @param membersInHeadersRequest
     * @return A Java Future containing the result of the MembersInHeaders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MembersInHeaders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInHeaders" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<MembersInHeadersResponse> membersInHeaders(MembersInHeadersRequest membersInHeadersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInQueryParams operation asynchronously.
     *
     * @param membersInQueryParamsRequest
     * @return A Java Future containing the result of the MembersInQueryParams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MembersInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInQueryParams" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<MembersInQueryParamsResponse> membersInQueryParams(
            MembersInQueryParamsRequest membersInQueryParamsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MultiLocationOperation operation asynchronously.
     *
     * @param multiLocationOperationRequest
     * @return A Java Future containing the result of the MultiLocationOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MultiLocationOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MultiLocationOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MultiLocationOperationResponse> multiLocationOperation(
            MultiLocationOperationRequest multiLocationOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the NestedContainers operation asynchronously.
     *
     * @param nestedContainersRequest
     * @return A Java Future containing the result of the NestedContainers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.NestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<NestedContainersResponse> nestedContainers(NestedContainersRequest nestedContainersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation asynchronously.
     *
     * @param operationWithExplicitPayloadBlobRequest
     * @return A Java Future containing the result of the OperationWithExplicitPayloadBlob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithExplicitPayloadBlob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithExplicitPayloadBlobResponse> operationWithExplicitPayloadBlob(
            OperationWithExplicitPayloadBlobRequest operationWithExplicitPayloadBlobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithExplicitPayloadStructure operation asynchronously.
     *
     * @param operationWithExplicitPayloadStructureRequest
     * @return A Java Future containing the result of the OperationWithExplicitPayloadStructure operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithExplicitPayloadStructure
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithExplicitPayloadStructureResponse> operationWithExplicitPayloadStructure(
            OperationWithExplicitPayloadStructureRequest operationWithExplicitPayloadStructureRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithGreedyLabel operation asynchronously.
     *
     * @param operationWithGreedyLabelRequest
     * @return A Java Future containing the result of the OperationWithGreedyLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithGreedyLabel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithGreedyLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithGreedyLabelResponse> operationWithGreedyLabel(
            OperationWithGreedyLabelRequest operationWithGreedyLabelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithModeledContentType operation asynchronously.
     *
     * @param operationWithModeledContentTypeRequest
     * @return A Java Future containing the result of the OperationWithModeledContentType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithModeledContentType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithModeledContentType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithModeledContentTypeResponse> operationWithModeledContentType(
            OperationWithModeledContentTypeRequest operationWithModeledContentTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation asynchronously.
     *
     * @param operationWithNoInputOrOutputRequest
     * @return A Java Future containing the result of the OperationWithNoInputOrOutput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithNoInputOrOutput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithNoInputOrOutputResponse> operationWithNoInputOrOutput(
            OperationWithNoInputOrOutputRequest operationWithNoInputOrOutputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the QueryParamWithoutValue operation asynchronously.
     *
     * @param queryParamWithoutValueRequest
     * @return A Java Future containing the result of the QueryParamWithoutValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.QueryParamWithoutValue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/QueryParamWithoutValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<QueryParamWithoutValueResponse> queryParamWithoutValue(
            QueryParamWithoutValueRequest queryParamWithoutValueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the StreamingInputOperation operation asynchronously.
     *
     * @param streamingInputOperationRequest
     * @param requestProvider
     *        Functional interface that can be implemented to produce the request content in a non-blocking manner. The
     *        size of the content is expected to be known up front. See {@link AsyncRequestProvider} for specific
     *        details on implementing this interface as well as links to precanned implementations for common scenarios
     *        like uploading from a file. The service documentation for the request content is as follows ''
     * @return A Java Future containing the result of the StreamingInputOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.StreamingInputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingInputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StreamingInputOperationResponse> streamingInputOperation(
            StreamingInputOperationRequest streamingInputOperationRequest, AsyncRequestProvider requestProvider) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the StreamingOutputOperation operation asynchronously.
     *
     * @param streamingOutputOperationRequest
     * @param asyncResponseHandler
     *        The response handler for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseHandler} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows ''.
     * @return A future to the transformed result of the AsyncResponseHandler.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.StreamingOutputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> streamingOutputOperation(
            StreamingOutputOperationRequest streamingOutputOperationRequest,
            AsyncResponseHandler<StreamingOutputOperationResponse, ReturnT> asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the AllTypes operation asynchronously.
     *
     * @return A Java Future containing the result of the AllTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.AllTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AllTypesResponse> allTypes() {
        return allTypes(AllTypesRequest.builder().build());
    }

    /**
     * Invokes the DeleteOperation operation asynchronously.
     *
     * @return A Java Future containing the result of the DeleteOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.DeleteOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/DeleteOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteOperationResponse> deleteOperation() {
        return deleteOperation(DeleteOperationRequest.builder().build());
    }

    /**
     * Invokes the HeadOperation operation asynchronously.
     *
     * @return A Java Future containing the result of the HeadOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.HeadOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/HeadOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<HeadOperationResponse> headOperation() {
        return headOperation(HeadOperationRequest.builder().build());
    }

    /**
     * Invokes the JsonValuesOperation operation asynchronously.
     *
     * @return A Java Future containing the result of the JsonValuesOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmptyModeledException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.JsonValuesOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/JsonValuesOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<JsonValuesOperationResponse> jsonValuesOperation() {
        return jsonValuesOperation(JsonValuesOperationRequest.builder().build());
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation asynchronously.
     *
     * @return A Java Future containing the result of the MapOfStringToListOfStringInQueryParams operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MapOfStringToListOfStringInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MapOfStringToListOfStringInQueryParams"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MapOfStringToListOfStringInQueryParamsResponse> mapOfStringToListOfStringInQueryParams() {
        return mapOfStringToListOfStringInQueryParams(MapOfStringToListOfStringInQueryParamsRequest.builder().build());
    }

    /**
     * Invokes the MembersInHeaders operation asynchronously.
     *
     * @return A Java Future containing the result of the MembersInHeaders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MembersInHeaders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInHeaders" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<MembersInHeadersResponse> membersInHeaders() {
        return membersInHeaders(MembersInHeadersRequest.builder().build());
    }

    /**
     * Invokes the MembersInQueryParams operation asynchronously.
     *
     * @return A Java Future containing the result of the MembersInQueryParams operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.MembersInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInQueryParams" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<MembersInQueryParamsResponse> membersInQueryParams() {
        return membersInQueryParams(MembersInQueryParamsRequest.builder().build());
    }

    /**
     * Invokes the NestedContainers operation asynchronously.
     *
     * @return A Java Future containing the result of the NestedContainers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.NestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<NestedContainersResponse> nestedContainers() {
        return nestedContainers(NestedContainersRequest.builder().build());
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation asynchronously.
     *
     * @return A Java Future containing the result of the OperationWithExplicitPayloadBlob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithExplicitPayloadBlob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithExplicitPayloadBlobResponse> operationWithExplicitPayloadBlob() {
        return operationWithExplicitPayloadBlob(OperationWithExplicitPayloadBlobRequest.builder().build());
    }

    /**
     * Invokes the OperationWithExplicitPayloadStructure operation asynchronously.
     *
     * @return A Java Future containing the result of the OperationWithExplicitPayloadStructure operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithExplicitPayloadStructure
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithExplicitPayloadStructureResponse> operationWithExplicitPayloadStructure() {
        return operationWithExplicitPayloadStructure(OperationWithExplicitPayloadStructureRequest.builder().build());
    }

    /**
     * Invokes the OperationWithModeledContentType operation asynchronously.
     *
     * @return A Java Future containing the result of the OperationWithModeledContentType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithModeledContentType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithModeledContentType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithModeledContentTypeResponse> operationWithModeledContentType() {
        return operationWithModeledContentType(OperationWithModeledContentTypeRequest.builder().build());
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation asynchronously.
     *
     * @return A Java Future containing the result of the OperationWithNoInputOrOutput operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.OperationWithNoInputOrOutput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OperationWithNoInputOrOutputResponse> operationWithNoInputOrOutput() {
        return operationWithNoInputOrOutput(OperationWithNoInputOrOutputRequest.builder().build());
    }

    /**
     * Invokes the QueryParamWithoutValue operation asynchronously.
     *
     * @return A Java Future containing the result of the QueryParamWithoutValue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.QueryParamWithoutValue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/QueryParamWithoutValue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<QueryParamWithoutValueResponse> queryParamWithoutValue() {
        return queryParamWithoutValue(QueryParamWithoutValueRequest.builder().build());
    }

    /**
     * Invokes the StreamingInputOperation operation asynchronously.
     *
     * @param streamingInputOperationRequest
     * @param path
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows ''
     * @return A Java Future containing the result of the StreamingInputOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.StreamingInputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingInputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StreamingInputOperationResponse> streamingInputOperation(
            StreamingInputOperationRequest streamingInputOperationRequest, Path path) {
        return streamingInputOperation(streamingInputOperationRequest, AsyncRequestProvider.fromFile(path));
    }

    /**
     * Invokes the StreamingOutputOperation operation asynchronously.
     *
     * @param streamingOutputOperationRequest
     * @param path
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows ''.
     * @return A future to the transformed result of the AsyncResponseHandler.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ProtocolRestJsonException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ProtocolRestJsonAsyncClient.StreamingOutputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StreamingOutputOperationResponse> streamingOutputOperation(
            StreamingOutputOperationRequest streamingOutputOperationRequest, Path path) {
        return streamingOutputOperation(streamingOutputOperationRequest, AsyncResponseHandler.toFile(path));
    }
}
