/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.transform;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.protocolrestxml.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringUtils;

/**
 * MapOfStringToListOfStringInQueryParamsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class MapOfStringToListOfStringInQueryParamsRequestMarshaller implements
        Marshaller<Request<MapOfStringToListOfStringInQueryParamsRequest>, MapOfStringToListOfStringInQueryParamsRequest> {

    public Request<MapOfStringToListOfStringInQueryParamsRequest> marshall(
            MapOfStringToListOfStringInQueryParamsRequest mapOfStringToListOfStringInQueryParamsRequest) {

        if (mapOfStringToListOfStringInQueryParamsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<MapOfStringToListOfStringInQueryParamsRequest> request = new DefaultRequest<MapOfStringToListOfStringInQueryParamsRequest>(
                mapOfStringToListOfStringInQueryParamsRequest, "ProtocolRestXmlClient");

        request.setHttpMethod(HttpMethodName.POST);

        String uriResourcePath = "/2016-03-11/mapOfStringToListOfStringInQueryParams";

        request.setResourcePath(uriResourcePath);

        java.util.Map<String, java.util.List<String>> mapOfStringToListOfStrings = mapOfStringToListOfStringInQueryParamsRequest
                .mapOfStringToListOfStrings();
        if (mapOfStringToListOfStrings != null) {
            for (Map.Entry<String, java.util.List<String>> entry : mapOfStringToListOfStrings.entrySet()) {
                if (entry.getValue() != null) {
                    request.addParameters(StringUtils.fromString(entry.getKey()), entry.getValue());
                }
            }
        }

        return request;
    }

}