/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.protocolrestjson.model.*;

import software.amazon.awssdk.util.IdempotentUtils;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * IdempotentOperationRequestMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class IdempotentOperationRequestModelMarshaller {

    private static final MarshallingInfo<String> PATHIDEMPOTENTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("PathParam")
            .defaultValueSupplier(software.amazon.awssdk.util.IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<String> QUERYIDEMPOTENTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("QueryParam")
            .defaultValueSupplier(software.amazon.awssdk.util.IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<String> HEADERIDEMPOTENTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-idempotent-header")
            .defaultValueSupplier(software.amazon.awssdk.util.IdempotentUtils.getGenerator()).build();

    private static final IdempotentOperationRequestModelMarshaller INSTANCE = new IdempotentOperationRequestModelMarshaller();

    public static IdempotentOperationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(IdempotentOperationRequest idempotentOperationRequest, ProtocolMarshaller protocolMarshaller) {

        if (idempotentOperationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(idempotentOperationRequest.pathIdempotentToken(), PATHIDEMPOTENTTOKEN_BINDING);

            protocolMarshaller.marshall(idempotentOperationRequest.queryIdempotentToken(), QUERYIDEMPOTENTTOKEN_BINDING);

            protocolMarshaller.marshall(idempotentOperationRequest.headerIdempotentToken(), HEADERIDEMPOTENTTOKEN_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
