/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjsoncustomized;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import software.amazon.awssdk.services.protocolrestjsoncustomized.model.SimpleRequest;
import software.amazon.awssdk.services.protocolrestjsoncustomized.model.SimpleResponse;

/**
 * Service client for accessing AmazonProtocolRestJsonCustomized asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolRestJsonCustomizedAsyncClient extends AutoCloseable {
    /**
     * Create a {@link ProtocolRestJsonCustomizedAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.DefaultCredentialsProvider}.
     */
    static ProtocolRestJsonCustomizedAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolRestJsonCustomizedAsyncClient}.
     */
    static ProtocolRestJsonCustomizedAsyncClientBuilder builder() {
        return new DefaultProtocolRestJsonCustomizedAsyncClientBuilder();
    }

    /**
     * Invokes the Simple operation asynchronously.
     * 
     * @param simpleRequest
     * @return A Java Future containing the result of the Simple operation returned by the service.
     * @sample ProtocolRestJsonCustomizedAsyncClient.Simple
     */
    default CompletableFuture<SimpleResponse> simple() {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the Simple operation asynchronously.
     * 
     * @param simpleRequest
     * @return A Java Future containing the result of the Simple operation returned by the service.
     * @sample ProtocolRestJsonCustomizedAsyncClient.Simple
     */
    default CompletableFuture<SimpleResponse> simple(SimpleRequest simpleRequest) {
        throw new UnsupportedOperationException();
    }
}
