/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocoljsonrpc.transform;

import java.util.Map;

import java.math.*;
import java.nio.ByteBuffer;
import javax.annotation.Generated;

import software.amazon.awssdk.services.protocoljsonrpc.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AllTypesResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AllTypesResponseUnmarshaller implements Unmarshaller<AllTypesResponse, JsonUnmarshallerContext> {

    public AllTypesResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        AllTypesResponse.Builder allTypesResponseBuilder = AllTypesResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return allTypesResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("StringMember", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.stringMember(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("IntegerMember", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.integerMember(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("BooleanMember", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.booleanMember(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("FloatMember", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.floatMember(context.getUnmarshaller(Float.class).unmarshall(context));
                }
                if (context.testExpression("DoubleMember", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.doubleMember(context.getUnmarshaller(Double.class).unmarshall(context));
                }
                if (context.testExpression("LongMember", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.longMember(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("SimpleList", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.simpleList(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))
                            .unmarshall(context));
                }
                if (context.testExpression("ListOfMaps", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.listOfMaps(new ListUnmarshaller<java.util.Map<String, String>>(
                            new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context
                                    .getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("ListOfStructs", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.listOfStructs(new ListUnmarshaller<SimpleStruct>(SimpleStructUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("MapOfStringToIntegerList", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder
                            .mapOfStringToIntegerList(new MapUnmarshaller<String, java.util.List<Integer>>(context
                                    .getUnmarshaller(String.class), new ListUnmarshaller<Integer>(context
                                    .getUnmarshaller(Integer.class))).unmarshall(context));
                }
                if (context.testExpression("MapOfStringToString", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.mapOfStringToString(new MapUnmarshaller<String, String>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("MapOfStringToStruct", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.mapOfStringToStruct(new MapUnmarshaller<String, SimpleStruct>(context
                            .getUnmarshaller(String.class), SimpleStructUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("TimestampMember", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.timestampMember(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("StructWithNestedTimestampMember", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.structWithNestedTimestampMember(StructWithTimestampUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("BlobArg", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.blobArg(context.getUnmarshaller(java.nio.ByteBuffer.class).unmarshall(context));
                }
                if (context.testExpression("StructWithNestedBlob", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.structWithNestedBlob(StructWithNestedBlobTypeUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("BlobMap", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.blobMap(new MapUnmarshaller<String, java.nio.ByteBuffer>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(java.nio.ByteBuffer.class))
                            .unmarshall(context));
                }
                if (context.testExpression("ListOfBlobs", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.listOfBlobs(new ListUnmarshaller<java.nio.ByteBuffer>(context
                            .getUnmarshaller(java.nio.ByteBuffer.class)).unmarshall(context));
                }
                if (context.testExpression("RecursiveStruct", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.recursiveStruct(RecursiveStructTypeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("PolymorphicTypeWithSubTypes", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.polymorphicTypeWithSubTypes(BaseTypeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("PolymorphicTypeWithoutSubTypes", targetDepth)) {
                    context.nextToken();
                    allTypesResponseBuilder.polymorphicTypeWithoutSubTypes(SubTypeOneUnmarshaller.getInstance().unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return allTypesResponseBuilder.build();
    }

    private static AllTypesResponseUnmarshaller INSTANCE;

    public static AllTypesResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new AllTypesResponseUnmarshaller();
        return INSTANCE;
    }
}
