/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.model;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImplicitPayloadException extends ProtocolRestXmlException implements
        ToCopyableBuilder<ImplicitPayloadException.Builder, ImplicitPayloadException> {
    private static final SdkField<String> STRING_MEMBER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ImplicitPayloadException::stringMember))
            .setter(setter(Builder::stringMember))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringMember")
                    .unmarshallLocationName("StringMember").build()).build();

    private static final SdkField<Integer> INTEGER_MEMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ImplicitPayloadException::integerMember))
            .setter(setter(Builder::integerMember))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerMember")
                    .unmarshallLocationName("IntegerMember").build()).build();

    private static final SdkField<Long> LONG_MEMBER_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(ImplicitPayloadException::longMember))
            .setter(setter(Builder::longMember))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongMember")
                    .unmarshallLocationName("LongMember").build()).build();

    private static final SdkField<Double> DOUBLE_MEMBER_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(ImplicitPayloadException::doubleMember))
            .setter(setter(Builder::doubleMember))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DoubleMember")
                    .unmarshallLocationName("DoubleMember").build()).build();

    private static final SdkField<Float> FLOAT_MEMBER_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .getter(getter(ImplicitPayloadException::floatMember))
            .setter(setter(Builder::floatMember))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FloatMember")
                    .unmarshallLocationName("FloatMember").build()).build();

    private static final SdkField<Instant> TIMESTAMP_MEMBER_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ImplicitPayloadException::timestampMember))
            .setter(setter(Builder::timestampMember))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampMember")
                    .unmarshallLocationName("TimestampMember").build()).build();

    private static final SdkField<Boolean> BOOLEAN_MEMBER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ImplicitPayloadException::booleanMember))
            .setter(setter(Builder::booleanMember))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanMember")
                    .unmarshallLocationName("BooleanMember").build()).build();

    private static final SdkField<SdkBytes> BLOB_MEMBER_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(ImplicitPayloadException::blobMember))
            .setter(setter(Builder::blobMember))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlobMember")
                    .unmarshallLocationName("BlobMember").build()).build();

    private static final SdkField<List<String>> LIST_MEMBER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ImplicitPayloadException::listMember))
            .setter(setter(Builder::listMember))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListMember")
                    .unmarshallLocationName("ListMember").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<Map<String, String>> MAP_MEMBER_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ImplicitPayloadException::mapMember))
            .setter(setter(Builder::mapMember))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapMember")
                    .unmarshallLocationName("MapMember").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").unmarshallLocationName("value").build()).build())
                            .build()).build();

    private static final SdkField<SimpleStruct> SIMPLE_STRUCT_MEMBER_FIELD = SdkField
            .<SimpleStruct> builder(MarshallingType.SDK_POJO)
            .getter(getter(ImplicitPayloadException::simpleStructMember))
            .setter(setter(Builder::simpleStructMember))
            .constructor(SimpleStruct::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SimpleStructMember")
                    .unmarshallLocationName("SimpleStructMember").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_MEMBER_FIELD,
            INTEGER_MEMBER_FIELD, LONG_MEMBER_FIELD, DOUBLE_MEMBER_FIELD, FLOAT_MEMBER_FIELD, TIMESTAMP_MEMBER_FIELD,
            BOOLEAN_MEMBER_FIELD, BLOB_MEMBER_FIELD, LIST_MEMBER_FIELD, MAP_MEMBER_FIELD, SIMPLE_STRUCT_MEMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stringMember;

    private final Integer integerMember;

    private final Long longMember;

    private final Double doubleMember;

    private final Float floatMember;

    private final Instant timestampMember;

    private final Boolean booleanMember;

    private final SdkBytes blobMember;

    private final List<String> listMember;

    private final Map<String, String> mapMember;

    private final SimpleStruct simpleStructMember;

    private ImplicitPayloadException(BuilderImpl builder) {
        super(builder);
        this.stringMember = builder.stringMember;
        this.integerMember = builder.integerMember;
        this.longMember = builder.longMember;
        this.doubleMember = builder.doubleMember;
        this.floatMember = builder.floatMember;
        this.timestampMember = builder.timestampMember;
        this.booleanMember = builder.booleanMember;
        this.blobMember = builder.blobMember;
        this.listMember = builder.listMember;
        this.mapMember = builder.mapMember;
        this.simpleStructMember = builder.simpleStructMember;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the StringMember property for this object.
     * 
     * @return The value of the StringMember property for this object.
     */
    public String stringMember() {
        return stringMember;
    }

    /**
     * Returns the value of the IntegerMember property for this object.
     * 
     * @return The value of the IntegerMember property for this object.
     */
    public Integer integerMember() {
        return integerMember;
    }

    /**
     * Returns the value of the LongMember property for this object.
     * 
     * @return The value of the LongMember property for this object.
     */
    public Long longMember() {
        return longMember;
    }

    /**
     * Returns the value of the DoubleMember property for this object.
     * 
     * @return The value of the DoubleMember property for this object.
     */
    public Double doubleMember() {
        return doubleMember;
    }

    /**
     * Returns the value of the FloatMember property for this object.
     * 
     * @return The value of the FloatMember property for this object.
     */
    public Float floatMember() {
        return floatMember;
    }

    /**
     * Returns the value of the TimestampMember property for this object.
     * 
     * @return The value of the TimestampMember property for this object.
     */
    public Instant timestampMember() {
        return timestampMember;
    }

    /**
     * Returns the value of the BooleanMember property for this object.
     * 
     * @return The value of the BooleanMember property for this object.
     */
    public Boolean booleanMember() {
        return booleanMember;
    }

    /**
     * Returns the value of the BlobMember property for this object.
     * 
     * @return The value of the BlobMember property for this object.
     */
    public SdkBytes blobMember() {
        return blobMember;
    }

    /**
     * Returns the value of the ListMember property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the ListMember property for this object.
     */
    public List<String> listMember() {
        return listMember;
    }

    /**
     * Returns the value of the MapMember property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the MapMember property for this object.
     */
    public Map<String, String> mapMember() {
        return mapMember;
    }

    /**
     * Returns the value of the SimpleStructMember property for this object.
     * 
     * @return The value of the SimpleStructMember property for this object.
     */
    public SimpleStruct simpleStructMember() {
        return simpleStructMember;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImplicitPayloadException, T> g) {
        return obj -> g.apply((ImplicitPayloadException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImplicitPayloadException>,
            ProtocolRestXmlException.Builder {
        /**
         * Sets the value of the StringMember property for this object.
         *
         * @param stringMember
         *        The new value for the StringMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringMember(String stringMember);

        /**
         * Sets the value of the IntegerMember property for this object.
         *
         * @param integerMember
         *        The new value for the IntegerMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerMember(Integer integerMember);

        /**
         * Sets the value of the LongMember property for this object.
         *
         * @param longMember
         *        The new value for the LongMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longMember(Long longMember);

        /**
         * Sets the value of the DoubleMember property for this object.
         *
         * @param doubleMember
         *        The new value for the DoubleMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleMember(Double doubleMember);

        /**
         * Sets the value of the FloatMember property for this object.
         *
         * @param floatMember
         *        The new value for the FloatMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder floatMember(Float floatMember);

        /**
         * Sets the value of the TimestampMember property for this object.
         *
         * @param timestampMember
         *        The new value for the TimestampMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampMember(Instant timestampMember);

        /**
         * Sets the value of the BooleanMember property for this object.
         *
         * @param booleanMember
         *        The new value for the BooleanMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanMember(Boolean booleanMember);

        /**
         * Sets the value of the BlobMember property for this object.
         *
         * @param blobMember
         *        The new value for the BlobMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blobMember(SdkBytes blobMember);

        /**
         * Sets the value of the ListMember property for this object.
         *
         * @param listMember
         *        The new value for the ListMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listMember(Collection<String> listMember);

        /**
         * Sets the value of the ListMember property for this object.
         *
         * @param listMember
         *        The new value for the ListMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listMember(String... listMember);

        /**
         * Sets the value of the MapMember property for this object.
         *
         * @param mapMember
         *        The new value for the MapMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapMember(Map<String, String> mapMember);

        /**
         * Sets the value of the SimpleStructMember property for this object.
         *
         * @param simpleStructMember
         *        The new value for the SimpleStructMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simpleStructMember(SimpleStruct simpleStructMember);

        /**
         * Sets the value of the SimpleStructMember property for this object.
         *
         * This is a convenience that creates an instance of the {@link SimpleStruct.Builder} avoiding the need to
         * create one manually via {@link SimpleStruct#builder()}.
         *
         * When the {@link Consumer} completes, {@link SimpleStruct.Builder#build()} is called immediately and its
         * result is passed to {@link #simpleStructMember(SimpleStruct)}.
         * 
         * @param simpleStructMember
         *        a consumer that will call methods on {@link SimpleStruct.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simpleStructMember(SimpleStruct)
         */
        default Builder simpleStructMember(Consumer<SimpleStruct.Builder> simpleStructMember) {
            return simpleStructMember(SimpleStruct.builder().applyMutation(simpleStructMember).build());
        }

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends ProtocolRestXmlException.BuilderImpl implements Builder {
        private String stringMember;

        private Integer integerMember;

        private Long longMember;

        private Double doubleMember;

        private Float floatMember;

        private Instant timestampMember;

        private Boolean booleanMember;

        private SdkBytes blobMember;

        private List<String> listMember = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> mapMember = DefaultSdkAutoConstructMap.getInstance();

        private SimpleStruct simpleStructMember;

        private BuilderImpl() {
        }

        private BuilderImpl(ImplicitPayloadException model) {
            super(model);
            stringMember(model.stringMember);
            integerMember(model.integerMember);
            longMember(model.longMember);
            doubleMember(model.doubleMember);
            floatMember(model.floatMember);
            timestampMember(model.timestampMember);
            booleanMember(model.booleanMember);
            blobMember(model.blobMember);
            listMember(model.listMember);
            mapMember(model.mapMember);
            simpleStructMember(model.simpleStructMember);
        }

        public final String getStringMember() {
            return stringMember;
        }

        @Override
        public final Builder stringMember(String stringMember) {
            this.stringMember = stringMember;
            return this;
        }

        public final void setStringMember(String stringMember) {
            this.stringMember = stringMember;
        }

        public final Integer getIntegerMember() {
            return integerMember;
        }

        @Override
        public final Builder integerMember(Integer integerMember) {
            this.integerMember = integerMember;
            return this;
        }

        public final void setIntegerMember(Integer integerMember) {
            this.integerMember = integerMember;
        }

        public final Long getLongMember() {
            return longMember;
        }

        @Override
        public final Builder longMember(Long longMember) {
            this.longMember = longMember;
            return this;
        }

        public final void setLongMember(Long longMember) {
            this.longMember = longMember;
        }

        public final Double getDoubleMember() {
            return doubleMember;
        }

        @Override
        public final Builder doubleMember(Double doubleMember) {
            this.doubleMember = doubleMember;
            return this;
        }

        public final void setDoubleMember(Double doubleMember) {
            this.doubleMember = doubleMember;
        }

        public final Float getFloatMember() {
            return floatMember;
        }

        @Override
        public final Builder floatMember(Float floatMember) {
            this.floatMember = floatMember;
            return this;
        }

        public final void setFloatMember(Float floatMember) {
            this.floatMember = floatMember;
        }

        public final Instant getTimestampMember() {
            return timestampMember;
        }

        @Override
        public final Builder timestampMember(Instant timestampMember) {
            this.timestampMember = timestampMember;
            return this;
        }

        public final void setTimestampMember(Instant timestampMember) {
            this.timestampMember = timestampMember;
        }

        public final Boolean getBooleanMember() {
            return booleanMember;
        }

        @Override
        public final Builder booleanMember(Boolean booleanMember) {
            this.booleanMember = booleanMember;
            return this;
        }

        public final void setBooleanMember(Boolean booleanMember) {
            this.booleanMember = booleanMember;
        }

        public final ByteBuffer getBlobMember() {
            return blobMember == null ? null : blobMember.asByteBuffer();
        }

        @Override
        public final Builder blobMember(SdkBytes blobMember) {
            this.blobMember = StandardMemberCopier.copy(blobMember);
            return this;
        }

        public final void setBlobMember(ByteBuffer blobMember) {
            blobMember(blobMember == null ? null : SdkBytes.fromByteBuffer(blobMember));
        }

        public final Collection<String> getListMember() {
            return listMember;
        }

        @Override
        public final Builder listMember(Collection<String> listMember) {
            this.listMember = ListOfStringsCopier.copy(listMember);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listMember(String... listMember) {
            listMember(Arrays.asList(listMember));
            return this;
        }

        public final void setListMember(Collection<String> listMember) {
            this.listMember = ListOfStringsCopier.copy(listMember);
        }

        public final Map<String, String> getMapMember() {
            return mapMember;
        }

        @Override
        public final Builder mapMember(Map<String, String> mapMember) {
            this.mapMember = MapOfStringToStringCopier.copy(mapMember);
            return this;
        }

        public final void setMapMember(Map<String, String> mapMember) {
            this.mapMember = MapOfStringToStringCopier.copy(mapMember);
        }

        public final SimpleStruct.Builder getSimpleStructMember() {
            return simpleStructMember != null ? simpleStructMember.toBuilder() : null;
        }

        @Override
        public final Builder simpleStructMember(SimpleStruct simpleStructMember) {
            this.simpleStructMember = simpleStructMember;
            return this;
        }

        public final void setSimpleStructMember(SimpleStruct.BuilderImpl simpleStructMember) {
            this.simpleStructMember = simpleStructMember != null ? simpleStructMember.build() : null;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ImplicitPayloadException build() {
            return new ImplicitPayloadException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
