/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class OperationWithExplicitPayloadStructureResponse extends ProtocolRestJsonResponse implements
        ToCopyableBuilder<OperationWithExplicitPayloadStructureResponse.Builder, OperationWithExplicitPayloadStructureResponse> {
    private static final SdkField<SimpleStruct> PAYLOAD_MEMBER_FIELD = SdkField
            .<SimpleStruct> builder(MarshallingType.SDK_POJO)
            .getter(getter(OperationWithExplicitPayloadStructureResponse::payloadMember))
            .setter(setter(Builder::payloadMember))
            .constructor(SimpleStruct::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadMember").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOAD_MEMBER_FIELD));

    private final SimpleStruct payloadMember;

    private OperationWithExplicitPayloadStructureResponse(BuilderImpl builder) {
        super(builder);
        this.payloadMember = builder.payloadMember;
    }

    /**
     * Returns the value of the PayloadMember property for this object.
     * 
     * @return The value of the PayloadMember property for this object.
     */
    public SimpleStruct payloadMember() {
        return payloadMember;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(payloadMember());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationWithExplicitPayloadStructureResponse)) {
            return false;
        }
        OperationWithExplicitPayloadStructureResponse other = (OperationWithExplicitPayloadStructureResponse) obj;
        return Objects.equals(payloadMember(), other.payloadMember());
    }

    @Override
    public String toString() {
        return ToString.builder("OperationWithExplicitPayloadStructureResponse").add("PayloadMember", payloadMember()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PayloadMember":
            return Optional.ofNullable(clazz.cast(payloadMember()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OperationWithExplicitPayloadStructureResponse, T> g) {
        return obj -> g.apply((OperationWithExplicitPayloadStructureResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtocolRestJsonResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, OperationWithExplicitPayloadStructureResponse> {
        /**
         * Sets the value of the PayloadMember property for this object.
         *
         * @param payloadMember
         *        The new value for the PayloadMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadMember(SimpleStruct payloadMember);

        /**
         * Sets the value of the PayloadMember property for this object.
         *
         * This is a convenience that creates an instance of the {@link SimpleStruct.Builder} avoiding the need to
         * create one manually via {@link SimpleStruct#builder()}.
         *
         * When the {@link Consumer} completes, {@link SimpleStruct.Builder#build()} is called immediately and its
         * result is passed to {@link #payloadMember(SimpleStruct)}.
         * 
         * @param payloadMember
         *        a consumer that will call methods on {@link SimpleStruct.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #payloadMember(SimpleStruct)
         */
        default Builder payloadMember(Consumer<SimpleStruct.Builder> payloadMember) {
            return payloadMember(SimpleStruct.builder().applyMutation(payloadMember).build());
        }
    }

    static final class BuilderImpl extends ProtocolRestJsonResponse.BuilderImpl implements Builder {
        private SimpleStruct payloadMember;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationWithExplicitPayloadStructureResponse model) {
            super(model);
            payloadMember(model.payloadMember);
        }

        public final SimpleStruct.Builder getPayloadMember() {
            return payloadMember != null ? payloadMember.toBuilder() : null;
        }

        @Override
        public final Builder payloadMember(SimpleStruct payloadMember) {
            this.payloadMember = payloadMember;
            return this;
        }

        public final void setPayloadMember(SimpleStruct.BuilderImpl payloadMember) {
            this.payloadMember = payloadMember != null ? payloadMember.build() : null;
        }

        @Override
        public OperationWithExplicitPayloadStructureResponse build() {
            return new OperationWithExplicitPayloadStructureResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
