/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class OperationWithExplicitPayloadBlobResponse extends ProtocolRestJsonResponse implements
        ToCopyableBuilder<OperationWithExplicitPayloadBlobResponse.Builder, OperationWithExplicitPayloadBlobResponse> {
    private static final SdkField<SdkBytes> PAYLOAD_MEMBER_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(OperationWithExplicitPayloadBlobResponse::payloadMember))
            .setter(setter(Builder::payloadMember))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadMember").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOAD_MEMBER_FIELD));

    private final SdkBytes payloadMember;

    private OperationWithExplicitPayloadBlobResponse(BuilderImpl builder) {
        super(builder);
        this.payloadMember = builder.payloadMember;
    }

    /**
     * Returns the value of the PayloadMember property for this object.
     * 
     * @return The value of the PayloadMember property for this object.
     */
    public SdkBytes payloadMember() {
        return payloadMember;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(payloadMember());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationWithExplicitPayloadBlobResponse)) {
            return false;
        }
        OperationWithExplicitPayloadBlobResponse other = (OperationWithExplicitPayloadBlobResponse) obj;
        return Objects.equals(payloadMember(), other.payloadMember());
    }

    @Override
    public String toString() {
        return ToString.builder("OperationWithExplicitPayloadBlobResponse").add("PayloadMember", payloadMember()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PayloadMember":
            return Optional.ofNullable(clazz.cast(payloadMember()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OperationWithExplicitPayloadBlobResponse, T> g) {
        return obj -> g.apply((OperationWithExplicitPayloadBlobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtocolRestJsonResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, OperationWithExplicitPayloadBlobResponse> {
        /**
         * Sets the value of the PayloadMember property for this object.
         *
         * @param payloadMember
         *        The new value for the PayloadMember property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadMember(SdkBytes payloadMember);
    }

    static final class BuilderImpl extends ProtocolRestJsonResponse.BuilderImpl implements Builder {
        private SdkBytes payloadMember;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationWithExplicitPayloadBlobResponse model) {
            super(model);
            payloadMember(model.payloadMember);
        }

        public final ByteBuffer getPayloadMember() {
            return payloadMember == null ? null : payloadMember.asByteBuffer();
        }

        @Override
        public final Builder payloadMember(SdkBytes payloadMember) {
            this.payloadMember = StandardMemberCopier.copy(payloadMember);
            return this;
        }

        public final void setPayloadMember(ByteBuffer payloadMember) {
            payloadMember(payloadMember == null ? null : SdkBytes.fromByteBuffer(payloadMember));
        }

        @Override
        public OperationWithExplicitPayloadBlobResponse build() {
            return new OperationWithExplicitPayloadBlobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
