/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.transform;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.StringWriter;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.protocolrestxml.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.utils.StringInputStream;
import software.amazon.awssdk.core.util.StringConversion;

import software.amazon.awssdk.core.util.xml.XmlWriter;

/**
 * RestXmlTypesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RestXmlTypesRequestMarshaller implements Marshaller<Request<RestXmlTypesRequest>, RestXmlTypesRequest> {

    public Request<RestXmlTypesRequest> marshall(RestXmlTypesRequest restXmlTypesRequest) {

        if (restXmlTypesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<RestXmlTypesRequest> request = new DefaultRequest<RestXmlTypesRequest>(restXmlTypesRequest,
                "ProtocolRestXmlClient");

        request.setHttpMethod(HttpMethodName.POST);

        if (restXmlTypesRequest.timestampMemberInHeader() != null) {
            request.addHeader("x-amz-timearg", StringConversion.fromInstant(restXmlTypesRequest.timestampMemberInHeader()));
        }

        String uriResourcePath = "/2016-03-11/restXmlTypes";

        request.setResourcePath(uriResourcePath);

        if (restXmlTypesRequest.stringMemberInQuery() != null) {
            request.addParameter("stringMemberInQuery", StringConversion.fromString(restXmlTypesRequest.stringMemberInQuery()));
        }

        if (restXmlTypesRequest.listOfStringsInQuery() != null && !(restXmlTypesRequest.listOfStringsInQuery().isEmpty())) {
            for (String value : restXmlTypesRequest.listOfStringsInQuery()) {
                request.addParameter("listOfStrings", StringConversion.fromString(value));
            }
        }

        java.util.Map<String, String> mapOfStringToStringInQuery = restXmlTypesRequest.mapOfStringToStringInQuery();
        if (mapOfStringToStringInQuery != null) {
            for (Map.Entry<String, String> entry : mapOfStringToStringInQuery.entrySet()) {
                if (entry.getValue() != null) {
                    request.addParameter(StringConversion.fromString(entry.getKey()),
                            StringConversion.fromString(entry.getValue()));
                }
            }
        }

        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter(stringWriter, "https://restxml/");

            xmlWriter.startElement("RestXmlTypesRequest");

            java.util.List<String> restXmlTypesRequestFlattenedListOfStringsList = restXmlTypesRequest.flattenedListOfStrings();
            if (!restXmlTypesRequestFlattenedListOfStringsList.isEmpty()
                    || !(restXmlTypesRequestFlattenedListOfStringsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                for (String restXmlTypesRequestFlattenedListOfStringsListValue : restXmlTypesRequestFlattenedListOfStringsList) {
                    xmlWriter.startElement("FlattenedListOfStrings");
                    xmlWriter.value(restXmlTypesRequestFlattenedListOfStringsListValue);
                    xmlWriter.endElement();
                }
            }

            java.util.List<String> restXmlTypesRequestNonFlattenedListWithLocationList = restXmlTypesRequest
                    .nonFlattenedListWithLocation();
            if (!restXmlTypesRequestNonFlattenedListWithLocationList.isEmpty()
                    || !(restXmlTypesRequestNonFlattenedListWithLocationList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                xmlWriter.startElement("NonFlattenedListWithLocation");

                for (String restXmlTypesRequestNonFlattenedListWithLocationListValue : restXmlTypesRequestNonFlattenedListWithLocationList) {
                    xmlWriter.startElement("item");
                    xmlWriter.value(restXmlTypesRequestNonFlattenedListWithLocationListValue);
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            java.util.List<SimpleStruct> restXmlTypesRequestFlattenedListOfStructsList = restXmlTypesRequest
                    .flattenedListOfStructs();
            if (!restXmlTypesRequestFlattenedListOfStructsList.isEmpty()
                    || !(restXmlTypesRequestFlattenedListOfStructsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                for (SimpleStruct restXmlTypesRequestFlattenedListOfStructsListValue : restXmlTypesRequestFlattenedListOfStructsList) {
                    xmlWriter.startElement("FlattenedListOfStructs");

                    if (restXmlTypesRequestFlattenedListOfStructsListValue.stringMember() != null) {
                        xmlWriter.startElement("StringMember")
                                .value(restXmlTypesRequestFlattenedListOfStructsListValue.stringMember()).endElement();
                    }
                    xmlWriter.endElement();
                }
            }

            java.util.List<String> restXmlTypesRequestFlattenedListWithLocationList = restXmlTypesRequest
                    .flattenedListWithLocation();
            if (!restXmlTypesRequestFlattenedListWithLocationList.isEmpty()
                    || !(restXmlTypesRequestFlattenedListWithLocationList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                for (String restXmlTypesRequestFlattenedListWithLocationListValue : restXmlTypesRequestFlattenedListWithLocationList) {
                    xmlWriter.startElement("item");
                    xmlWriter.value(restXmlTypesRequestFlattenedListWithLocationListValue);
                    xmlWriter.endElement();
                }
            }

            java.util.Map<String, String> restXmlTypesRequestFlattenedMapMap = (java.util.Map<String, String>) restXmlTypesRequest
                    .flattenedMap();
            if (!restXmlTypesRequestFlattenedMapMap.isEmpty()
                    || !(restXmlTypesRequestFlattenedMapMap instanceof software.amazon.awssdk.core.util.SdkAutoConstructMap)) {
                xmlWriter.startElement("FlattenedMap");

                for (Map.Entry<String, String> restXmlTypesRequestFlattenedMapMapValue : restXmlTypesRequestFlattenedMapMap
                        .entrySet()) {
                    xmlWriter.startElement("entry");
                    xmlWriter.startElement("key");
                    xmlWriter.value(restXmlTypesRequestFlattenedMapMapValue.getKey());
                    xmlWriter.endElement();
                    xmlWriter.startElement("value");
                    xmlWriter.value(restXmlTypesRequestFlattenedMapMapValue.getValue());
                    xmlWriter.endElement();
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            java.util.Map<String, String> restXmlTypesRequestFlattenedMapWithLocationMap = (java.util.Map<String, String>) restXmlTypesRequest
                    .flattenedMapWithLocation();
            if (!restXmlTypesRequestFlattenedMapWithLocationMap.isEmpty()
                    || !(restXmlTypesRequestFlattenedMapWithLocationMap instanceof software.amazon.awssdk.core.util.SdkAutoConstructMap)) {
                xmlWriter.startElement("flatmap");

                for (Map.Entry<String, String> restXmlTypesRequestFlattenedMapWithLocationMapValue : restXmlTypesRequestFlattenedMapWithLocationMap
                        .entrySet()) {
                    xmlWriter.startElement("entry");
                    xmlWriter.startElement("thekey");
                    xmlWriter.value(restXmlTypesRequestFlattenedMapWithLocationMapValue.getKey());
                    xmlWriter.endElement();
                    xmlWriter.startElement("thevalue");
                    xmlWriter.value(restXmlTypesRequestFlattenedMapWithLocationMapValue.getValue());
                    xmlWriter.endElement();
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            java.util.Map<String, String> restXmlTypesRequestNonFlattenedMapWithLocationMap = (java.util.Map<String, String>) restXmlTypesRequest
                    .nonFlattenedMapWithLocation();
            if (!restXmlTypesRequestNonFlattenedMapWithLocationMap.isEmpty()
                    || !(restXmlTypesRequestNonFlattenedMapWithLocationMap instanceof software.amazon.awssdk.core.util.SdkAutoConstructMap)) {
                xmlWriter.startElement("themap");

                for (Map.Entry<String, String> restXmlTypesRequestNonFlattenedMapWithLocationMapValue : restXmlTypesRequestNonFlattenedMapWithLocationMap
                        .entrySet()) {
                    xmlWriter.startElement("entry");
                    xmlWriter.startElement("thekey");
                    xmlWriter.value(restXmlTypesRequestNonFlattenedMapWithLocationMapValue.getKey());
                    xmlWriter.endElement();
                    xmlWriter.startElement("thevalue");
                    xmlWriter.value(restXmlTypesRequestNonFlattenedMapWithLocationMapValue.getValue());
                    xmlWriter.endElement();
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            xmlWriter.endElement();

            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF_8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }

        return request;
    }

}