/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.protocolrestxml.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringConversion;

/**
 * MembersInHeadersRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class MembersInHeadersRequestMarshaller implements Marshaller<Request<MembersInHeadersRequest>, MembersInHeadersRequest> {

    public Request<MembersInHeadersRequest> marshall(MembersInHeadersRequest membersInHeadersRequest) {

        if (membersInHeadersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<MembersInHeadersRequest> request = new DefaultRequest<MembersInHeadersRequest>(membersInHeadersRequest,
                "ProtocolRestXmlClient");

        request.setHttpMethod(HttpMethodName.POST);

        if (membersInHeadersRequest.stringMember() != null) {
            request.addHeader("x-amz-string", StringConversion.fromString(membersInHeadersRequest.stringMember()));
        }

        if (membersInHeadersRequest.booleanMember() != null) {
            request.addHeader("x-amz-boolean", StringConversion.fromBoolean(membersInHeadersRequest.booleanMember()));
        }

        if (membersInHeadersRequest.integerMember() != null) {
            request.addHeader("x-amz-integer", StringConversion.fromInteger(membersInHeadersRequest.integerMember()));
        }

        if (membersInHeadersRequest.longMember() != null) {
            request.addHeader("x-amz-long", StringConversion.fromLong(membersInHeadersRequest.longMember()));
        }

        if (membersInHeadersRequest.floatMember() != null) {
            request.addHeader("x-amz-float", StringConversion.fromFloat(membersInHeadersRequest.floatMember()));
        }

        if (membersInHeadersRequest.doubleMember() != null) {
            request.addHeader("x-amz-double", StringConversion.fromDouble(membersInHeadersRequest.doubleMember()));
        }

        if (membersInHeadersRequest.timestampMember() != null) {
            request.addHeader("x-amz-timestamp", StringConversion.fromInstant(membersInHeadersRequest.timestampMember()));
        }

        String uriResourcePath = "/2016-03-11/membersInHeaders";

        request.setResourcePath(uriResourcePath);

        return request;
    }

}