/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestxml.transform;

import java.util.Map;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.Map.Entry;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.protocolrestxml.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.runtime.transform.MapEntry;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * RestXmlTypesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RestXmlTypesResponseUnmarshaller implements Unmarshaller<RestXmlTypesResponse, StaxUnmarshallerContext> {

    private static class FlattenedMapMapEntryUnmarshaller implements
            Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, String> entry = new MapEntry<String, String>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("value", targetDepth)) {
                        entry.setValue(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static FlattenedMapMapEntryUnmarshaller INSTANCE;

        public static FlattenedMapMapEntryUnmarshaller getInstance() {
            if (INSTANCE == null)
                INSTANCE = new FlattenedMapMapEntryUnmarshaller();
            return INSTANCE;
        }

    }

    private static class FlattenedMapWithLocationMapEntryUnmarshaller implements
            Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, String> entry = new MapEntry<String, String>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("thekey", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("thevalue", targetDepth)) {
                        entry.setValue(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static FlattenedMapWithLocationMapEntryUnmarshaller INSTANCE;

        public static FlattenedMapWithLocationMapEntryUnmarshaller getInstance() {
            if (INSTANCE == null)
                INSTANCE = new FlattenedMapWithLocationMapEntryUnmarshaller();
            return INSTANCE;
        }

    }

    private static class NonFlattenedMapWithLocationMapEntryUnmarshaller implements
            Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, String> entry = new MapEntry<String, String>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("thekey", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("thevalue", targetDepth)) {
                        entry.setValue(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static NonFlattenedMapWithLocationMapEntryUnmarshaller INSTANCE;

        public static NonFlattenedMapWithLocationMapEntryUnmarshaller getInstance() {
            if (INSTANCE == null)
                INSTANCE = new NonFlattenedMapWithLocationMapEntryUnmarshaller();
            return INSTANCE;
        }

    }

    private static class MapOfStringToStringInQueryMapEntryUnmarshaller implements
            Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, String> entry = new MapEntry<String, String>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("value", targetDepth)) {
                        entry.setValue(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static MapOfStringToStringInQueryMapEntryUnmarshaller INSTANCE;

        public static MapOfStringToStringInQueryMapEntryUnmarshaller getInstance() {
            if (INSTANCE == null)
                INSTANCE = new MapOfStringToStringInQueryMapEntryUnmarshaller();
            return INSTANCE;
        }

    }

    public RestXmlTypesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        RestXmlTypesResponse.Builder restXmlTypesResponse = RestXmlTypesResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-timearg");
            restXmlTypesResponse
                    .timestampMemberInHeader(software.amazon.awssdk.util.DateUtils.parseRfc822Date(context.readText()));

        }

        java.util.Map<String, String> flattenedMap = null;
        java.util.Map<String, String> flattenedMapWithLocation = null;
        java.util.Map<String, String> nonFlattenedMapWithLocation = null;
        java.util.Map<String, String> mapOfStringToStringInQuery = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                restXmlTypesResponse.flattenedMap(flattenedMap);
                restXmlTypesResponse.flattenedMapWithLocation(flattenedMapWithLocation);
                restXmlTypesResponse.nonFlattenedMapWithLocation(nonFlattenedMapWithLocation);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("FlattenedListOfStrings", targetDepth)) {
                    restXmlTypesResponse.flattenedListOfStrings(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NonFlattenedListWithLocation", targetDepth)) {
                    restXmlTypesResponse.nonFlattenedListWithLocation(new ArrayList<String>());
                    continue;
                }

                if (context.testExpression("NonFlattenedListWithLocation/item", targetDepth)) {
                    restXmlTypesResponse.nonFlattenedListWithLocation(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("FlattenedListOfStructs", targetDepth)) {
                    restXmlTypesResponse.flattenedListOfStructs(SimpleStructUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("item", targetDepth)) {
                    restXmlTypesResponse.flattenedListWithLocation(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("FlattenedMap", targetDepth)) {
                    if (flattenedMap == null) {
                        flattenedMap = new java.util.HashMap<>();
                    }
                    Entry<String, String> entry = FlattenedMapMapEntryUnmarshaller.getInstance().unmarshall(context);
                    // restXmlTypesResponse.addFlattenedMapEntry(entry.getKey(), entry.getValue());

                    flattenedMap.put(entry.getKey(), entry.getValue());
                    continue;
                }

                if (context.testExpression("flatmap", targetDepth)) {
                    if (flattenedMapWithLocation == null) {
                        flattenedMapWithLocation = new java.util.HashMap<>();
                    }
                    Entry<String, String> entry = FlattenedMapWithLocationMapEntryUnmarshaller.getInstance().unmarshall(context);
                    // restXmlTypesResponse.addFlattenedMapWithLocationEntry(entry.getKey(), entry.getValue());

                    flattenedMapWithLocation.put(entry.getKey(), entry.getValue());
                    continue;
                }

                if (context.testExpression("themap/entry", targetDepth)) {
                    if (nonFlattenedMapWithLocation == null) {
                        nonFlattenedMapWithLocation = new java.util.HashMap<>();
                    }
                    Entry<String, String> entry = NonFlattenedMapWithLocationMapEntryUnmarshaller.getInstance().unmarshall(
                            context);
                    // restXmlTypesResponse.addNonFlattenedMapWithLocationEntry(entry.getKey(), entry.getValue());

                    nonFlattenedMapWithLocation.put(entry.getKey(), entry.getValue());
                    continue;
                }

                if (context.testExpression("stringMemberInQuery", targetDepth)) {
                    restXmlTypesResponse.stringMemberInQuery(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("listOfStrings", targetDepth)) {
                    restXmlTypesResponse.listOfStringsInQuery(new ArrayList<String>());
                    continue;
                }

                if (context.testExpression("listOfStrings/member", targetDepth)) {
                    restXmlTypesResponse.listOfStringsInQuery(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MapOfStringToStringInQuery/entry", targetDepth)) {
                    if (mapOfStringToStringInQuery == null) {
                        mapOfStringToStringInQuery = new java.util.HashMap<>();
                    }
                    Entry<String, String> entry = MapOfStringToStringInQueryMapEntryUnmarshaller.getInstance()
                            .unmarshall(context);
                    // restXmlTypesResponse.addMapOfStringToStringInQueryEntry(entry.getKey(), entry.getValue());

                    mapOfStringToStringInQuery.put(entry.getKey(), entry.getValue());
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    restXmlTypesResponse.flattenedMap(flattenedMap);

                    restXmlTypesResponse.flattenedMapWithLocation(flattenedMapWithLocation);

                    restXmlTypesResponse.nonFlattenedMapWithLocation(nonFlattenedMapWithLocation);

                    break;
                }
            }
        }
        return restXmlTypesResponse.build();
    }

    private static RestXmlTypesResponseUnmarshaller INSTANCE;

    public static RestXmlTypesResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new RestXmlTypesResponseUnmarshaller();
        return INSTANCE;
    }
}