/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class JsonValuesOperationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<JsonValuesOperationRequest.Builder, JsonValuesOperationRequest> {
    private final String jsonValueHeaderMember;

    private final String jsonValueMember;

    private JsonValuesOperationRequest(BuilderImpl builder) {
        this.jsonValueHeaderMember = builder.jsonValueHeaderMember;
        this.jsonValueMember = builder.jsonValueMember;
    }

    /**
     *
     * @return
     */
    public String jsonValueHeaderMember() {
        return jsonValueHeaderMember;
    }

    /**
     *
     * @return
     */
    public String jsonValueMember() {
        return jsonValueMember;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((jsonValueHeaderMember() == null) ? 0 : jsonValueHeaderMember().hashCode());
        hashCode = 31 * hashCode + ((jsonValueMember() == null) ? 0 : jsonValueMember().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JsonValuesOperationRequest)) {
            return false;
        }
        JsonValuesOperationRequest other = (JsonValuesOperationRequest) obj;
        if (other.jsonValueHeaderMember() == null ^ this.jsonValueHeaderMember() == null) {
            return false;
        }
        if (other.jsonValueHeaderMember() != null && !other.jsonValueHeaderMember().equals(this.jsonValueHeaderMember())) {
            return false;
        }
        if (other.jsonValueMember() == null ^ this.jsonValueMember() == null) {
            return false;
        }
        if (other.jsonValueMember() != null && !other.jsonValueMember().equals(this.jsonValueMember())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (jsonValueHeaderMember() != null) {
            sb.append("JsonValueHeaderMember: ").append(jsonValueHeaderMember()).append(",");
        }
        if (jsonValueMember() != null) {
            sb.append("JsonValueMember: ").append(jsonValueMember()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, JsonValuesOperationRequest> {
        /**
         *
         * @param jsonValueHeaderMember
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonValueHeaderMember(String jsonValueHeaderMember);

        /**
         *
         * @param jsonValueMember
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonValueMember(String jsonValueMember);
    }

    private static final class BuilderImpl implements Builder {
        private String jsonValueHeaderMember;

        private String jsonValueMember;

        private BuilderImpl() {
        }

        private BuilderImpl(JsonValuesOperationRequest model) {
            setJsonValueHeaderMember(model.jsonValueHeaderMember);
            setJsonValueMember(model.jsonValueMember);
        }

        public final String getJsonValueHeaderMember() {
            return jsonValueHeaderMember;
        }

        @Override
        public final Builder jsonValueHeaderMember(String jsonValueHeaderMember) {
            this.jsonValueHeaderMember = jsonValueHeaderMember;
            return this;
        }

        public final void setJsonValueHeaderMember(String jsonValueHeaderMember) {
            this.jsonValueHeaderMember = jsonValueHeaderMember;
        }

        public final String getJsonValueMember() {
            return jsonValueMember;
        }

        @Override
        public final Builder jsonValueMember(String jsonValueMember) {
            this.jsonValueMember = jsonValueMember;
            return this;
        }

        public final void setJsonValueMember(String jsonValueMember) {
            this.jsonValueMember = jsonValueMember;
        }

        @Override
        public JsonValuesOperationRequest build() {
            return new JsonValuesOperationRequest(this);
        }
    }
}
