/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocoljsonrpc;

import javax.annotation.Generated;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.protocoljsonrpc.model.AllTypesRequest;
import software.amazon.awssdk.services.protocoljsonrpc.model.AllTypesResponse;
import software.amazon.awssdk.services.protocoljsonrpc.model.EmptyModeledException;
import software.amazon.awssdk.services.protocoljsonrpc.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocoljsonrpc.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocoljsonrpc.model.NestedContainersRequest;
import software.amazon.awssdk.services.protocoljsonrpc.model.NestedContainersResponse;
import software.amazon.awssdk.services.protocoljsonrpc.model.OperationWithNoInputOrOutputRequest;
import software.amazon.awssdk.services.protocoljsonrpc.model.OperationWithNoInputOrOutputResponse;
import software.amazon.awssdk.services.protocoljsonrpc.model.ProtocolJsonRpcException;

/**
 * Service client for accessing AmazonProtocolJsonRpc. This can be created using the static {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolJsonRpcClient extends AutoCloseable {
    String SERVICE_NAME = "jsonrpc";

    /**
     * Create a {@link ProtocolJsonRpcClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.DefaultCredentialsProvider}.
     */
    static ProtocolJsonRpcClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolJsonRpcClient}.
     */
    static ProtocolJsonRpcClientBuilder builder() {
        return new DefaultProtocolJsonRpcClientBuilder();
    }

    /**
     *
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws ProtocolJsonRpcException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample ProtocolJsonRpcClient.AllTypes
     */
    default AllTypesResponse allTypes(AllTypesRequest allTypesRequest) throws EmptyModeledException, SdkBaseException,
            SdkClientException, ProtocolJsonRpcException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * @param idempotentOperationRequest
     * @return Result of the IdempotentOperation operation returned by the service.
     * @sample ProtocolJsonRpcClient.IdempotentOperation
     */
    default IdempotentOperationResponse idempotentOperation(IdempotentOperationRequest idempotentOperationRequest)
            throws SdkBaseException, SdkClientException, ProtocolJsonRpcException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * @param nestedContainersRequest
     * @return Result of the NestedContainers operation returned by the service.
     * @sample ProtocolJsonRpcClient.NestedContainers
     */
    default NestedContainersResponse nestedContainers(NestedContainersRequest nestedContainersRequest) throws SdkBaseException,
            SdkClientException, ProtocolJsonRpcException {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * @param operationWithNoInputOrOutputRequest
     * @return Result of the OperationWithNoInputOrOutput operation returned by the service.
     * @sample ProtocolJsonRpcClient.OperationWithNoInputOrOutput
     */
    default OperationWithNoInputOrOutputResponse operationWithNoInputOrOutput(
            OperationWithNoInputOrOutputRequest operationWithNoInputOrOutputRequest) throws SdkBaseException, SdkClientException,
            ProtocolJsonRpcException {
        throw new UnsupportedOperationException();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("jsonrpc");
    }
}
