/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolec2;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import software.amazon.awssdk.services.protocolec2.model.AllTypesRequest;
import software.amazon.awssdk.services.protocolec2.model.AllTypesResponse;
import software.amazon.awssdk.services.protocolec2.model.Ec2TypesRequest;
import software.amazon.awssdk.services.protocolec2.model.Ec2TypesResponse;
import software.amazon.awssdk.services.protocolec2.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocolec2.model.IdempotentOperationResponse;

/**
 * Service client for accessing AmazonProtocolEc2 asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolEc2AsyncClient extends AutoCloseable {
    /**
     * Create a {@link ProtocolEc2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.DefaultCredentialsProvider}.
     */
    static ProtocolEc2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolEc2AsyncClient}.
     */
    static ProtocolEc2AsyncClientBuilder builder() {
        return new DefaultProtocolEc2AsyncClientBuilder();
    }

    /**
     *
     * @param allTypesRequest
     * @return A Java Future containing the result of the AllTypes operation returned by the service.
     * @sample ProtocolEc2AsyncClient.AllTypes
     */
    default CompletableFuture<AllTypesResponse> allTypes(AllTypesRequest allTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * @param ec2TypesRequest
     * @return A Java Future containing the result of the Ec2Types operation returned by the service.
     * @sample ProtocolEc2AsyncClient.Ec2Types
     */
    default CompletableFuture<Ec2TypesResponse> ec2Types(Ec2TypesRequest ec2TypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     *
     * @param idempotentOperationRequest
     * @return A Java Future containing the result of the IdempotentOperation operation returned by the service.
     * @sample ProtocolEc2AsyncClient.IdempotentOperation
     */
    default CompletableFuture<IdempotentOperationResponse> idempotentOperation(
            IdempotentOperationRequest idempotentOperationRequest) {
        throw new UnsupportedOperationException();
    }
}
