/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.transform;

import java.util.List;
import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.apigateway.protocol.apigatewayprotocol.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * AllTypesStructureMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class AllTypesStructureMarshaller {

    private static final MarshallingInfo<String> STRINGMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StringMember").build();
    private static final MarshallingInfo<Integer> INTEGERMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IntegerMember").build();
    private static final MarshallingInfo<Double> NUMBERMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberMember").build();
    private static final MarshallingInfo<Boolean> BOOLEANMEMBER_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BooleanMember").build();
    private static final MarshallingInfo<StructuredPojo> NESTEDSTRUCTURE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("NestedStructure").build();
    private static final MarshallingInfo<StructuredPojo> RECURSIVESTRUCTURE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("RecursiveStructure").build();
    private static final MarshallingInfo<List> LISTOFSTRINGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListOfStrings").build();
    private static final MarshallingInfo<List> LISTOFSTRUCTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ListOfStructs").build();

    private static final AllTypesStructureMarshaller instance = new AllTypesStructureMarshaller();

    public static AllTypesStructureMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AllTypesStructure allTypesStructure, ProtocolMarshaller protocolMarshaller) {

        if (allTypesStructure == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(allTypesStructure.stringMember(), STRINGMEMBER_BINDING);
            protocolMarshaller.marshall(allTypesStructure.integerMember(), INTEGERMEMBER_BINDING);
            protocolMarshaller.marshall(allTypesStructure.numberMember(), NUMBERMEMBER_BINDING);
            protocolMarshaller.marshall(allTypesStructure.booleanMember(), BOOLEANMEMBER_BINDING);
            protocolMarshaller.marshall(allTypesStructure.nestedStructure(), NESTEDSTRUCTURE_BINDING);
            protocolMarshaller.marshall(allTypesStructure.recursiveStructure(), RECURSIVESTRUCTURE_BINDING);
            protocolMarshaller.marshall(allTypesStructure.listOfStrings(), LISTOFSTRINGS_BINDING);
            protocolMarshaller.marshall(allTypesStructure.listOfStructs(), LISTOFSTRUCTS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
