/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pricing.model.PriceListCopier;
import software.amazon.awssdk.services.pricing.model.PricingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProductsResponse
extends PricingResponse
implements ToCopyableBuilder<Builder, GetProductsResponse> {
    private static final SdkField<String> FORMAT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetProductsResponse.getter(GetProductsResponse::formatVersion)).setter(GetProductsResponse.setter(Builder::formatVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatVersion").build()}).build();
    private static final SdkField<List<String>> PRICE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetProductsResponse.getter(GetProductsResponse::priceList)).setter(GetProductsResponse.setter(Builder::priceList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), JsonValueTrait.create()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetProductsResponse.getter(GetProductsResponse::nextToken)).setter(GetProductsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_VERSION_FIELD, PRICE_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final String formatVersion;
    private final List<String> priceList;
    private final String nextToken;

    private GetProductsResponse(BuilderImpl builder) {
        super(builder);
        this.formatVersion = builder.formatVersion;
        this.priceList = builder.priceList;
        this.nextToken = builder.nextToken;
    }

    public String formatVersion() {
        return this.formatVersion;
    }

    public List<String> priceList() {
        return this.priceList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.formatVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.priceList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProductsResponse)) {
            return false;
        }
        GetProductsResponse other = (GetProductsResponse)((Object)obj);
        return Objects.equals(this.formatVersion(), other.formatVersion()) && Objects.equals(this.priceList(), other.priceList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetProductsResponse").add("FormatVersion", (Object)this.formatVersion()).add("PriceList", this.priceList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FormatVersion": {
                return Optional.ofNullable(clazz.cast(this.formatVersion()));
            }
            case "PriceList": {
                return Optional.ofNullable(clazz.cast(this.priceList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProductsResponse, T> g) {
        return obj -> g.apply((GetProductsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PricingResponse.BuilderImpl
    implements Builder {
        private String formatVersion;
        private List<String> priceList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProductsResponse model) {
            super(model);
            this.formatVersion(model.formatVersion);
            this.priceList(model.priceList);
            this.nextToken(model.nextToken);
        }

        public final String getFormatVersion() {
            return this.formatVersion;
        }

        @Override
        public final Builder formatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
            return this;
        }

        public final void setFormatVersion(String formatVersion) {
            this.formatVersion = formatVersion;
        }

        public final Collection<String> getPriceList() {
            return this.priceList;
        }

        @Override
        public final Builder priceList(Collection<String> priceList) {
            this.priceList = PriceListCopier.copy(priceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceList(String ... priceList) {
            this.priceList(Arrays.asList(priceList));
            return this;
        }

        public final void setPriceList(Collection<String> priceList) {
            this.priceList = PriceListCopier.copy(priceList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetProductsResponse build() {
            return new GetProductsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PricingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProductsResponse> {
        public Builder formatVersion(String var1);

        public Builder priceList(Collection<String> var1);

        public Builder priceList(String ... var1);

        public Builder nextToken(String var1);
    }
}

