/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pricing.model.PriceList;
import software.amazon.awssdk.services.pricing.model.PriceListsCopier;
import software.amazon.awssdk.services.pricing.model.PricingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPriceListsResponse
extends PricingResponse
implements ToCopyableBuilder<Builder, ListPriceListsResponse> {
    private static final SdkField<List<PriceList>> PRICE_LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PriceLists").getter(ListPriceListsResponse.getter(ListPriceListsResponse::priceLists)).setter(ListPriceListsResponse.setter(Builder::priceLists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceLists").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PriceList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPriceListsResponse.getter(ListPriceListsResponse::nextToken)).setter(ListPriceListsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICE_LISTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<PriceList> priceLists;
    private final String nextToken;

    private ListPriceListsResponse(BuilderImpl builder) {
        super(builder);
        this.priceLists = builder.priceLists;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPriceLists() {
        return this.priceLists != null && !(this.priceLists instanceof SdkAutoConstructList);
    }

    public final List<PriceList> priceLists() {
        return this.priceLists;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPriceLists() ? this.priceLists() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPriceListsResponse)) {
            return false;
        }
        ListPriceListsResponse other = (ListPriceListsResponse)((Object)obj);
        return this.hasPriceLists() == other.hasPriceLists() && Objects.equals(this.priceLists(), other.priceLists()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPriceListsResponse").add("PriceLists", this.hasPriceLists() ? this.priceLists() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PriceLists": {
                return Optional.ofNullable(clazz.cast(this.priceLists()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPriceListsResponse, T> g) {
        return obj -> g.apply((ListPriceListsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PricingResponse.BuilderImpl
    implements Builder {
        private List<PriceList> priceLists = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPriceListsResponse model) {
            super(model);
            this.priceLists(model.priceLists);
            this.nextToken(model.nextToken);
        }

        public final List<PriceList.Builder> getPriceLists() {
            List<PriceList.Builder> result = PriceListsCopier.copyToBuilder(this.priceLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPriceLists(Collection<PriceList.BuilderImpl> priceLists) {
            this.priceLists = PriceListsCopier.copyFromBuilder(priceLists);
        }

        @Override
        public final Builder priceLists(Collection<PriceList> priceLists) {
            this.priceLists = PriceListsCopier.copy(priceLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceLists(PriceList ... priceLists) {
            this.priceLists(Arrays.asList(priceLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceLists(Consumer<PriceList.Builder> ... priceLists) {
            this.priceLists(Stream.of(priceLists).map(c -> (PriceList)((PriceList.Builder)PriceList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPriceListsResponse build() {
            return new ListPriceListsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PricingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPriceListsResponse> {
        public Builder priceLists(Collection<PriceList> var1);

        public Builder priceLists(PriceList ... var1);

        public Builder priceLists(Consumer<PriceList.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

