/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pricing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pricing.PricingClient;
import software.amazon.awssdk.services.pricing.internal.UserAgentUtils;
import software.amazon.awssdk.services.pricing.model.AttributeValue;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesRequest;
import software.amazon.awssdk.services.pricing.model.GetAttributeValuesResponse;

public class GetAttributeValuesIterable
implements SdkIterable<GetAttributeValuesResponse> {
    private final PricingClient client;
    private final GetAttributeValuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAttributeValuesIterable(PricingClient client, GetAttributeValuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetAttributeValuesResponseFetcher();
    }

    public Iterator<GetAttributeValuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AttributeValue> attributeValues() {
        Function<GetAttributeValuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.attributeValues() != null) {
                return response.attributeValues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetAttributeValuesResponseFetcher
    implements SyncPageFetcher<GetAttributeValuesResponse> {
        private GetAttributeValuesResponseFetcher() {
        }

        public boolean hasNextPage(GetAttributeValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetAttributeValuesResponse nextPage(GetAttributeValuesResponse previousPage) {
            if (previousPage == null) {
                return GetAttributeValuesIterable.this.client.getAttributeValues(GetAttributeValuesIterable.this.firstRequest);
            }
            return GetAttributeValuesIterable.this.client.getAttributeValues((GetAttributeValuesRequest)((Object)GetAttributeValuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

