/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeRegistrationVersionsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.RegistrationVersionInformation;

public class DescribeRegistrationVersionsPublisher
implements SdkPublisher<DescribeRegistrationVersionsResponse> {
    private final PinpointSmsVoiceV2AsyncClient client;
    private final DescribeRegistrationVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRegistrationVersionsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeRegistrationVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRegistrationVersionsPublisher(PinpointSmsVoiceV2AsyncClient client, DescribeRegistrationVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRegistrationVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRegistrationVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RegistrationVersionInformation> registrationVersions() {
        Function<DescribeRegistrationVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.registrationVersions() != null) {
                return response.registrationVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRegistrationVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRegistrationVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeRegistrationVersionsResponse> {
        private DescribeRegistrationVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistrationVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRegistrationVersionsResponse> nextPage(DescribeRegistrationVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistrationVersionsPublisher.this.client.describeRegistrationVersions(DescribeRegistrationVersionsPublisher.this.firstRequest);
            }
            return DescribeRegistrationVersionsPublisher.this.client.describeRegistrationVersions((DescribeRegistrationVersionsRequest)((Object)DescribeRegistrationVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

