/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SenderIdInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SenderIdInformation> {
    private static final SdkField<String> SENDER_ID_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SenderIdArn").getter(SenderIdInformation.getter(SenderIdInformation::senderIdArn)).setter(SenderIdInformation.setter(Builder::senderIdArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderIdArn").build()}).build();
    private static final SdkField<String> SENDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SenderId").getter(SenderIdInformation.getter(SenderIdInformation::senderId)).setter(SenderIdInformation.setter(Builder::senderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderId").build()}).build();
    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IsoCountryCode").getter(SenderIdInformation.getter(SenderIdInformation::isoCountryCode)).setter(SenderIdInformation.setter(Builder::isoCountryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()}).build();
    private static final SdkField<List<String>> MESSAGE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MessageTypes").getter(SenderIdInformation.getter(SenderIdInformation::messageTypesAsStrings)).setter(SenderIdInformation.setter(Builder::messageTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MONTHLY_LEASING_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonthlyLeasingPrice").getter(SenderIdInformation.getter(SenderIdInformation::monthlyLeasingPrice)).setter(SenderIdInformation.setter(Builder::monthlyLeasingPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonthlyLeasingPrice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENDER_ID_ARN_FIELD, SENDER_ID_FIELD, ISO_COUNTRY_CODE_FIELD, MESSAGE_TYPES_FIELD, MONTHLY_LEASING_PRICE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String senderIdArn;
    private final String senderId;
    private final String isoCountryCode;
    private final List<String> messageTypes;
    private final String monthlyLeasingPrice;

    private SenderIdInformation(BuilderImpl builder) {
        this.senderIdArn = builder.senderIdArn;
        this.senderId = builder.senderId;
        this.isoCountryCode = builder.isoCountryCode;
        this.messageTypes = builder.messageTypes;
        this.monthlyLeasingPrice = builder.monthlyLeasingPrice;
    }

    public final String senderIdArn() {
        return this.senderIdArn;
    }

    public final String senderId() {
        return this.senderId;
    }

    public final String isoCountryCode() {
        return this.isoCountryCode;
    }

    public final List<MessageType> messageTypes() {
        return MessageTypeListCopier.copyStringToEnum(this.messageTypes);
    }

    public final boolean hasMessageTypes() {
        return this.messageTypes != null && !(this.messageTypes instanceof SdkAutoConstructList);
    }

    public final List<String> messageTypesAsStrings() {
        return this.messageTypes;
    }

    public final String monthlyLeasingPrice() {
        return this.monthlyLeasingPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.senderIdArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessageTypes() ? this.messageTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.monthlyLeasingPrice());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SenderIdInformation)) {
            return false;
        }
        SenderIdInformation other = (SenderIdInformation)obj;
        return Objects.equals(this.senderIdArn(), other.senderIdArn()) && Objects.equals(this.senderId(), other.senderId()) && Objects.equals(this.isoCountryCode(), other.isoCountryCode()) && this.hasMessageTypes() == other.hasMessageTypes() && Objects.equals(this.messageTypesAsStrings(), other.messageTypesAsStrings()) && Objects.equals(this.monthlyLeasingPrice(), other.monthlyLeasingPrice());
    }

    public final String toString() {
        return ToString.builder((String)"SenderIdInformation").add("SenderIdArn", (Object)this.senderIdArn()).add("SenderId", (Object)this.senderId()).add("IsoCountryCode", (Object)this.isoCountryCode()).add("MessageTypes", this.hasMessageTypes() ? this.messageTypesAsStrings() : null).add("MonthlyLeasingPrice", (Object)this.monthlyLeasingPrice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SenderIdArn": {
                return Optional.ofNullable(clazz.cast(this.senderIdArn()));
            }
            case "SenderId": {
                return Optional.ofNullable(clazz.cast(this.senderId()));
            }
            case "IsoCountryCode": {
                return Optional.ofNullable(clazz.cast(this.isoCountryCode()));
            }
            case "MessageTypes": {
                return Optional.ofNullable(clazz.cast(this.messageTypesAsStrings()));
            }
            case "MonthlyLeasingPrice": {
                return Optional.ofNullable(clazz.cast(this.monthlyLeasingPrice()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SenderIdInformation, T> g) {
        return obj -> g.apply((SenderIdInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String senderIdArn;
        private String senderId;
        private String isoCountryCode;
        private List<String> messageTypes = DefaultSdkAutoConstructList.getInstance();
        private String monthlyLeasingPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(SenderIdInformation model) {
            this.senderIdArn(model.senderIdArn);
            this.senderId(model.senderId);
            this.isoCountryCode(model.isoCountryCode);
            this.messageTypesWithStrings(model.messageTypes);
            this.monthlyLeasingPrice(model.monthlyLeasingPrice);
        }

        public final String getSenderIdArn() {
            return this.senderIdArn;
        }

        public final void setSenderIdArn(String senderIdArn) {
            this.senderIdArn = senderIdArn;
        }

        @Override
        public final Builder senderIdArn(String senderIdArn) {
            this.senderIdArn = senderIdArn;
            return this;
        }

        public final String getSenderId() {
            return this.senderId;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final String getIsoCountryCode() {
            return this.isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final Collection<String> getMessageTypes() {
            if (this.messageTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.messageTypes;
        }

        public final void setMessageTypes(Collection<String> messageTypes) {
            this.messageTypes = MessageTypeListCopier.copy(messageTypes);
        }

        @Override
        public final Builder messageTypesWithStrings(Collection<String> messageTypes) {
            this.messageTypes = MessageTypeListCopier.copy(messageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageTypesWithStrings(String ... messageTypes) {
            this.messageTypesWithStrings(Arrays.asList(messageTypes));
            return this;
        }

        @Override
        public final Builder messageTypes(Collection<MessageType> messageTypes) {
            this.messageTypes = MessageTypeListCopier.copyEnumToString(messageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageTypes(MessageType ... messageTypes) {
            this.messageTypes(Arrays.asList(messageTypes));
            return this;
        }

        public final String getMonthlyLeasingPrice() {
            return this.monthlyLeasingPrice;
        }

        public final void setMonthlyLeasingPrice(String monthlyLeasingPrice) {
            this.monthlyLeasingPrice = monthlyLeasingPrice;
        }

        @Override
        public final Builder monthlyLeasingPrice(String monthlyLeasingPrice) {
            this.monthlyLeasingPrice = monthlyLeasingPrice;
            return this;
        }

        public SenderIdInformation build() {
            return new SenderIdInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SenderIdInformation> {
        public Builder senderIdArn(String var1);

        public Builder senderId(String var1);

        public Builder isoCountryCode(String var1);

        public Builder messageTypesWithStrings(Collection<String> var1);

        public Builder messageTypesWithStrings(String ... var1);

        public Builder messageTypes(Collection<MessageType> var1);

        public Builder messageTypes(MessageType ... var1);

        public Builder monthlyLeasingPrice(String var1);
    }
}

