/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoice.model.CloudWatchLogsDestination;
import software.amazon.awssdk.services.pinpointsmsvoice.model.EventType;
import software.amazon.awssdk.services.pinpointsmsvoice.model.EventTypesCopier;
import software.amazon.awssdk.services.pinpointsmsvoice.model.KinesisFirehoseDestination;
import software.amazon.awssdk.services.pinpointsmsvoice.model.SnsDestination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventDestination> {
    private static final SdkField<CloudWatchLogsDestination> CLOUD_WATCH_LOGS_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EventDestination.getter(EventDestination::cloudWatchLogsDestination)).setter(EventDestination.setter(Builder::cloudWatchLogsDestination)).constructor(CloudWatchLogsDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsDestination").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(EventDestination.getter(EventDestination::enabled)).setter(EventDestination.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<KinesisFirehoseDestination> KINESIS_FIREHOSE_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EventDestination.getter(EventDestination::kinesisFirehoseDestination)).setter(EventDestination.setter(Builder::kinesisFirehoseDestination)).constructor(KinesisFirehoseDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseDestination").build()}).build();
    private static final SdkField<List<String>> MATCHING_EVENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventDestination.getter(EventDestination::matchingEventTypesAsStrings)).setter(EventDestination.setter(Builder::matchingEventTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchingEventTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EventDestination.getter(EventDestination::name)).setter(EventDestination.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<SnsDestination> SNS_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EventDestination.getter(EventDestination::snsDestination)).setter(EventDestination.setter(Builder::snsDestination)).constructor(SnsDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsDestination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_DESTINATION_FIELD, ENABLED_FIELD, KINESIS_FIREHOSE_DESTINATION_FIELD, MATCHING_EVENT_TYPES_FIELD, NAME_FIELD, SNS_DESTINATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final CloudWatchLogsDestination cloudWatchLogsDestination;
    private final Boolean enabled;
    private final KinesisFirehoseDestination kinesisFirehoseDestination;
    private final List<String> matchingEventTypes;
    private final String name;
    private final SnsDestination snsDestination;

    private EventDestination(BuilderImpl builder) {
        this.cloudWatchLogsDestination = builder.cloudWatchLogsDestination;
        this.enabled = builder.enabled;
        this.kinesisFirehoseDestination = builder.kinesisFirehoseDestination;
        this.matchingEventTypes = builder.matchingEventTypes;
        this.name = builder.name;
        this.snsDestination = builder.snsDestination;
    }

    public CloudWatchLogsDestination cloudWatchLogsDestination() {
        return this.cloudWatchLogsDestination;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public KinesisFirehoseDestination kinesisFirehoseDestination() {
        return this.kinesisFirehoseDestination;
    }

    public List<EventType> matchingEventTypes() {
        return EventTypesCopier.copyStringToEnum(this.matchingEventTypes);
    }

    public List<String> matchingEventTypesAsStrings() {
        return this.matchingEventTypes;
    }

    public String name() {
        return this.name;
    }

    public SnsDestination snsDestination() {
        return this.snsDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisFirehoseDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchingEventTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsDestination());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDestination)) {
            return false;
        }
        EventDestination other = (EventDestination)obj;
        return Objects.equals(this.cloudWatchLogsDestination(), other.cloudWatchLogsDestination()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.kinesisFirehoseDestination(), other.kinesisFirehoseDestination()) && Objects.equals(this.matchingEventTypesAsStrings(), other.matchingEventTypesAsStrings()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.snsDestination(), other.snsDestination());
    }

    public String toString() {
        return ToString.builder((String)"EventDestination").add("CloudWatchLogsDestination", (Object)this.cloudWatchLogsDestination()).add("Enabled", (Object)this.enabled()).add("KinesisFirehoseDestination", (Object)this.kinesisFirehoseDestination()).add("MatchingEventTypes", this.matchingEventTypesAsStrings()).add("Name", (Object)this.name()).add("SnsDestination", (Object)this.snsDestination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchLogsDestination": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsDestination()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "KinesisFirehoseDestination": {
                return Optional.ofNullable(clazz.cast(this.kinesisFirehoseDestination()));
            }
            case "MatchingEventTypes": {
                return Optional.ofNullable(clazz.cast(this.matchingEventTypesAsStrings()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SnsDestination": {
                return Optional.ofNullable(clazz.cast(this.snsDestination()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventDestination, T> g) {
        return obj -> g.apply((EventDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CloudWatchLogsDestination cloudWatchLogsDestination;
        private Boolean enabled;
        private KinesisFirehoseDestination kinesisFirehoseDestination;
        private List<String> matchingEventTypes = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private SnsDestination snsDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(EventDestination model) {
            this.cloudWatchLogsDestination(model.cloudWatchLogsDestination);
            this.enabled(model.enabled);
            this.kinesisFirehoseDestination(model.kinesisFirehoseDestination);
            this.matchingEventTypesWithStrings(model.matchingEventTypes);
            this.name(model.name);
            this.snsDestination(model.snsDestination);
        }

        public final CloudWatchLogsDestination.Builder getCloudWatchLogsDestination() {
            return this.cloudWatchLogsDestination != null ? this.cloudWatchLogsDestination.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLogsDestination(CloudWatchLogsDestination cloudWatchLogsDestination) {
            this.cloudWatchLogsDestination = cloudWatchLogsDestination;
            return this;
        }

        public final void setCloudWatchLogsDestination(CloudWatchLogsDestination.BuilderImpl cloudWatchLogsDestination) {
            this.cloudWatchLogsDestination = cloudWatchLogsDestination != null ? cloudWatchLogsDestination.build() : null;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final KinesisFirehoseDestination.Builder getKinesisFirehoseDestination() {
            return this.kinesisFirehoseDestination != null ? this.kinesisFirehoseDestination.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination;
            return this;
        }

        public final void setKinesisFirehoseDestination(KinesisFirehoseDestination.BuilderImpl kinesisFirehoseDestination) {
            this.kinesisFirehoseDestination = kinesisFirehoseDestination != null ? kinesisFirehoseDestination.build() : null;
        }

        public final Collection<String> getMatchingEventTypesAsStrings() {
            return this.matchingEventTypes;
        }

        @Override
        public final Builder matchingEventTypesWithStrings(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copy(matchingEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingEventTypesWithStrings(String ... matchingEventTypes) {
            this.matchingEventTypesWithStrings(Arrays.asList(matchingEventTypes));
            return this;
        }

        @Override
        public final Builder matchingEventTypes(Collection<EventType> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copyEnumToString(matchingEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingEventTypes(EventType ... matchingEventTypes) {
            this.matchingEventTypes(Arrays.asList(matchingEventTypes));
            return this;
        }

        public final void setMatchingEventTypesWithStrings(Collection<String> matchingEventTypes) {
            this.matchingEventTypes = EventTypesCopier.copy(matchingEventTypes);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final SnsDestination.Builder getSnsDestination() {
            return this.snsDestination != null ? this.snsDestination.toBuilder() : null;
        }

        @Override
        public final Builder snsDestination(SnsDestination snsDestination) {
            this.snsDestination = snsDestination;
            return this;
        }

        public final void setSnsDestination(SnsDestination.BuilderImpl snsDestination) {
            this.snsDestination = snsDestination != null ? snsDestination.build() : null;
        }

        public EventDestination build() {
            return new EventDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventDestination> {
        public Builder cloudWatchLogsDestination(CloudWatchLogsDestination var1);

        default public Builder cloudWatchLogsDestination(Consumer<CloudWatchLogsDestination.Builder> cloudWatchLogsDestination) {
            return this.cloudWatchLogsDestination((CloudWatchLogsDestination)((CloudWatchLogsDestination.Builder)CloudWatchLogsDestination.builder().applyMutation(cloudWatchLogsDestination)).build());
        }

        public Builder enabled(Boolean var1);

        public Builder kinesisFirehoseDestination(KinesisFirehoseDestination var1);

        default public Builder kinesisFirehoseDestination(Consumer<KinesisFirehoseDestination.Builder> kinesisFirehoseDestination) {
            return this.kinesisFirehoseDestination((KinesisFirehoseDestination)((KinesisFirehoseDestination.Builder)KinesisFirehoseDestination.builder().applyMutation(kinesisFirehoseDestination)).build());
        }

        public Builder matchingEventTypesWithStrings(Collection<String> var1);

        public Builder matchingEventTypesWithStrings(String ... var1);

        public Builder matchingEventTypes(Collection<EventType> var1);

        public Builder matchingEventTypes(EventType ... var1);

        public Builder name(String var1);

        public Builder snsDestination(SnsDestination var1);

        default public Builder snsDestination(Consumer<SnsDestination.Builder> snsDestination) {
            return this.snsDestination((SnsDestination)((SnsDestination.Builder)SnsDestination.builder().applyMutation(snsDestination)).build());
        }
    }
}

