/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the conditions for the first activity in a journey. This activity and its conditions determine which users
 * are participants in a journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCondition implements SdkPojo, Serializable, ToCopyableBuilder<StartCondition.Builder, StartCondition> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartCondition::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<SegmentCondition> SEGMENT_START_CONDITION_FIELD = SdkField
            .<SegmentCondition> builder(MarshallingType.SDK_POJO).getter(getter(StartCondition::segmentStartCondition))
            .setter(setter(Builder::segmentStartCondition)).constructor(SegmentCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentStartCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            SEGMENT_START_CONDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final SegmentCondition segmentStartCondition;

    private StartCondition(BuilderImpl builder) {
        this.description = builder.description;
        this.segmentStartCondition = builder.segmentStartCondition;
    }

    /**
     * <p>
     * The custom description of the condition.
     * </p>
     * 
     * @return The custom description of the condition.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The segment that's associated with the first activity in the journey. This segment determines which users are
     * participants in the journey.
     * </p>
     * 
     * @return The segment that's associated with the first activity in the journey. This segment determines which users
     *         are participants in the journey.
     */
    public SegmentCondition segmentStartCondition() {
        return segmentStartCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(segmentStartCondition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCondition)) {
            return false;
        }
        StartCondition other = (StartCondition) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(segmentStartCondition(), other.segmentStartCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartCondition").add("Description", description())
                .add("SegmentStartCondition", segmentStartCondition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SegmentStartCondition":
            return Optional.ofNullable(clazz.cast(segmentStartCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartCondition, T> g) {
        return obj -> g.apply((StartCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartCondition> {
        /**
         * <p>
         * The custom description of the condition.
         * </p>
         * 
         * @param description
         *        The custom description of the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The segment that's associated with the first activity in the journey. This segment determines which users are
         * participants in the journey.
         * </p>
         * 
         * @param segmentStartCondition
         *        The segment that's associated with the first activity in the journey. This segment determines which
         *        users are participants in the journey.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentStartCondition(SegmentCondition segmentStartCondition);

        /**
         * <p>
         * The segment that's associated with the first activity in the journey. This segment determines which users are
         * participants in the journey.
         * </p>
         * This is a convenience that creates an instance of the {@link SegmentCondition.Builder} avoiding the need to
         * create one manually via {@link SegmentCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link SegmentCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #segmentStartCondition(SegmentCondition)}.
         * 
         * @param segmentStartCondition
         *        a consumer that will call methods on {@link SegmentCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentStartCondition(SegmentCondition)
         */
        default Builder segmentStartCondition(Consumer<SegmentCondition.Builder> segmentStartCondition) {
            return segmentStartCondition(SegmentCondition.builder().applyMutation(segmentStartCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private SegmentCondition segmentStartCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCondition model) {
            description(model.description);
            segmentStartCondition(model.segmentStartCondition);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final SegmentCondition.Builder getSegmentStartCondition() {
            return segmentStartCondition != null ? segmentStartCondition.toBuilder() : null;
        }

        @Override
        public final Builder segmentStartCondition(SegmentCondition segmentStartCondition) {
            this.segmentStartCondition = segmentStartCondition;
            return this;
        }

        public final void setSegmentStartCondition(SegmentCondition.BuilderImpl segmentStartCondition) {
            this.segmentStartCondition = segmentStartCondition != null ? segmentStartCondition.build() : null;
        }

        @Override
        public StartCondition build() {
            return new StartCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
