/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the base segments and dimensions for a segment, and the relationships between these base segments and
 * dimensions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SegmentGroup implements SdkPojo, Serializable, ToCopyableBuilder<SegmentGroup.Builder, SegmentGroup> {
    private static final SdkField<List<SegmentDimensions>> DIMENSIONS_FIELD = SdkField
            .<List<SegmentDimensions>> builder(MarshallingType.LIST)
            .getter(getter(SegmentGroup::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SegmentDimensions> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentDimensions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SegmentReference>> SOURCE_SEGMENTS_FIELD = SdkField
            .<List<SegmentReference>> builder(MarshallingType.LIST)
            .getter(getter(SegmentGroup::sourceSegments))
            .setter(setter(Builder::sourceSegments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSegments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SegmentReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentGroup::sourceTypeAsString)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SegmentGroup::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD,
            SOURCE_SEGMENTS_FIELD, SOURCE_TYPE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SegmentDimensions> dimensions;

    private final List<SegmentReference> sourceSegments;

    private final String sourceType;

    private final String type;

    private SegmentGroup(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.sourceSegments = builder.sourceSegments;
        this.sourceType = builder.sourceType;
        this.type = builder.type;
    }

    /**
     * Returns true if the Dimensions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that defines the dimensions for the segment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDimensions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that defines the dimensions for the segment.
     */
    public List<SegmentDimensions> dimensions() {
        return dimensions;
    }

    /**
     * Returns true if the SourceSegments property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSourceSegments() {
        return sourceSegments != null && !(sourceSegments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The base segment to build the segment on. A base segment, also referred to as a <i>source segment</i>, defines
     * the initial population of endpoints for a segment. When you add dimensions to a segment, Amazon Pinpoint filters
     * the base segment by using the dimensions that you specify.
     * </p>
     * <p>
     * You can specify more than one dimensional segment or only one imported segment. If you specify an imported
     * segment, the Amazon Pinpoint console displays a segment size estimate that indicates the size of the imported
     * segment without any filters applied to it.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSourceSegments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The base segment to build the segment on. A base segment, also referred to as a <i>source segment</i>,
     *         defines the initial population of endpoints for a segment. When you add dimensions to a segment, Amazon
     *         Pinpoint filters the base segment by using the dimensions that you specify.</p>
     *         <p>
     *         You can specify more than one dimensional segment or only one imported segment. If you specify an
     *         imported segment, the Amazon Pinpoint console displays a segment size estimate that indicates the size of
     *         the imported segment without any filters applied to it.
     */
    public List<SegmentReference> sourceSegments() {
        return sourceSegments;
    }

    /**
     * <p>
     * Specifies how to handle multiple base segments for the segment. For example, if you specify three base segments
     * for the segment, whether the resulting segment is based on all, any, or none of the base segments.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Specifies how to handle multiple base segments for the segment. For example, if you specify three base
     *         segments for the segment, whether the resulting segment is based on all, any, or none of the base
     *         segments.
     * @see SourceType
     */
    public SourceType sourceType() {
        return SourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * Specifies how to handle multiple base segments for the segment. For example, if you specify three base segments
     * for the segment, whether the resulting segment is based on all, any, or none of the base segments.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link SourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Specifies how to handle multiple base segments for the segment. For example, if you specify three base
     *         segments for the segment, whether the resulting segment is based on all, any, or none of the base
     *         segments.
     * @see SourceType
     */
    public String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * Specifies how to handle multiple dimensions for the segment. For example, if you specify three dimensions for the
     * segment, whether the resulting segment includes endpoints that match all, any, or none of the dimensions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies how to handle multiple dimensions for the segment. For example, if you specify three dimensions
     *         for the segment, whether the resulting segment includes endpoints that match all, any, or none of the
     *         dimensions.
     * @see Type
     */
    public Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * Specifies how to handle multiple dimensions for the segment. For example, if you specify three dimensions for the
     * segment, whether the resulting segment includes endpoints that match all, any, or none of the dimensions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies how to handle multiple dimensions for the segment. For example, if you specify three dimensions
     *         for the segment, whether the resulting segment includes endpoints that match all, any, or none of the
     *         dimensions.
     * @see Type
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSegments());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentGroup)) {
            return false;
        }
        SegmentGroup other = (SegmentGroup) obj;
        return Objects.equals(dimensions(), other.dimensions()) && Objects.equals(sourceSegments(), other.sourceSegments())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SegmentGroup").add("Dimensions", dimensions()).add("SourceSegments", sourceSegments())
                .add("SourceType", sourceTypeAsString()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "SourceSegments":
            return Optional.ofNullable(clazz.cast(sourceSegments()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentGroup, T> g) {
        return obj -> g.apply((SegmentGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SegmentGroup> {
        /**
         * <p>
         * An array that defines the dimensions for the segment.
         * </p>
         * 
         * @param dimensions
         *        An array that defines the dimensions for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<SegmentDimensions> dimensions);

        /**
         * <p>
         * An array that defines the dimensions for the segment.
         * </p>
         * 
         * @param dimensions
         *        An array that defines the dimensions for the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(SegmentDimensions... dimensions);

        /**
         * <p>
         * An array that defines the dimensions for the segment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SegmentDimensions>.Builder} avoiding the
         * need to create one manually via {@link List<SegmentDimensions>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SegmentDimensions>.Builder#build()} is called immediately
         * and its result is passed to {@link #dimensions(List<SegmentDimensions>)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link List<SegmentDimensions>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(List<SegmentDimensions>)
         */
        Builder dimensions(Consumer<SegmentDimensions.Builder>... dimensions);

        /**
         * <p>
         * The base segment to build the segment on. A base segment, also referred to as a <i>source segment</i>,
         * defines the initial population of endpoints for a segment. When you add dimensions to a segment, Amazon
         * Pinpoint filters the base segment by using the dimensions that you specify.
         * </p>
         * <p>
         * You can specify more than one dimensional segment or only one imported segment. If you specify an imported
         * segment, the Amazon Pinpoint console displays a segment size estimate that indicates the size of the imported
         * segment without any filters applied to it.
         * </p>
         * 
         * @param sourceSegments
         *        The base segment to build the segment on. A base segment, also referred to as a <i>source segment</i>,
         *        defines the initial population of endpoints for a segment. When you add dimensions to a segment,
         *        Amazon Pinpoint filters the base segment by using the dimensions that you specify.</p>
         *        <p>
         *        You can specify more than one dimensional segment or only one imported segment. If you specify an
         *        imported segment, the Amazon Pinpoint console displays a segment size estimate that indicates the size
         *        of the imported segment without any filters applied to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSegments(Collection<SegmentReference> sourceSegments);

        /**
         * <p>
         * The base segment to build the segment on. A base segment, also referred to as a <i>source segment</i>,
         * defines the initial population of endpoints for a segment. When you add dimensions to a segment, Amazon
         * Pinpoint filters the base segment by using the dimensions that you specify.
         * </p>
         * <p>
         * You can specify more than one dimensional segment or only one imported segment. If you specify an imported
         * segment, the Amazon Pinpoint console displays a segment size estimate that indicates the size of the imported
         * segment without any filters applied to it.
         * </p>
         * 
         * @param sourceSegments
         *        The base segment to build the segment on. A base segment, also referred to as a <i>source segment</i>,
         *        defines the initial population of endpoints for a segment. When you add dimensions to a segment,
         *        Amazon Pinpoint filters the base segment by using the dimensions that you specify.</p>
         *        <p>
         *        You can specify more than one dimensional segment or only one imported segment. If you specify an
         *        imported segment, the Amazon Pinpoint console displays a segment size estimate that indicates the size
         *        of the imported segment without any filters applied to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSegments(SegmentReference... sourceSegments);

        /**
         * <p>
         * The base segment to build the segment on. A base segment, also referred to as a <i>source segment</i>,
         * defines the initial population of endpoints for a segment. When you add dimensions to a segment, Amazon
         * Pinpoint filters the base segment by using the dimensions that you specify.
         * </p>
         * <p>
         * You can specify more than one dimensional segment or only one imported segment. If you specify an imported
         * segment, the Amazon Pinpoint console displays a segment size estimate that indicates the size of the imported
         * segment without any filters applied to it.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SegmentReference>.Builder} avoiding the
         * need to create one manually via {@link List<SegmentReference>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SegmentReference>.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceSegments(List<SegmentReference>)}.
         * 
         * @param sourceSegments
         *        a consumer that will call methods on {@link List<SegmentReference>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceSegments(List<SegmentReference>)
         */
        Builder sourceSegments(Consumer<SegmentReference.Builder>... sourceSegments);

        /**
         * <p>
         * Specifies how to handle multiple base segments for the segment. For example, if you specify three base
         * segments for the segment, whether the resulting segment is based on all, any, or none of the base segments.
         * </p>
         * 
         * @param sourceType
         *        Specifies how to handle multiple base segments for the segment. For example, if you specify three base
         *        segments for the segment, whether the resulting segment is based on all, any, or none of the base
         *        segments.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * Specifies how to handle multiple base segments for the segment. For example, if you specify three base
         * segments for the segment, whether the resulting segment is based on all, any, or none of the base segments.
         * </p>
         * 
         * @param sourceType
         *        Specifies how to handle multiple base segments for the segment. For example, if you specify three base
         *        segments for the segment, whether the resulting segment is based on all, any, or none of the base
         *        segments.
         * @see SourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceType
         */
        Builder sourceType(SourceType sourceType);

        /**
         * <p>
         * Specifies how to handle multiple dimensions for the segment. For example, if you specify three dimensions for
         * the segment, whether the resulting segment includes endpoints that match all, any, or none of the dimensions.
         * </p>
         * 
         * @param type
         *        Specifies how to handle multiple dimensions for the segment. For example, if you specify three
         *        dimensions for the segment, whether the resulting segment includes endpoints that match all, any, or
         *        none of the dimensions.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies how to handle multiple dimensions for the segment. For example, if you specify three dimensions for
         * the segment, whether the resulting segment includes endpoints that match all, any, or none of the dimensions.
         * </p>
         * 
         * @param type
         *        Specifies how to handle multiple dimensions for the segment. For example, if you specify three
         *        dimensions for the segment, whether the resulting segment includes endpoints that match all, any, or
         *        none of the dimensions.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);
    }

    static final class BuilderImpl implements Builder {
        private List<SegmentDimensions> dimensions = DefaultSdkAutoConstructList.getInstance();

        private List<SegmentReference> sourceSegments = DefaultSdkAutoConstructList.getInstance();

        private String sourceType;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentGroup model) {
            dimensions(model.dimensions);
            sourceSegments(model.sourceSegments);
            sourceType(model.sourceType);
            type(model.type);
        }

        public final Collection<SegmentDimensions.Builder> getDimensions() {
            return dimensions != null ? dimensions.stream().map(SegmentDimensions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<SegmentDimensions> dimensions) {
            this.dimensions = ListOfSegmentDimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(SegmentDimensions... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<SegmentDimensions.Builder>... dimensions) {
            dimensions(Stream.of(dimensions).map(c -> SegmentDimensions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDimensions(Collection<SegmentDimensions.BuilderImpl> dimensions) {
            this.dimensions = ListOfSegmentDimensionsCopier.copyFromBuilder(dimensions);
        }

        public final Collection<SegmentReference.Builder> getSourceSegments() {
            return sourceSegments != null ? sourceSegments.stream().map(SegmentReference::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder sourceSegments(Collection<SegmentReference> sourceSegments) {
            this.sourceSegments = ListOfSegmentReferenceCopier.copy(sourceSegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceSegments(SegmentReference... sourceSegments) {
            sourceSegments(Arrays.asList(sourceSegments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceSegments(Consumer<SegmentReference.Builder>... sourceSegments) {
            sourceSegments(Stream.of(sourceSegments).map(c -> SegmentReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSourceSegments(Collection<SegmentReference.BuilderImpl> sourceSegments) {
            this.sourceSegments = ListOfSegmentReferenceCopier.copyFromBuilder(sourceSegments);
        }

        public final String getSourceTypeAsString() {
            return sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public SegmentGroup build() {
            return new SegmentGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
