/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pi.PiClient;
import software.amazon.awssdk.services.pi.model.GetResourceMetricsRequest;
import software.amazon.awssdk.services.pi.model.GetResourceMetricsResponse;

public class GetResourceMetricsIterable
implements SdkIterable<GetResourceMetricsResponse> {
    private final PiClient client;
    private final GetResourceMetricsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetResourceMetricsIterable(PiClient client, GetResourceMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetResourceMetricsResponseFetcher();
    }

    public Iterator<GetResourceMetricsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetResourceMetricsResponseFetcher
    implements SyncPageFetcher<GetResourceMetricsResponse> {
        private GetResourceMetricsResponseFetcher() {
        }

        public boolean hasNextPage(GetResourceMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetResourceMetricsResponse nextPage(GetResourceMetricsResponse previousPage) {
            if (previousPage == null) {
                return GetResourceMetricsIterable.this.client.getResourceMetrics(GetResourceMetricsIterable.this.firstRequest);
            }
            return GetResourceMetricsIterable.this.client.getResourceMetrics((GetResourceMetricsRequest)((Object)GetResourceMetricsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

