/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlgorithmImage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlgorithmImage> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AlgorithmImage.getter(AlgorithmImage::name)).setter(AlgorithmImage.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DOCKER_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AlgorithmImage.getter(AlgorithmImage::dockerURI)).setter(AlgorithmImage.setter(Builder::dockerURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerURI").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DOCKER_URI_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String dockerURI;

    private AlgorithmImage(BuilderImpl builder) {
        this.name = builder.name;
        this.dockerURI = builder.dockerURI;
    }

    public String name() {
        return this.name;
    }

    public String dockerURI() {
        return this.dockerURI;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.dockerURI());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmImage)) {
            return false;
        }
        AlgorithmImage other = (AlgorithmImage)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.dockerURI(), other.dockerURI());
    }

    public String toString() {
        return ToString.builder((String)"AlgorithmImage").add("Name", (Object)this.name()).add("DockerURI", (Object)this.dockerURI()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "dockerURI": {
                return Optional.ofNullable(clazz.cast(this.dockerURI()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlgorithmImage, T> g) {
        return obj -> g.apply((AlgorithmImage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String dockerURI;

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmImage model) {
            this.name(model.name);
            this.dockerURI(model.dockerURI);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDockerURI() {
            return this.dockerURI;
        }

        @Override
        public final Builder dockerURI(String dockerURI) {
            this.dockerURI = dockerURI;
            return this;
        }

        public final void setDockerURI(String dockerURI) {
            this.dockerURI = dockerURI;
        }

        public AlgorithmImage build() {
            return new AlgorithmImage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlgorithmImage> {
        public Builder name(String var1);

        public Builder dockerURI(String var1);
    }
}

