/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.DatasetImportJobSummary;
import software.amazon.awssdk.services.personalize.model.DatasetImportJobsCopier;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatasetImportJobsResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, ListDatasetImportJobsResponse> {
    private static final SdkField<List<DatasetImportJobSummary>> DATASET_IMPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("datasetImportJobs").getter(ListDatasetImportJobsResponse.getter(ListDatasetImportJobsResponse::datasetImportJobs)).setter(ListDatasetImportJobsResponse.setter(Builder::datasetImportJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetImportJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetImportJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDatasetImportJobsResponse.getter(ListDatasetImportJobsResponse::nextToken)).setter(ListDatasetImportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IMPORT_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDatasetImportJobsResponse.memberNameToFieldInitializer();
    private final List<DatasetImportJobSummary> datasetImportJobs;
    private final String nextToken;

    private ListDatasetImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.datasetImportJobs = builder.datasetImportJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDatasetImportJobs() {
        return this.datasetImportJobs != null && !(this.datasetImportJobs instanceof SdkAutoConstructList);
    }

    public final List<DatasetImportJobSummary> datasetImportJobs() {
        return this.datasetImportJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasetImportJobs() ? this.datasetImportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetImportJobsResponse)) {
            return false;
        }
        ListDatasetImportJobsResponse other = (ListDatasetImportJobsResponse)((Object)obj);
        return this.hasDatasetImportJobs() == other.hasDatasetImportJobs() && Objects.equals(this.datasetImportJobs(), other.datasetImportJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDatasetImportJobsResponse").add("DatasetImportJobs", this.hasDatasetImportJobs() ? this.datasetImportJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetImportJobs": {
                return Optional.ofNullable(clazz.cast(this.datasetImportJobs()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datasetImportJobs", DATASET_IMPORT_JOBS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetImportJobsResponse, T> g) {
        return obj -> g.apply((ListDatasetImportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private List<DatasetImportJobSummary> datasetImportJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetImportJobsResponse model) {
            super(model);
            this.datasetImportJobs(model.datasetImportJobs);
            this.nextToken(model.nextToken);
        }

        public final List<DatasetImportJobSummary.Builder> getDatasetImportJobs() {
            List<DatasetImportJobSummary.Builder> result = DatasetImportJobsCopier.copyToBuilder(this.datasetImportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasetImportJobs(Collection<DatasetImportJobSummary.BuilderImpl> datasetImportJobs) {
            this.datasetImportJobs = DatasetImportJobsCopier.copyFromBuilder(datasetImportJobs);
        }

        @Override
        public final Builder datasetImportJobs(Collection<DatasetImportJobSummary> datasetImportJobs) {
            this.datasetImportJobs = DatasetImportJobsCopier.copy(datasetImportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetImportJobs(DatasetImportJobSummary ... datasetImportJobs) {
            this.datasetImportJobs(Arrays.asList(datasetImportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetImportJobs(Consumer<DatasetImportJobSummary.Builder> ... datasetImportJobs) {
            this.datasetImportJobs(Stream.of(datasetImportJobs).map(c -> (DatasetImportJobSummary)((DatasetImportJobSummary.Builder)DatasetImportJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDatasetImportJobsResponse build() {
            return new ListDatasetImportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatasetImportJobsResponse> {
        public Builder datasetImportJobs(Collection<DatasetImportJobSummary> var1);

        public Builder datasetImportJobs(DatasetImportJobSummary ... var1);

        public Builder datasetImportJobs(Consumer<DatasetImportJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

