/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalize.model.ExcludedDatasetColumnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingDataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingDataConfig> {
    private static final SdkField<Map<String, List<String>>> EXCLUDED_DATASET_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("excludedDatasetColumns").getter(TrainingDataConfig.getter(TrainingDataConfig::excludedDatasetColumns)).setter(TrainingDataConfig.setter(Builder::excludedDatasetColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludedDatasetColumns").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUDED_DATASET_COLUMNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("excludedDatasetColumns", EXCLUDED_DATASET_COLUMNS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Map<String, List<String>> excludedDatasetColumns;

    private TrainingDataConfig(BuilderImpl builder) {
        this.excludedDatasetColumns = builder.excludedDatasetColumns;
    }

    public final boolean hasExcludedDatasetColumns() {
        return this.excludedDatasetColumns != null && !(this.excludedDatasetColumns instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> excludedDatasetColumns() {
        return this.excludedDatasetColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedDatasetColumns() ? this.excludedDatasetColumns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingDataConfig)) {
            return false;
        }
        TrainingDataConfig other = (TrainingDataConfig)obj;
        return this.hasExcludedDatasetColumns() == other.hasExcludedDatasetColumns() && Objects.equals(this.excludedDatasetColumns(), other.excludedDatasetColumns());
    }

    public final String toString() {
        return ToString.builder((String)"TrainingDataConfig").add("ExcludedDatasetColumns", this.hasExcludedDatasetColumns() ? this.excludedDatasetColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "excludedDatasetColumns": {
                return Optional.ofNullable(clazz.cast(this.excludedDatasetColumns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TrainingDataConfig, T> g) {
        return obj -> g.apply((TrainingDataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, List<String>> excludedDatasetColumns = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingDataConfig model) {
            this.excludedDatasetColumns(model.excludedDatasetColumns);
        }

        public final Map<String, ? extends Collection<String>> getExcludedDatasetColumns() {
            if (this.excludedDatasetColumns instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.excludedDatasetColumns;
        }

        public final void setExcludedDatasetColumns(Map<String, ? extends Collection<String>> excludedDatasetColumns) {
            this.excludedDatasetColumns = ExcludedDatasetColumnsCopier.copy(excludedDatasetColumns);
        }

        @Override
        public final Builder excludedDatasetColumns(Map<String, ? extends Collection<String>> excludedDatasetColumns) {
            this.excludedDatasetColumns = ExcludedDatasetColumnsCopier.copy(excludedDatasetColumns);
            return this;
        }

        public TrainingDataConfig build() {
            return new TrainingDataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingDataConfig> {
        public Builder excludedDatasetColumns(Map<String, ? extends Collection<String>> var1);
    }
}

