/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.internal.UserAgentUtils;
import software.amazon.awssdk.services.personalize.model.ListSolutionVersionsRequest;
import software.amazon.awssdk.services.personalize.model.ListSolutionVersionsResponse;
import software.amazon.awssdk.services.personalize.model.SolutionVersionSummary;

public class ListSolutionVersionsIterable
implements SdkIterable<ListSolutionVersionsResponse> {
    private final PersonalizeClient client;
    private final ListSolutionVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSolutionVersionsIterable(PersonalizeClient client, ListSolutionVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSolutionVersionsResponseFetcher();
    }

    public Iterator<ListSolutionVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SolutionVersionSummary> solutionVersions() {
        Function<ListSolutionVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.solutionVersions() != null) {
                return response.solutionVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSolutionVersionsResponseFetcher
    implements SyncPageFetcher<ListSolutionVersionsResponse> {
        private ListSolutionVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSolutionVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSolutionVersionsResponse nextPage(ListSolutionVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListSolutionVersionsIterable.this.client.listSolutionVersions(ListSolutionVersionsIterable.this.firstRequest);
            }
            return ListSolutionVersionsIterable.this.client.listSolutionVersions((ListSolutionVersionsRequest)((Object)ListSolutionVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

