/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.personalize.model.AutoMLResult;
import software.amazon.awssdk.services.personalize.model.SolutionConfig;
import software.amazon.awssdk.services.personalize.model.SolutionVersionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Solution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Solution> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Solution.getter(Solution::name)).setter(Solution.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SOLUTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("solutionArn").getter(Solution.getter(Solution::solutionArn)).setter(Solution.setter(Builder::solutionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionArn").build()}).build();
    private static final SdkField<Boolean> PERFORM_HPO_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("performHPO").getter(Solution.getter(Solution::performHPO)).setter(Solution.setter(Builder::performHPO)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performHPO").build()}).build();
    private static final SdkField<Boolean> PERFORM_AUTO_ML_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("performAutoML").getter(Solution.getter(Solution::performAutoML)).setter(Solution.setter(Builder::performAutoML)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performAutoML").build()}).build();
    private static final SdkField<String> RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recipeArn").getter(Solution.getter(Solution::recipeArn)).setter(Solution.setter(Builder::recipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeArn").build()}).build();
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetGroupArn").getter(Solution.getter(Solution::datasetGroupArn)).setter(Solution.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetGroupArn").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(Solution.getter(Solution::eventType)).setter(Solution.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<SolutionConfig> SOLUTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("solutionConfig").getter(Solution.getter(Solution::solutionConfig)).setter(Solution.setter(Builder::solutionConfig)).constructor(SolutionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionConfig").build()}).build();
    private static final SdkField<AutoMLResult> AUTO_ML_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoMLResult").getter(Solution.getter(Solution::autoMLResult)).setter(Solution.setter(Builder::autoMLResult)).constructor(AutoMLResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoMLResult").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Solution.getter(Solution::status)).setter(Solution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(Solution.getter(Solution::creationDateTime)).setter(Solution.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(Solution.getter(Solution::lastUpdatedDateTime)).setter(Solution.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final SdkField<SolutionVersionSummary> LATEST_SOLUTION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestSolutionVersion").getter(Solution.getter(Solution::latestSolutionVersion)).setter(Solution.setter(Builder::latestSolutionVersion)).constructor(SolutionVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestSolutionVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SOLUTION_ARN_FIELD, PERFORM_HPO_FIELD, PERFORM_AUTO_ML_FIELD, RECIPE_ARN_FIELD, DATASET_GROUP_ARN_FIELD, EVENT_TYPE_FIELD, SOLUTION_CONFIG_FIELD, AUTO_ML_RESULT_FIELD, STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, LATEST_SOLUTION_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String solutionArn;
    private final Boolean performHPO;
    private final Boolean performAutoML;
    private final String recipeArn;
    private final String datasetGroupArn;
    private final String eventType;
    private final SolutionConfig solutionConfig;
    private final AutoMLResult autoMLResult;
    private final String status;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;
    private final SolutionVersionSummary latestSolutionVersion;

    private Solution(BuilderImpl builder) {
        this.name = builder.name;
        this.solutionArn = builder.solutionArn;
        this.performHPO = builder.performHPO;
        this.performAutoML = builder.performAutoML;
        this.recipeArn = builder.recipeArn;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.eventType = builder.eventType;
        this.solutionConfig = builder.solutionConfig;
        this.autoMLResult = builder.autoMLResult;
        this.status = builder.status;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.latestSolutionVersion = builder.latestSolutionVersion;
    }

    public final String name() {
        return this.name;
    }

    public final String solutionArn() {
        return this.solutionArn;
    }

    public final Boolean performHPO() {
        return this.performHPO;
    }

    public final Boolean performAutoML() {
        return this.performAutoML;
    }

    public final String recipeArn() {
        return this.recipeArn;
    }

    public final String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public final String eventType() {
        return this.eventType;
    }

    public final SolutionConfig solutionConfig() {
        return this.solutionConfig;
    }

    public final AutoMLResult autoMLResult() {
        return this.autoMLResult;
    }

    public final String status() {
        return this.status;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final SolutionVersionSummary latestSolutionVersion() {
        return this.latestSolutionVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.performHPO());
        hashCode = 31 * hashCode + Objects.hashCode(this.performAutoML());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestSolutionVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Solution)) {
            return false;
        }
        Solution other = (Solution)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.solutionArn(), other.solutionArn()) && Objects.equals(this.performHPO(), other.performHPO()) && Objects.equals(this.performAutoML(), other.performAutoML()) && Objects.equals(this.recipeArn(), other.recipeArn()) && Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && Objects.equals(this.eventType(), other.eventType()) && Objects.equals(this.solutionConfig(), other.solutionConfig()) && Objects.equals(this.autoMLResult(), other.autoMLResult()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.latestSolutionVersion(), other.latestSolutionVersion());
    }

    public final String toString() {
        return ToString.builder((String)"Solution").add("Name", (Object)this.name()).add("SolutionArn", (Object)this.solutionArn()).add("PerformHPO", (Object)this.performHPO()).add("PerformAutoML", (Object)this.performAutoML()).add("RecipeArn", (Object)this.recipeArn()).add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("EventType", (Object)this.eventType()).add("SolutionConfig", (Object)this.solutionConfig()).add("AutoMLResult", (Object)this.autoMLResult()).add("Status", (Object)this.status()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("LatestSolutionVersion", (Object)this.latestSolutionVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "solutionArn": {
                return Optional.ofNullable(clazz.cast(this.solutionArn()));
            }
            case "performHPO": {
                return Optional.ofNullable(clazz.cast(this.performHPO()));
            }
            case "performAutoML": {
                return Optional.ofNullable(clazz.cast(this.performAutoML()));
            }
            case "recipeArn": {
                return Optional.ofNullable(clazz.cast(this.recipeArn()));
            }
            case "datasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "solutionConfig": {
                return Optional.ofNullable(clazz.cast(this.solutionConfig()));
            }
            case "autoMLResult": {
                return Optional.ofNullable(clazz.cast(this.autoMLResult()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "latestSolutionVersion": {
                return Optional.ofNullable(clazz.cast(this.latestSolutionVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Solution, T> g) {
        return obj -> g.apply((Solution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String solutionArn;
        private Boolean performHPO;
        private Boolean performAutoML;
        private String recipeArn;
        private String datasetGroupArn;
        private String eventType;
        private SolutionConfig solutionConfig;
        private AutoMLResult autoMLResult;
        private String status;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;
        private SolutionVersionSummary latestSolutionVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Solution model) {
            this.name(model.name);
            this.solutionArn(model.solutionArn);
            this.performHPO(model.performHPO);
            this.performAutoML(model.performAutoML);
            this.recipeArn(model.recipeArn);
            this.datasetGroupArn(model.datasetGroupArn);
            this.eventType(model.eventType);
            this.solutionConfig(model.solutionConfig);
            this.autoMLResult(model.autoMLResult);
            this.status(model.status);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.latestSolutionVersion(model.latestSolutionVersion);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSolutionArn() {
            return this.solutionArn;
        }

        public final void setSolutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
        }

        @Override
        @Transient
        public final Builder solutionArn(String solutionArn) {
            this.solutionArn = solutionArn;
            return this;
        }

        public final Boolean getPerformHPO() {
            return this.performHPO;
        }

        public final void setPerformHPO(Boolean performHPO) {
            this.performHPO = performHPO;
        }

        @Override
        @Transient
        public final Builder performHPO(Boolean performHPO) {
            this.performHPO = performHPO;
            return this;
        }

        public final Boolean getPerformAutoML() {
            return this.performAutoML;
        }

        public final void setPerformAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
        }

        @Override
        @Transient
        public final Builder performAutoML(Boolean performAutoML) {
            this.performAutoML = performAutoML;
            return this;
        }

        public final String getRecipeArn() {
            return this.recipeArn;
        }

        public final void setRecipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
        }

        @Override
        @Transient
        public final Builder recipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
            return this;
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        @Transient
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        @Transient
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final SolutionConfig.Builder getSolutionConfig() {
            return this.solutionConfig != null ? this.solutionConfig.toBuilder() : null;
        }

        public final void setSolutionConfig(SolutionConfig.BuilderImpl solutionConfig) {
            this.solutionConfig = solutionConfig != null ? solutionConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder solutionConfig(SolutionConfig solutionConfig) {
            this.solutionConfig = solutionConfig;
            return this;
        }

        public final AutoMLResult.Builder getAutoMLResult() {
            return this.autoMLResult != null ? this.autoMLResult.toBuilder() : null;
        }

        public final void setAutoMLResult(AutoMLResult.BuilderImpl autoMLResult) {
            this.autoMLResult = autoMLResult != null ? autoMLResult.build() : null;
        }

        @Override
        @Transient
        public final Builder autoMLResult(AutoMLResult autoMLResult) {
            this.autoMLResult = autoMLResult;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final SolutionVersionSummary.Builder getLatestSolutionVersion() {
            return this.latestSolutionVersion != null ? this.latestSolutionVersion.toBuilder() : null;
        }

        public final void setLatestSolutionVersion(SolutionVersionSummary.BuilderImpl latestSolutionVersion) {
            this.latestSolutionVersion = latestSolutionVersion != null ? latestSolutionVersion.build() : null;
        }

        @Override
        @Transient
        public final Builder latestSolutionVersion(SolutionVersionSummary latestSolutionVersion) {
            this.latestSolutionVersion = latestSolutionVersion;
            return this;
        }

        public Solution build() {
            return new Solution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Solution> {
        public Builder name(String var1);

        public Builder solutionArn(String var1);

        public Builder performHPO(Boolean var1);

        public Builder performAutoML(Boolean var1);

        public Builder recipeArn(String var1);

        public Builder datasetGroupArn(String var1);

        public Builder eventType(String var1);

        public Builder solutionConfig(SolutionConfig var1);

        default public Builder solutionConfig(Consumer<SolutionConfig.Builder> solutionConfig) {
            return this.solutionConfig((SolutionConfig)((SolutionConfig.Builder)SolutionConfig.builder().applyMutation(solutionConfig)).build());
        }

        public Builder autoMLResult(AutoMLResult var1);

        default public Builder autoMLResult(Consumer<AutoMLResult.Builder> autoMLResult) {
            return this.autoMLResult((AutoMLResult)((AutoMLResult.Builder)AutoMLResult.builder().applyMutation(autoMLResult)).build());
        }

        public Builder status(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder latestSolutionVersion(SolutionVersionSummary var1);

        default public Builder latestSolutionVersion(Consumer<SolutionVersionSummary.Builder> latestSolutionVersion) {
            return this.latestSolutionVersion((SolutionVersionSummary)((SolutionVersionSummary.Builder)SolutionVersionSummary.builder().applyMutation(latestSolutionVersion)).build());
        }
    }
}

