/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeAsyncClient;
import software.amazon.awssdk.services.personalize.model.DatasetExportJobSummary;
import software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListDatasetExportJobsResponse;

public class ListDatasetExportJobsPublisher
implements SdkPublisher<ListDatasetExportJobsResponse> {
    private final PersonalizeAsyncClient client;
    private final ListDatasetExportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDatasetExportJobsPublisher(PersonalizeAsyncClient client, ListDatasetExportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDatasetExportJobsPublisher(PersonalizeAsyncClient client, ListDatasetExportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDatasetExportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDatasetExportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DatasetExportJobSummary> datasetExportJobs() {
        Function<ListDatasetExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.datasetExportJobs() != null) {
                return response.datasetExportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDatasetExportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDatasetExportJobsResponseFetcher
    implements AsyncPageFetcher<ListDatasetExportJobsResponse> {
        private ListDatasetExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDatasetExportJobsResponse> nextPage(ListDatasetExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetExportJobsPublisher.this.client.listDatasetExportJobs(ListDatasetExportJobsPublisher.this.firstRequest);
            }
            return ListDatasetExportJobsPublisher.this.client.listDatasetExportJobs((ListDatasetExportJobsRequest)((Object)ListDatasetExportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

