/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.personalize.model.HyperParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TunedHPOParams
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TunedHPOParams> {
    private static final SdkField<Map<String, String>> ALGORITHM_HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("algorithmHyperParameters").getter(TunedHPOParams.getter(TunedHPOParams::algorithmHyperParameters)).setter(TunedHPOParams.setter(Builder::algorithmHyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmHyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_HYPER_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> algorithmHyperParameters;

    private TunedHPOParams(BuilderImpl builder) {
        this.algorithmHyperParameters = builder.algorithmHyperParameters;
    }

    public boolean hasAlgorithmHyperParameters() {
        return this.algorithmHyperParameters != null && !(this.algorithmHyperParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> algorithmHyperParameters() {
        return this.algorithmHyperParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmHyperParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TunedHPOParams)) {
            return false;
        }
        TunedHPOParams other = (TunedHPOParams)obj;
        return Objects.equals(this.algorithmHyperParameters(), other.algorithmHyperParameters());
    }

    public String toString() {
        return ToString.builder((String)"TunedHPOParams").add("AlgorithmHyperParameters", this.algorithmHyperParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "algorithmHyperParameters": {
                return Optional.ofNullable(clazz.cast(this.algorithmHyperParameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TunedHPOParams, T> g) {
        return obj -> g.apply((TunedHPOParams)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> algorithmHyperParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TunedHPOParams model) {
            this.algorithmHyperParameters(model.algorithmHyperParameters);
        }

        public final Map<String, String> getAlgorithmHyperParameters() {
            return this.algorithmHyperParameters;
        }

        @Override
        public final Builder algorithmHyperParameters(Map<String, String> algorithmHyperParameters) {
            this.algorithmHyperParameters = HyperParametersCopier.copy(algorithmHyperParameters);
            return this;
        }

        public final void setAlgorithmHyperParameters(Map<String, String> algorithmHyperParameters) {
            this.algorithmHyperParameters = HyperParametersCopier.copy(algorithmHyperParameters);
        }

        public TunedHPOParams build() {
            return new TunedHPOParams(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TunedHPOParams> {
        public Builder algorithmHyperParameters(Map<String, String> var1);
    }
}

