/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TrainingMode {
    FULL("FULL"),
    UPDATE("UPDATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TrainingMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrainingMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TrainingMode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrainingMode> knownValues() {
        return Stream.of(TrainingMode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

