/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcaconnectorad.model.AccessRights;
import software.amazon.awssdk.services.pcaconnectorad.model.PcaConnectorAdRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTemplateGroupAccessControlEntryRequest
extends PcaConnectorAdRequest
implements ToCopyableBuilder<Builder, UpdateTemplateGroupAccessControlEntryRequest> {
    private static final SdkField<AccessRights> ACCESS_RIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessRights").getter(UpdateTemplateGroupAccessControlEntryRequest.getter(UpdateTemplateGroupAccessControlEntryRequest::accessRights)).setter(UpdateTemplateGroupAccessControlEntryRequest.setter(Builder::accessRights)).constructor(AccessRights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRights").build()}).build();
    private static final SdkField<String> GROUP_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupDisplayName").getter(UpdateTemplateGroupAccessControlEntryRequest.getter(UpdateTemplateGroupAccessControlEntryRequest::groupDisplayName)).setter(UpdateTemplateGroupAccessControlEntryRequest.setter(Builder::groupDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupDisplayName").build()}).build();
    private static final SdkField<String> GROUP_SECURITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupSecurityIdentifier").getter(UpdateTemplateGroupAccessControlEntryRequest.getter(UpdateTemplateGroupAccessControlEntryRequest::groupSecurityIdentifier)).setter(UpdateTemplateGroupAccessControlEntryRequest.setter(Builder::groupSecurityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("GroupSecurityIdentifier").build()}).build();
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateArn").getter(UpdateTemplateGroupAccessControlEntryRequest.getter(UpdateTemplateGroupAccessControlEntryRequest::templateArn)).setter(UpdateTemplateGroupAccessControlEntryRequest.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_RIGHTS_FIELD, GROUP_DISPLAY_NAME_FIELD, GROUP_SECURITY_IDENTIFIER_FIELD, TEMPLATE_ARN_FIELD));
    private final AccessRights accessRights;
    private final String groupDisplayName;
    private final String groupSecurityIdentifier;
    private final String templateArn;

    private UpdateTemplateGroupAccessControlEntryRequest(BuilderImpl builder) {
        super(builder);
        this.accessRights = builder.accessRights;
        this.groupDisplayName = builder.groupDisplayName;
        this.groupSecurityIdentifier = builder.groupSecurityIdentifier;
        this.templateArn = builder.templateArn;
    }

    public final AccessRights accessRights() {
        return this.accessRights;
    }

    public final String groupDisplayName() {
        return this.groupDisplayName;
    }

    public final String groupSecurityIdentifier() {
        return this.groupSecurityIdentifier;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessRights());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupSecurityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTemplateGroupAccessControlEntryRequest)) {
            return false;
        }
        UpdateTemplateGroupAccessControlEntryRequest other = (UpdateTemplateGroupAccessControlEntryRequest)((Object)obj);
        return Objects.equals(this.accessRights(), other.accessRights()) && Objects.equals(this.groupDisplayName(), other.groupDisplayName()) && Objects.equals(this.groupSecurityIdentifier(), other.groupSecurityIdentifier()) && Objects.equals(this.templateArn(), other.templateArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTemplateGroupAccessControlEntryRequest").add("AccessRights", (Object)this.accessRights()).add("GroupDisplayName", (Object)this.groupDisplayName()).add("GroupSecurityIdentifier", (Object)this.groupSecurityIdentifier()).add("TemplateArn", (Object)this.templateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessRights": {
                return Optional.ofNullable(clazz.cast(this.accessRights()));
            }
            case "GroupDisplayName": {
                return Optional.ofNullable(clazz.cast(this.groupDisplayName()));
            }
            case "GroupSecurityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.groupSecurityIdentifier()));
            }
            case "TemplateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTemplateGroupAccessControlEntryRequest, T> g) {
        return obj -> g.apply((UpdateTemplateGroupAccessControlEntryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcaConnectorAdRequest.BuilderImpl
    implements Builder {
        private AccessRights accessRights;
        private String groupDisplayName;
        private String groupSecurityIdentifier;
        private String templateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTemplateGroupAccessControlEntryRequest model) {
            super(model);
            this.accessRights(model.accessRights);
            this.groupDisplayName(model.groupDisplayName);
            this.groupSecurityIdentifier(model.groupSecurityIdentifier);
            this.templateArn(model.templateArn);
        }

        public final AccessRights.Builder getAccessRights() {
            return this.accessRights != null ? this.accessRights.toBuilder() : null;
        }

        public final void setAccessRights(AccessRights.BuilderImpl accessRights) {
            this.accessRights = accessRights != null ? accessRights.build() : null;
        }

        @Override
        public final Builder accessRights(AccessRights accessRights) {
            this.accessRights = accessRights;
            return this;
        }

        public final String getGroupDisplayName() {
            return this.groupDisplayName;
        }

        public final void setGroupDisplayName(String groupDisplayName) {
            this.groupDisplayName = groupDisplayName;
        }

        @Override
        public final Builder groupDisplayName(String groupDisplayName) {
            this.groupDisplayName = groupDisplayName;
            return this;
        }

        public final String getGroupSecurityIdentifier() {
            return this.groupSecurityIdentifier;
        }

        public final void setGroupSecurityIdentifier(String groupSecurityIdentifier) {
            this.groupSecurityIdentifier = groupSecurityIdentifier;
        }

        @Override
        public final Builder groupSecurityIdentifier(String groupSecurityIdentifier) {
            this.groupSecurityIdentifier = groupSecurityIdentifier;
            return this;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTemplateGroupAccessControlEntryRequest build() {
            return new UpdateTemplateGroupAccessControlEntryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PcaConnectorAdRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTemplateGroupAccessControlEntryRequest> {
        public Builder accessRights(AccessRights var1);

        default public Builder accessRights(Consumer<AccessRights.Builder> accessRights) {
            return this.accessRights((AccessRights)((AccessRights.Builder)AccessRights.builder().applyMutation(accessRights)).build());
        }

        public Builder groupDisplayName(String var1);

        public Builder groupSecurityIdentifier(String var1);

        public Builder templateArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

