/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranslatePinDataRequest extends PaymentCryptographyDataRequest implements
        ToCopyableBuilder<TranslatePinDataRequest.Builder, TranslatePinDataRequest> {
    private static final SdkField<String> INCOMING_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IncomingKeyIdentifier").getter(getter(TranslatePinDataRequest::incomingKeyIdentifier))
            .setter(setter(Builder::incomingKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncomingKeyIdentifier").build())
            .build();

    private static final SdkField<String> OUTGOING_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutgoingKeyIdentifier").getter(getter(TranslatePinDataRequest::outgoingKeyIdentifier))
            .setter(setter(Builder::outgoingKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutgoingKeyIdentifier").build())
            .build();

    private static final SdkField<TranslationIsoFormats> INCOMING_TRANSLATION_ATTRIBUTES_FIELD = SdkField
            .<TranslationIsoFormats> builder(MarshallingType.SDK_POJO)
            .memberName("IncomingTranslationAttributes")
            .getter(getter(TranslatePinDataRequest::incomingTranslationAttributes))
            .setter(setter(Builder::incomingTranslationAttributes))
            .constructor(TranslationIsoFormats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncomingTranslationAttributes")
                    .build()).build();

    private static final SdkField<TranslationIsoFormats> OUTGOING_TRANSLATION_ATTRIBUTES_FIELD = SdkField
            .<TranslationIsoFormats> builder(MarshallingType.SDK_POJO)
            .memberName("OutgoingTranslationAttributes")
            .getter(getter(TranslatePinDataRequest::outgoingTranslationAttributes))
            .setter(setter(Builder::outgoingTranslationAttributes))
            .constructor(TranslationIsoFormats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutgoingTranslationAttributes")
                    .build()).build();

    private static final SdkField<String> ENCRYPTED_PIN_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptedPinBlock").getter(getter(TranslatePinDataRequest::encryptedPinBlock))
            .setter(setter(Builder::encryptedPinBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedPinBlock").build()).build();

    private static final SdkField<DukptDerivationAttributes> INCOMING_DUKPT_ATTRIBUTES_FIELD = SdkField
            .<DukptDerivationAttributes> builder(MarshallingType.SDK_POJO).memberName("IncomingDukptAttributes")
            .getter(getter(TranslatePinDataRequest::incomingDukptAttributes)).setter(setter(Builder::incomingDukptAttributes))
            .constructor(DukptDerivationAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncomingDukptAttributes").build())
            .build();

    private static final SdkField<DukptDerivationAttributes> OUTGOING_DUKPT_ATTRIBUTES_FIELD = SdkField
            .<DukptDerivationAttributes> builder(MarshallingType.SDK_POJO).memberName("OutgoingDukptAttributes")
            .getter(getter(TranslatePinDataRequest::outgoingDukptAttributes)).setter(setter(Builder::outgoingDukptAttributes))
            .constructor(DukptDerivationAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutgoingDukptAttributes").build())
            .build();

    private static final SdkField<WrappedKey> INCOMING_WRAPPED_KEY_FIELD = SdkField
            .<WrappedKey> builder(MarshallingType.SDK_POJO).memberName("IncomingWrappedKey")
            .getter(getter(TranslatePinDataRequest::incomingWrappedKey)).setter(setter(Builder::incomingWrappedKey))
            .constructor(WrappedKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncomingWrappedKey").build())
            .build();

    private static final SdkField<WrappedKey> OUTGOING_WRAPPED_KEY_FIELD = SdkField
            .<WrappedKey> builder(MarshallingType.SDK_POJO).memberName("OutgoingWrappedKey")
            .getter(getter(TranslatePinDataRequest::outgoingWrappedKey)).setter(setter(Builder::outgoingWrappedKey))
            .constructor(WrappedKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutgoingWrappedKey").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCOMING_KEY_IDENTIFIER_FIELD,
            OUTGOING_KEY_IDENTIFIER_FIELD, INCOMING_TRANSLATION_ATTRIBUTES_FIELD, OUTGOING_TRANSLATION_ATTRIBUTES_FIELD,
            ENCRYPTED_PIN_BLOCK_FIELD, INCOMING_DUKPT_ATTRIBUTES_FIELD, OUTGOING_DUKPT_ATTRIBUTES_FIELD,
            INCOMING_WRAPPED_KEY_FIELD, OUTGOING_WRAPPED_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String incomingKeyIdentifier;

    private final String outgoingKeyIdentifier;

    private final TranslationIsoFormats incomingTranslationAttributes;

    private final TranslationIsoFormats outgoingTranslationAttributes;

    private final String encryptedPinBlock;

    private final DukptDerivationAttributes incomingDukptAttributes;

    private final DukptDerivationAttributes outgoingDukptAttributes;

    private final WrappedKey incomingWrappedKey;

    private final WrappedKey outgoingWrappedKey;

    private TranslatePinDataRequest(BuilderImpl builder) {
        super(builder);
        this.incomingKeyIdentifier = builder.incomingKeyIdentifier;
        this.outgoingKeyIdentifier = builder.outgoingKeyIdentifier;
        this.incomingTranslationAttributes = builder.incomingTranslationAttributes;
        this.outgoingTranslationAttributes = builder.outgoingTranslationAttributes;
        this.encryptedPinBlock = builder.encryptedPinBlock;
        this.incomingDukptAttributes = builder.incomingDukptAttributes;
        this.outgoingDukptAttributes = builder.outgoingDukptAttributes;
        this.incomingWrappedKey = builder.incomingWrappedKey;
        this.outgoingWrappedKey = builder.outgoingWrappedKey;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the encryption key under which incoming PIN block data is encrypted. This key type can
     * be PEK or BDK.
     * </p>
     * <p>
     * For dynamic keys, it is the <code>keyARN</code> of KEK of the TR-31 wrapped PEK. For ECDH, it is the
     * <code>keyARN</code> of the asymmetric ECC key.
     * </p>
     * 
     * @return The <code>keyARN</code> of the encryption key under which incoming PIN block data is encrypted. This key
     *         type can be PEK or BDK.</p>
     *         <p>
     *         For dynamic keys, it is the <code>keyARN</code> of KEK of the TR-31 wrapped PEK. For ECDH, it is the
     *         <code>keyARN</code> of the asymmetric ECC key.
     */
    public final String incomingKeyIdentifier() {
        return incomingKeyIdentifier;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the encryption key for encrypting outgoing PIN block data. This key type can be PEK or
     * BDK.
     * </p>
     * <p>
     * For ECDH, it is the <code>keyARN</code> of the asymmetric ECC key.
     * </p>
     * 
     * @return The <code>keyARN</code> of the encryption key for encrypting outgoing PIN block data. This key type can
     *         be PEK or BDK.</p>
     *         <p>
     *         For ECDH, it is the <code>keyARN</code> of the asymmetric ECC key.
     */
    public final String outgoingKeyIdentifier() {
        return outgoingKeyIdentifier;
    }

    /**
     * <p>
     * The format of the incoming PIN block data for translation within Amazon Web Services Payment Cryptography.
     * </p>
     * 
     * @return The format of the incoming PIN block data for translation within Amazon Web Services Payment
     *         Cryptography.
     */
    public final TranslationIsoFormats incomingTranslationAttributes() {
        return incomingTranslationAttributes;
    }

    /**
     * <p>
     * The format of the outgoing PIN block data after translation by Amazon Web Services Payment Cryptography.
     * </p>
     * 
     * @return The format of the outgoing PIN block data after translation by Amazon Web Services Payment Cryptography.
     */
    public final TranslationIsoFormats outgoingTranslationAttributes() {
        return outgoingTranslationAttributes;
    }

    /**
     * <p>
     * The encrypted PIN block data that Amazon Web Services Payment Cryptography translates.
     * </p>
     * 
     * @return The encrypted PIN block data that Amazon Web Services Payment Cryptography translates.
     */
    public final String encryptedPinBlock() {
        return encryptedPinBlock;
    }

    /**
     * <p>
     * The attributes and values to use for incoming DUKPT encryption key for PIN block translation.
     * </p>
     * 
     * @return The attributes and values to use for incoming DUKPT encryption key for PIN block translation.
     */
    public final DukptDerivationAttributes incomingDukptAttributes() {
        return incomingDukptAttributes;
    }

    /**
     * <p>
     * The attributes and values to use for outgoing DUKPT encryption key after PIN block translation.
     * </p>
     * 
     * @return The attributes and values to use for outgoing DUKPT encryption key after PIN block translation.
     */
    public final DukptDerivationAttributes outgoingDukptAttributes() {
        return outgoingDukptAttributes;
    }

    /**
     * <p>
     * The WrappedKeyBlock containing the encryption key under which incoming PIN block data is encrypted.
     * </p>
     * 
     * @return The WrappedKeyBlock containing the encryption key under which incoming PIN block data is encrypted.
     */
    public final WrappedKey incomingWrappedKey() {
        return incomingWrappedKey;
    }

    /**
     * <p>
     * The WrappedKeyBlock containing the encryption key for encrypting outgoing PIN block data.
     * </p>
     * 
     * @return The WrappedKeyBlock containing the encryption key for encrypting outgoing PIN block data.
     */
    public final WrappedKey outgoingWrappedKey() {
        return outgoingWrappedKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(incomingKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(outgoingKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(incomingTranslationAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(outgoingTranslationAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(encryptedPinBlock());
        hashCode = 31 * hashCode + Objects.hashCode(incomingDukptAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(outgoingDukptAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(incomingWrappedKey());
        hashCode = 31 * hashCode + Objects.hashCode(outgoingWrappedKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslatePinDataRequest)) {
            return false;
        }
        TranslatePinDataRequest other = (TranslatePinDataRequest) obj;
        return Objects.equals(incomingKeyIdentifier(), other.incomingKeyIdentifier())
                && Objects.equals(outgoingKeyIdentifier(), other.outgoingKeyIdentifier())
                && Objects.equals(incomingTranslationAttributes(), other.incomingTranslationAttributes())
                && Objects.equals(outgoingTranslationAttributes(), other.outgoingTranslationAttributes())
                && Objects.equals(encryptedPinBlock(), other.encryptedPinBlock())
                && Objects.equals(incomingDukptAttributes(), other.incomingDukptAttributes())
                && Objects.equals(outgoingDukptAttributes(), other.outgoingDukptAttributes())
                && Objects.equals(incomingWrappedKey(), other.incomingWrappedKey())
                && Objects.equals(outgoingWrappedKey(), other.outgoingWrappedKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranslatePinDataRequest").add("IncomingKeyIdentifier", incomingKeyIdentifier())
                .add("OutgoingKeyIdentifier", outgoingKeyIdentifier())
                .add("IncomingTranslationAttributes", incomingTranslationAttributes())
                .add("OutgoingTranslationAttributes", outgoingTranslationAttributes())
                .add("EncryptedPinBlock", encryptedPinBlock() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IncomingDukptAttributes", incomingDukptAttributes())
                .add("OutgoingDukptAttributes", outgoingDukptAttributes()).add("IncomingWrappedKey", incomingWrappedKey())
                .add("OutgoingWrappedKey", outgoingWrappedKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IncomingKeyIdentifier":
            return Optional.ofNullable(clazz.cast(incomingKeyIdentifier()));
        case "OutgoingKeyIdentifier":
            return Optional.ofNullable(clazz.cast(outgoingKeyIdentifier()));
        case "IncomingTranslationAttributes":
            return Optional.ofNullable(clazz.cast(incomingTranslationAttributes()));
        case "OutgoingTranslationAttributes":
            return Optional.ofNullable(clazz.cast(outgoingTranslationAttributes()));
        case "EncryptedPinBlock":
            return Optional.ofNullable(clazz.cast(encryptedPinBlock()));
        case "IncomingDukptAttributes":
            return Optional.ofNullable(clazz.cast(incomingDukptAttributes()));
        case "OutgoingDukptAttributes":
            return Optional.ofNullable(clazz.cast(outgoingDukptAttributes()));
        case "IncomingWrappedKey":
            return Optional.ofNullable(clazz.cast(incomingWrappedKey()));
        case "OutgoingWrappedKey":
            return Optional.ofNullable(clazz.cast(outgoingWrappedKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IncomingKeyIdentifier", INCOMING_KEY_IDENTIFIER_FIELD);
        map.put("OutgoingKeyIdentifier", OUTGOING_KEY_IDENTIFIER_FIELD);
        map.put("IncomingTranslationAttributes", INCOMING_TRANSLATION_ATTRIBUTES_FIELD);
        map.put("OutgoingTranslationAttributes", OUTGOING_TRANSLATION_ATTRIBUTES_FIELD);
        map.put("EncryptedPinBlock", ENCRYPTED_PIN_BLOCK_FIELD);
        map.put("IncomingDukptAttributes", INCOMING_DUKPT_ATTRIBUTES_FIELD);
        map.put("OutgoingDukptAttributes", OUTGOING_DUKPT_ATTRIBUTES_FIELD);
        map.put("IncomingWrappedKey", INCOMING_WRAPPED_KEY_FIELD);
        map.put("OutgoingWrappedKey", OUTGOING_WRAPPED_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TranslatePinDataRequest, T> g) {
        return obj -> g.apply((TranslatePinDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PaymentCryptographyDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, TranslatePinDataRequest> {
        /**
         * <p>
         * The <code>keyARN</code> of the encryption key under which incoming PIN block data is encrypted. This key type
         * can be PEK or BDK.
         * </p>
         * <p>
         * For dynamic keys, it is the <code>keyARN</code> of KEK of the TR-31 wrapped PEK. For ECDH, it is the
         * <code>keyARN</code> of the asymmetric ECC key.
         * </p>
         * 
         * @param incomingKeyIdentifier
         *        The <code>keyARN</code> of the encryption key under which incoming PIN block data is encrypted. This
         *        key type can be PEK or BDK.</p>
         *        <p>
         *        For dynamic keys, it is the <code>keyARN</code> of KEK of the TR-31 wrapped PEK. For ECDH, it is the
         *        <code>keyARN</code> of the asymmetric ECC key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incomingKeyIdentifier(String incomingKeyIdentifier);

        /**
         * <p>
         * The <code>keyARN</code> of the encryption key for encrypting outgoing PIN block data. This key type can be
         * PEK or BDK.
         * </p>
         * <p>
         * For ECDH, it is the <code>keyARN</code> of the asymmetric ECC key.
         * </p>
         * 
         * @param outgoingKeyIdentifier
         *        The <code>keyARN</code> of the encryption key for encrypting outgoing PIN block data. This key type
         *        can be PEK or BDK.</p>
         *        <p>
         *        For ECDH, it is the <code>keyARN</code> of the asymmetric ECC key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outgoingKeyIdentifier(String outgoingKeyIdentifier);

        /**
         * <p>
         * The format of the incoming PIN block data for translation within Amazon Web Services Payment Cryptography.
         * </p>
         * 
         * @param incomingTranslationAttributes
         *        The format of the incoming PIN block data for translation within Amazon Web Services Payment
         *        Cryptography.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incomingTranslationAttributes(TranslationIsoFormats incomingTranslationAttributes);

        /**
         * <p>
         * The format of the incoming PIN block data for translation within Amazon Web Services Payment Cryptography.
         * </p>
         * This is a convenience method that creates an instance of the {@link TranslationIsoFormats.Builder} avoiding
         * the need to create one manually via {@link TranslationIsoFormats#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TranslationIsoFormats.Builder#build()} is called immediately and
         * its result is passed to {@link #incomingTranslationAttributes(TranslationIsoFormats)}.
         * 
         * @param incomingTranslationAttributes
         *        a consumer that will call methods on {@link TranslationIsoFormats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incomingTranslationAttributes(TranslationIsoFormats)
         */
        default Builder incomingTranslationAttributes(Consumer<TranslationIsoFormats.Builder> incomingTranslationAttributes) {
            return incomingTranslationAttributes(TranslationIsoFormats.builder().applyMutation(incomingTranslationAttributes)
                    .build());
        }

        /**
         * <p>
         * The format of the outgoing PIN block data after translation by Amazon Web Services Payment Cryptography.
         * </p>
         * 
         * @param outgoingTranslationAttributes
         *        The format of the outgoing PIN block data after translation by Amazon Web Services Payment
         *        Cryptography.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outgoingTranslationAttributes(TranslationIsoFormats outgoingTranslationAttributes);

        /**
         * <p>
         * The format of the outgoing PIN block data after translation by Amazon Web Services Payment Cryptography.
         * </p>
         * This is a convenience method that creates an instance of the {@link TranslationIsoFormats.Builder} avoiding
         * the need to create one manually via {@link TranslationIsoFormats#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TranslationIsoFormats.Builder#build()} is called immediately and
         * its result is passed to {@link #outgoingTranslationAttributes(TranslationIsoFormats)}.
         * 
         * @param outgoingTranslationAttributes
         *        a consumer that will call methods on {@link TranslationIsoFormats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outgoingTranslationAttributes(TranslationIsoFormats)
         */
        default Builder outgoingTranslationAttributes(Consumer<TranslationIsoFormats.Builder> outgoingTranslationAttributes) {
            return outgoingTranslationAttributes(TranslationIsoFormats.builder().applyMutation(outgoingTranslationAttributes)
                    .build());
        }

        /**
         * <p>
         * The encrypted PIN block data that Amazon Web Services Payment Cryptography translates.
         * </p>
         * 
         * @param encryptedPinBlock
         *        The encrypted PIN block data that Amazon Web Services Payment Cryptography translates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptedPinBlock(String encryptedPinBlock);

        /**
         * <p>
         * The attributes and values to use for incoming DUKPT encryption key for PIN block translation.
         * </p>
         * 
         * @param incomingDukptAttributes
         *        The attributes and values to use for incoming DUKPT encryption key for PIN block translation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incomingDukptAttributes(DukptDerivationAttributes incomingDukptAttributes);

        /**
         * <p>
         * The attributes and values to use for incoming DUKPT encryption key for PIN block translation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DukptDerivationAttributes.Builder}
         * avoiding the need to create one manually via {@link DukptDerivationAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DukptDerivationAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #incomingDukptAttributes(DukptDerivationAttributes)}.
         * 
         * @param incomingDukptAttributes
         *        a consumer that will call methods on {@link DukptDerivationAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incomingDukptAttributes(DukptDerivationAttributes)
         */
        default Builder incomingDukptAttributes(Consumer<DukptDerivationAttributes.Builder> incomingDukptAttributes) {
            return incomingDukptAttributes(DukptDerivationAttributes.builder().applyMutation(incomingDukptAttributes).build());
        }

        /**
         * <p>
         * The attributes and values to use for outgoing DUKPT encryption key after PIN block translation.
         * </p>
         * 
         * @param outgoingDukptAttributes
         *        The attributes and values to use for outgoing DUKPT encryption key after PIN block translation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outgoingDukptAttributes(DukptDerivationAttributes outgoingDukptAttributes);

        /**
         * <p>
         * The attributes and values to use for outgoing DUKPT encryption key after PIN block translation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DukptDerivationAttributes.Builder}
         * avoiding the need to create one manually via {@link DukptDerivationAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DukptDerivationAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #outgoingDukptAttributes(DukptDerivationAttributes)}.
         * 
         * @param outgoingDukptAttributes
         *        a consumer that will call methods on {@link DukptDerivationAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outgoingDukptAttributes(DukptDerivationAttributes)
         */
        default Builder outgoingDukptAttributes(Consumer<DukptDerivationAttributes.Builder> outgoingDukptAttributes) {
            return outgoingDukptAttributes(DukptDerivationAttributes.builder().applyMutation(outgoingDukptAttributes).build());
        }

        /**
         * <p>
         * The WrappedKeyBlock containing the encryption key under which incoming PIN block data is encrypted.
         * </p>
         * 
         * @param incomingWrappedKey
         *        The WrappedKeyBlock containing the encryption key under which incoming PIN block data is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incomingWrappedKey(WrappedKey incomingWrappedKey);

        /**
         * <p>
         * The WrappedKeyBlock containing the encryption key under which incoming PIN block data is encrypted.
         * </p>
         * This is a convenience method that creates an instance of the {@link WrappedKey.Builder} avoiding the need to
         * create one manually via {@link WrappedKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WrappedKey.Builder#build()} is called immediately and its result
         * is passed to {@link #incomingWrappedKey(WrappedKey)}.
         * 
         * @param incomingWrappedKey
         *        a consumer that will call methods on {@link WrappedKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incomingWrappedKey(WrappedKey)
         */
        default Builder incomingWrappedKey(Consumer<WrappedKey.Builder> incomingWrappedKey) {
            return incomingWrappedKey(WrappedKey.builder().applyMutation(incomingWrappedKey).build());
        }

        /**
         * <p>
         * The WrappedKeyBlock containing the encryption key for encrypting outgoing PIN block data.
         * </p>
         * 
         * @param outgoingWrappedKey
         *        The WrappedKeyBlock containing the encryption key for encrypting outgoing PIN block data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outgoingWrappedKey(WrappedKey outgoingWrappedKey);

        /**
         * <p>
         * The WrappedKeyBlock containing the encryption key for encrypting outgoing PIN block data.
         * </p>
         * This is a convenience method that creates an instance of the {@link WrappedKey.Builder} avoiding the need to
         * create one manually via {@link WrappedKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WrappedKey.Builder#build()} is called immediately and its result
         * is passed to {@link #outgoingWrappedKey(WrappedKey)}.
         * 
         * @param outgoingWrappedKey
         *        a consumer that will call methods on {@link WrappedKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outgoingWrappedKey(WrappedKey)
         */
        default Builder outgoingWrappedKey(Consumer<WrappedKey.Builder> outgoingWrappedKey) {
            return outgoingWrappedKey(WrappedKey.builder().applyMutation(outgoingWrappedKey).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyDataRequest.BuilderImpl implements Builder {
        private String incomingKeyIdentifier;

        private String outgoingKeyIdentifier;

        private TranslationIsoFormats incomingTranslationAttributes;

        private TranslationIsoFormats outgoingTranslationAttributes;

        private String encryptedPinBlock;

        private DukptDerivationAttributes incomingDukptAttributes;

        private DukptDerivationAttributes outgoingDukptAttributes;

        private WrappedKey incomingWrappedKey;

        private WrappedKey outgoingWrappedKey;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslatePinDataRequest model) {
            super(model);
            incomingKeyIdentifier(model.incomingKeyIdentifier);
            outgoingKeyIdentifier(model.outgoingKeyIdentifier);
            incomingTranslationAttributes(model.incomingTranslationAttributes);
            outgoingTranslationAttributes(model.outgoingTranslationAttributes);
            encryptedPinBlock(model.encryptedPinBlock);
            incomingDukptAttributes(model.incomingDukptAttributes);
            outgoingDukptAttributes(model.outgoingDukptAttributes);
            incomingWrappedKey(model.incomingWrappedKey);
            outgoingWrappedKey(model.outgoingWrappedKey);
        }

        public final String getIncomingKeyIdentifier() {
            return incomingKeyIdentifier;
        }

        public final void setIncomingKeyIdentifier(String incomingKeyIdentifier) {
            this.incomingKeyIdentifier = incomingKeyIdentifier;
        }

        @Override
        public final Builder incomingKeyIdentifier(String incomingKeyIdentifier) {
            this.incomingKeyIdentifier = incomingKeyIdentifier;
            return this;
        }

        public final String getOutgoingKeyIdentifier() {
            return outgoingKeyIdentifier;
        }

        public final void setOutgoingKeyIdentifier(String outgoingKeyIdentifier) {
            this.outgoingKeyIdentifier = outgoingKeyIdentifier;
        }

        @Override
        public final Builder outgoingKeyIdentifier(String outgoingKeyIdentifier) {
            this.outgoingKeyIdentifier = outgoingKeyIdentifier;
            return this;
        }

        public final TranslationIsoFormats.Builder getIncomingTranslationAttributes() {
            return incomingTranslationAttributes != null ? incomingTranslationAttributes.toBuilder() : null;
        }

        public final void setIncomingTranslationAttributes(TranslationIsoFormats.BuilderImpl incomingTranslationAttributes) {
            this.incomingTranslationAttributes = incomingTranslationAttributes != null ? incomingTranslationAttributes.build()
                    : null;
        }

        @Override
        public final Builder incomingTranslationAttributes(TranslationIsoFormats incomingTranslationAttributes) {
            this.incomingTranslationAttributes = incomingTranslationAttributes;
            return this;
        }

        public final TranslationIsoFormats.Builder getOutgoingTranslationAttributes() {
            return outgoingTranslationAttributes != null ? outgoingTranslationAttributes.toBuilder() : null;
        }

        public final void setOutgoingTranslationAttributes(TranslationIsoFormats.BuilderImpl outgoingTranslationAttributes) {
            this.outgoingTranslationAttributes = outgoingTranslationAttributes != null ? outgoingTranslationAttributes.build()
                    : null;
        }

        @Override
        public final Builder outgoingTranslationAttributes(TranslationIsoFormats outgoingTranslationAttributes) {
            this.outgoingTranslationAttributes = outgoingTranslationAttributes;
            return this;
        }

        public final String getEncryptedPinBlock() {
            return encryptedPinBlock;
        }

        public final void setEncryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
        }

        @Override
        public final Builder encryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
            return this;
        }

        public final DukptDerivationAttributes.Builder getIncomingDukptAttributes() {
            return incomingDukptAttributes != null ? incomingDukptAttributes.toBuilder() : null;
        }

        public final void setIncomingDukptAttributes(DukptDerivationAttributes.BuilderImpl incomingDukptAttributes) {
            this.incomingDukptAttributes = incomingDukptAttributes != null ? incomingDukptAttributes.build() : null;
        }

        @Override
        public final Builder incomingDukptAttributes(DukptDerivationAttributes incomingDukptAttributes) {
            this.incomingDukptAttributes = incomingDukptAttributes;
            return this;
        }

        public final DukptDerivationAttributes.Builder getOutgoingDukptAttributes() {
            return outgoingDukptAttributes != null ? outgoingDukptAttributes.toBuilder() : null;
        }

        public final void setOutgoingDukptAttributes(DukptDerivationAttributes.BuilderImpl outgoingDukptAttributes) {
            this.outgoingDukptAttributes = outgoingDukptAttributes != null ? outgoingDukptAttributes.build() : null;
        }

        @Override
        public final Builder outgoingDukptAttributes(DukptDerivationAttributes outgoingDukptAttributes) {
            this.outgoingDukptAttributes = outgoingDukptAttributes;
            return this;
        }

        public final WrappedKey.Builder getIncomingWrappedKey() {
            return incomingWrappedKey != null ? incomingWrappedKey.toBuilder() : null;
        }

        public final void setIncomingWrappedKey(WrappedKey.BuilderImpl incomingWrappedKey) {
            this.incomingWrappedKey = incomingWrappedKey != null ? incomingWrappedKey.build() : null;
        }

        @Override
        public final Builder incomingWrappedKey(WrappedKey incomingWrappedKey) {
            this.incomingWrappedKey = incomingWrappedKey;
            return this;
        }

        public final WrappedKey.Builder getOutgoingWrappedKey() {
            return outgoingWrappedKey != null ? outgoingWrappedKey.toBuilder() : null;
        }

        public final void setOutgoingWrappedKey(WrappedKey.BuilderImpl outgoingWrappedKey) {
            this.outgoingWrappedKey = outgoingWrappedKey != null ? outgoingWrappedKey.build() : null;
        }

        @Override
        public final Builder outgoingWrappedKey(WrappedKey outgoingWrappedKey) {
            this.outgoingWrappedKey = outgoingWrappedKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TranslatePinDataRequest build() {
            return new TranslatePinDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
