/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters to derive a session key for Authorization Response Cryptogram (ARQC) verification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionKeyDerivation implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionKeyDerivation.Builder, SessionKeyDerivation> {
    private static final SdkField<SessionKeyEmvCommon> EMV_COMMON_FIELD = SdkField
            .<SessionKeyEmvCommon> builder(MarshallingType.SDK_POJO).memberName("EmvCommon")
            .getter(getter(SessionKeyDerivation::emvCommon)).setter(setter(Builder::emvCommon))
            .constructor(SessionKeyEmvCommon::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmvCommon").build()).build();

    private static final SdkField<SessionKeyMastercard> MASTERCARD_FIELD = SdkField
            .<SessionKeyMastercard> builder(MarshallingType.SDK_POJO).memberName("Mastercard")
            .getter(getter(SessionKeyDerivation::mastercard)).setter(setter(Builder::mastercard))
            .constructor(SessionKeyMastercard::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mastercard").build()).build();

    private static final SdkField<SessionKeyEmv2000> EMV2000_FIELD = SdkField
            .<SessionKeyEmv2000> builder(MarshallingType.SDK_POJO).memberName("Emv2000")
            .getter(getter(SessionKeyDerivation::emv2000)).setter(setter(Builder::emv2000))
            .constructor(SessionKeyEmv2000::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Emv2000").build()).build();

    private static final SdkField<SessionKeyAmex> AMEX_FIELD = SdkField.<SessionKeyAmex> builder(MarshallingType.SDK_POJO)
            .memberName("Amex").getter(getter(SessionKeyDerivation::amex)).setter(setter(Builder::amex))
            .constructor(SessionKeyAmex::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amex").build()).build();

    private static final SdkField<SessionKeyVisa> VISA_FIELD = SdkField.<SessionKeyVisa> builder(MarshallingType.SDK_POJO)
            .memberName("Visa").getter(getter(SessionKeyDerivation::visa)).setter(setter(Builder::visa))
            .constructor(SessionKeyVisa::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visa").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMV_COMMON_FIELD,
            MASTERCARD_FIELD, EMV2000_FIELD, AMEX_FIELD, VISA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SessionKeyEmvCommon emvCommon;

    private final SessionKeyMastercard mastercard;

    private final SessionKeyEmv2000 emv2000;

    private final SessionKeyAmex amex;

    private final SessionKeyVisa visa;

    private final Type type;

    private SessionKeyDerivation(BuilderImpl builder) {
        this.emvCommon = builder.emvCommon;
        this.mastercard = builder.mastercard;
        this.emv2000 = builder.emv2000;
        this.amex = builder.amex;
        this.visa = builder.visa;
        this.type = builder.type;
    }

    /**
     * <p>
     * Parameters to derive session key for an Emv common payment card for ARQC verification.
     * </p>
     * 
     * @return Parameters to derive session key for an Emv common payment card for ARQC verification.
     */
    public final SessionKeyEmvCommon emvCommon() {
        return emvCommon;
    }

    /**
     * <p>
     * Parameters to derive session key for a Mastercard payment card for ARQC verification.
     * </p>
     * 
     * @return Parameters to derive session key for a Mastercard payment card for ARQC verification.
     */
    public final SessionKeyMastercard mastercard() {
        return mastercard;
    }

    /**
     * <p>
     * Parameters to derive session key for an Emv2000 payment card for ARQC verification.
     * </p>
     * 
     * @return Parameters to derive session key for an Emv2000 payment card for ARQC verification.
     */
    public final SessionKeyEmv2000 emv2000() {
        return emv2000;
    }

    /**
     * <p>
     * Parameters to derive session key for an Amex payment card for ARQC verification.
     * </p>
     * 
     * @return Parameters to derive session key for an Amex payment card for ARQC verification.
     */
    public final SessionKeyAmex amex() {
        return amex;
    }

    /**
     * <p>
     * Parameters to derive session key for a Visa payment cardfor ARQC verification.
     * </p>
     * 
     * @return Parameters to derive session key for a Visa payment cardfor ARQC verification.
     */
    public final SessionKeyVisa visa() {
        return visa;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emvCommon());
        hashCode = 31 * hashCode + Objects.hashCode(mastercard());
        hashCode = 31 * hashCode + Objects.hashCode(emv2000());
        hashCode = 31 * hashCode + Objects.hashCode(amex());
        hashCode = 31 * hashCode + Objects.hashCode(visa());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionKeyDerivation)) {
            return false;
        }
        SessionKeyDerivation other = (SessionKeyDerivation) obj;
        return Objects.equals(emvCommon(), other.emvCommon()) && Objects.equals(mastercard(), other.mastercard())
                && Objects.equals(emv2000(), other.emv2000()) && Objects.equals(amex(), other.amex())
                && Objects.equals(visa(), other.visa());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionKeyDerivation").add("EmvCommon", emvCommon()).add("Mastercard", mastercard())
                .add("Emv2000", emv2000()).add("Amex", amex()).add("Visa", visa()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmvCommon":
            return Optional.ofNullable(clazz.cast(emvCommon()));
        case "Mastercard":
            return Optional.ofNullable(clazz.cast(mastercard()));
        case "Emv2000":
            return Optional.ofNullable(clazz.cast(emv2000()));
        case "Amex":
            return Optional.ofNullable(clazz.cast(amex()));
        case "Visa":
            return Optional.ofNullable(clazz.cast(visa()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #emvCommon()} initialized to the given value.
     *
     * <p>
     * Parameters to derive session key for an Emv common payment card for ARQC verification.
     * </p>
     * 
     * @param emvCommon
     *        Parameters to derive session key for an Emv common payment card for ARQC verification.
     */
    public static SessionKeyDerivation fromEmvCommon(SessionKeyEmvCommon emvCommon) {
        return builder().emvCommon(emvCommon).build();
    }

    /**
     * Create an instance of this class with {@link #emvCommon()} initialized to the given value.
     *
     * <p>
     * Parameters to derive session key for an Emv common payment card for ARQC verification.
     * </p>
     * 
     * @param emvCommon
     *        Parameters to derive session key for an Emv common payment card for ARQC verification.
     */
    public static SessionKeyDerivation fromEmvCommon(Consumer<SessionKeyEmvCommon.Builder> emvCommon) {
        SessionKeyEmvCommon.Builder builder = SessionKeyEmvCommon.builder();
        emvCommon.accept(builder);
        return fromEmvCommon(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mastercard()} initialized to the given value.
     *
     * <p>
     * Parameters to derive session key for a Mastercard payment card for ARQC verification.
     * </p>
     * 
     * @param mastercard
     *        Parameters to derive session key for a Mastercard payment card for ARQC verification.
     */
    public static SessionKeyDerivation fromMastercard(SessionKeyMastercard mastercard) {
        return builder().mastercard(mastercard).build();
    }

    /**
     * Create an instance of this class with {@link #mastercard()} initialized to the given value.
     *
     * <p>
     * Parameters to derive session key for a Mastercard payment card for ARQC verification.
     * </p>
     * 
     * @param mastercard
     *        Parameters to derive session key for a Mastercard payment card for ARQC verification.
     */
    public static SessionKeyDerivation fromMastercard(Consumer<SessionKeyMastercard.Builder> mastercard) {
        SessionKeyMastercard.Builder builder = SessionKeyMastercard.builder();
        mastercard.accept(builder);
        return fromMastercard(builder.build());
    }

    /**
     * Create an instance of this class with {@link #emv2000()} initialized to the given value.
     *
     * <p>
     * Parameters to derive session key for an Emv2000 payment card for ARQC verification.
     * </p>
     * 
     * @param emv2000
     *        Parameters to derive session key for an Emv2000 payment card for ARQC verification.
     */
    public static SessionKeyDerivation fromEmv2000(SessionKeyEmv2000 emv2000) {
        return builder().emv2000(emv2000).build();
    }

    /**
     * Create an instance of this class with {@link #emv2000()} initialized to the given value.
     *
     * <p>
     * Parameters to derive session key for an Emv2000 payment card for ARQC verification.
     * </p>
     * 
     * @param emv2000
     *        Parameters to derive session key for an Emv2000 payment card for ARQC verification.
     */
    public static SessionKeyDerivation fromEmv2000(Consumer<SessionKeyEmv2000.Builder> emv2000) {
        SessionKeyEmv2000.Builder builder = SessionKeyEmv2000.builder();
        emv2000.accept(builder);
        return fromEmv2000(builder.build());
    }

    /**
     * Create an instance of this class with {@link #amex()} initialized to the given value.
     *
     * <p>
     * Parameters to derive session key for an Amex payment card for ARQC verification.
     * </p>
     * 
     * @param amex
     *        Parameters to derive session key for an Amex payment card for ARQC verification.
     */
    public static SessionKeyDerivation fromAmex(SessionKeyAmex amex) {
        return builder().amex(amex).build();
    }

    /**
     * Create an instance of this class with {@link #amex()} initialized to the given value.
     *
     * <p>
     * Parameters to derive session key for an Amex payment card for ARQC verification.
     * </p>
     * 
     * @param amex
     *        Parameters to derive session key for an Amex payment card for ARQC verification.
     */
    public static SessionKeyDerivation fromAmex(Consumer<SessionKeyAmex.Builder> amex) {
        SessionKeyAmex.Builder builder = SessionKeyAmex.builder();
        amex.accept(builder);
        return fromAmex(builder.build());
    }

    /**
     * Create an instance of this class with {@link #visa()} initialized to the given value.
     *
     * <p>
     * Parameters to derive session key for a Visa payment cardfor ARQC verification.
     * </p>
     * 
     * @param visa
     *        Parameters to derive session key for a Visa payment cardfor ARQC verification.
     */
    public static SessionKeyDerivation fromVisa(SessionKeyVisa visa) {
        return builder().visa(visa).build();
    }

    /**
     * Create an instance of this class with {@link #visa()} initialized to the given value.
     *
     * <p>
     * Parameters to derive session key for a Visa payment cardfor ARQC verification.
     * </p>
     * 
     * @param visa
     *        Parameters to derive session key for a Visa payment cardfor ARQC verification.
     */
    public static SessionKeyDerivation fromVisa(Consumer<SessionKeyVisa.Builder> visa) {
        SessionKeyVisa.Builder builder = SessionKeyVisa.builder();
        visa.accept(builder);
        return fromVisa(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EmvCommon", EMV_COMMON_FIELD);
        map.put("Mastercard", MASTERCARD_FIELD);
        map.put("Emv2000", EMV2000_FIELD);
        map.put("Amex", AMEX_FIELD);
        map.put("Visa", VISA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionKeyDerivation, T> g) {
        return obj -> g.apply((SessionKeyDerivation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionKeyDerivation> {
        /**
         * <p>
         * Parameters to derive session key for an Emv common payment card for ARQC verification.
         * </p>
         * 
         * @param emvCommon
         *        Parameters to derive session key for an Emv common payment card for ARQC verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emvCommon(SessionKeyEmvCommon emvCommon);

        /**
         * <p>
         * Parameters to derive session key for an Emv common payment card for ARQC verification.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionKeyEmvCommon.Builder} avoiding the
         * need to create one manually via {@link SessionKeyEmvCommon#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionKeyEmvCommon.Builder#build()} is called immediately and
         * its result is passed to {@link #emvCommon(SessionKeyEmvCommon)}.
         * 
         * @param emvCommon
         *        a consumer that will call methods on {@link SessionKeyEmvCommon.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emvCommon(SessionKeyEmvCommon)
         */
        default Builder emvCommon(Consumer<SessionKeyEmvCommon.Builder> emvCommon) {
            return emvCommon(SessionKeyEmvCommon.builder().applyMutation(emvCommon).build());
        }

        /**
         * <p>
         * Parameters to derive session key for a Mastercard payment card for ARQC verification.
         * </p>
         * 
         * @param mastercard
         *        Parameters to derive session key for a Mastercard payment card for ARQC verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mastercard(SessionKeyMastercard mastercard);

        /**
         * <p>
         * Parameters to derive session key for a Mastercard payment card for ARQC verification.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionKeyMastercard.Builder} avoiding
         * the need to create one manually via {@link SessionKeyMastercard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionKeyMastercard.Builder#build()} is called immediately and
         * its result is passed to {@link #mastercard(SessionKeyMastercard)}.
         * 
         * @param mastercard
         *        a consumer that will call methods on {@link SessionKeyMastercard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mastercard(SessionKeyMastercard)
         */
        default Builder mastercard(Consumer<SessionKeyMastercard.Builder> mastercard) {
            return mastercard(SessionKeyMastercard.builder().applyMutation(mastercard).build());
        }

        /**
         * <p>
         * Parameters to derive session key for an Emv2000 payment card for ARQC verification.
         * </p>
         * 
         * @param emv2000
         *        Parameters to derive session key for an Emv2000 payment card for ARQC verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emv2000(SessionKeyEmv2000 emv2000);

        /**
         * <p>
         * Parameters to derive session key for an Emv2000 payment card for ARQC verification.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionKeyEmv2000.Builder} avoiding the
         * need to create one manually via {@link SessionKeyEmv2000#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionKeyEmv2000.Builder#build()} is called immediately and its
         * result is passed to {@link #emv2000(SessionKeyEmv2000)}.
         * 
         * @param emv2000
         *        a consumer that will call methods on {@link SessionKeyEmv2000.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emv2000(SessionKeyEmv2000)
         */
        default Builder emv2000(Consumer<SessionKeyEmv2000.Builder> emv2000) {
            return emv2000(SessionKeyEmv2000.builder().applyMutation(emv2000).build());
        }

        /**
         * <p>
         * Parameters to derive session key for an Amex payment card for ARQC verification.
         * </p>
         * 
         * @param amex
         *        Parameters to derive session key for an Amex payment card for ARQC verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amex(SessionKeyAmex amex);

        /**
         * <p>
         * Parameters to derive session key for an Amex payment card for ARQC verification.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionKeyAmex.Builder} avoiding the need
         * to create one manually via {@link SessionKeyAmex#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionKeyAmex.Builder#build()} is called immediately and its
         * result is passed to {@link #amex(SessionKeyAmex)}.
         * 
         * @param amex
         *        a consumer that will call methods on {@link SessionKeyAmex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amex(SessionKeyAmex)
         */
        default Builder amex(Consumer<SessionKeyAmex.Builder> amex) {
            return amex(SessionKeyAmex.builder().applyMutation(amex).build());
        }

        /**
         * <p>
         * Parameters to derive session key for a Visa payment cardfor ARQC verification.
         * </p>
         * 
         * @param visa
         *        Parameters to derive session key for a Visa payment cardfor ARQC verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visa(SessionKeyVisa visa);

        /**
         * <p>
         * Parameters to derive session key for a Visa payment cardfor ARQC verification.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionKeyVisa.Builder} avoiding the need
         * to create one manually via {@link SessionKeyVisa#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionKeyVisa.Builder#build()} is called immediately and its
         * result is passed to {@link #visa(SessionKeyVisa)}.
         * 
         * @param visa
         *        a consumer that will call methods on {@link SessionKeyVisa.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visa(SessionKeyVisa)
         */
        default Builder visa(Consumer<SessionKeyVisa.Builder> visa) {
            return visa(SessionKeyVisa.builder().applyMutation(visa).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SessionKeyEmvCommon emvCommon;

        private SessionKeyMastercard mastercard;

        private SessionKeyEmv2000 emv2000;

        private SessionKeyAmex amex;

        private SessionKeyVisa visa;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SessionKeyDerivation model) {
            emvCommon(model.emvCommon);
            mastercard(model.mastercard);
            emv2000(model.emv2000);
            amex(model.amex);
            visa(model.visa);
        }

        public final SessionKeyEmvCommon.Builder getEmvCommon() {
            return emvCommon != null ? emvCommon.toBuilder() : null;
        }

        public final void setEmvCommon(SessionKeyEmvCommon.BuilderImpl emvCommon) {
            Object oldValue = this.emvCommon;
            this.emvCommon = emvCommon != null ? emvCommon.build() : null;
            handleUnionValueChange(Type.EMV_COMMON, oldValue, this.emvCommon);
        }

        @Override
        public final Builder emvCommon(SessionKeyEmvCommon emvCommon) {
            Object oldValue = this.emvCommon;
            this.emvCommon = emvCommon;
            handleUnionValueChange(Type.EMV_COMMON, oldValue, this.emvCommon);
            return this;
        }

        public final SessionKeyMastercard.Builder getMastercard() {
            return mastercard != null ? mastercard.toBuilder() : null;
        }

        public final void setMastercard(SessionKeyMastercard.BuilderImpl mastercard) {
            Object oldValue = this.mastercard;
            this.mastercard = mastercard != null ? mastercard.build() : null;
            handleUnionValueChange(Type.MASTERCARD, oldValue, this.mastercard);
        }

        @Override
        public final Builder mastercard(SessionKeyMastercard mastercard) {
            Object oldValue = this.mastercard;
            this.mastercard = mastercard;
            handleUnionValueChange(Type.MASTERCARD, oldValue, this.mastercard);
            return this;
        }

        public final SessionKeyEmv2000.Builder getEmv2000() {
            return emv2000 != null ? emv2000.toBuilder() : null;
        }

        public final void setEmv2000(SessionKeyEmv2000.BuilderImpl emv2000) {
            Object oldValue = this.emv2000;
            this.emv2000 = emv2000 != null ? emv2000.build() : null;
            handleUnionValueChange(Type.EMV2000, oldValue, this.emv2000);
        }

        @Override
        public final Builder emv2000(SessionKeyEmv2000 emv2000) {
            Object oldValue = this.emv2000;
            this.emv2000 = emv2000;
            handleUnionValueChange(Type.EMV2000, oldValue, this.emv2000);
            return this;
        }

        public final SessionKeyAmex.Builder getAmex() {
            return amex != null ? amex.toBuilder() : null;
        }

        public final void setAmex(SessionKeyAmex.BuilderImpl amex) {
            Object oldValue = this.amex;
            this.amex = amex != null ? amex.build() : null;
            handleUnionValueChange(Type.AMEX, oldValue, this.amex);
        }

        @Override
        public final Builder amex(SessionKeyAmex amex) {
            Object oldValue = this.amex;
            this.amex = amex;
            handleUnionValueChange(Type.AMEX, oldValue, this.amex);
            return this;
        }

        public final SessionKeyVisa.Builder getVisa() {
            return visa != null ? visa.toBuilder() : null;
        }

        public final void setVisa(SessionKeyVisa.BuilderImpl visa) {
            Object oldValue = this.visa;
            this.visa = visa != null ? visa.build() : null;
            handleUnionValueChange(Type.VISA, oldValue, this.visa);
        }

        @Override
        public final Builder visa(SessionKeyVisa visa) {
            Object oldValue = this.visa;
            this.visa = visa;
            handleUnionValueChange(Type.VISA, oldValue, this.visa);
            return this;
        }

        @Override
        public SessionKeyDerivation build() {
            return new SessionKeyDerivation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SessionKeyDerivation#type()
     */
    public enum Type {
        EMV_COMMON,

        MASTERCARD,

        EMV2000,

        AMEX,

        VISA,

        UNKNOWN_TO_SDK_VERSION
    }
}
