/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are required to perform reencryption operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReEncryptionAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ReEncryptionAttributes.Builder, ReEncryptionAttributes> {
    private static final SdkField<SymmetricEncryptionAttributes> SYMMETRIC_FIELD = SdkField
            .<SymmetricEncryptionAttributes> builder(MarshallingType.SDK_POJO).memberName("Symmetric")
            .getter(getter(ReEncryptionAttributes::symmetric)).setter(setter(Builder::symmetric))
            .constructor(SymmetricEncryptionAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Symmetric").build()).build();

    private static final SdkField<DukptEncryptionAttributes> DUKPT_FIELD = SdkField
            .<DukptEncryptionAttributes> builder(MarshallingType.SDK_POJO).memberName("Dukpt")
            .getter(getter(ReEncryptionAttributes::dukpt)).setter(setter(Builder::dukpt))
            .constructor(DukptEncryptionAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dukpt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYMMETRIC_FIELD, DUKPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SymmetricEncryptionAttributes symmetric;

    private final DukptEncryptionAttributes dukpt;

    private final Type type;

    private ReEncryptionAttributes(BuilderImpl builder) {
        this.symmetric = builder.symmetric;
        this.dukpt = builder.dukpt;
        this.type = builder.type;
    }

    /**
     * <p>
     * Parameters that are required to encrypt data using symmetric keys.
     * </p>
     * 
     * @return Parameters that are required to encrypt data using symmetric keys.
     */
    public final SymmetricEncryptionAttributes symmetric() {
        return symmetric;
    }

    /**
     * Returns the value of the Dukpt property for this object.
     * 
     * @return The value of the Dukpt property for this object.
     */
    public final DukptEncryptionAttributes dukpt() {
        return dukpt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(symmetric());
        hashCode = 31 * hashCode + Objects.hashCode(dukpt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReEncryptionAttributes)) {
            return false;
        }
        ReEncryptionAttributes other = (ReEncryptionAttributes) obj;
        return Objects.equals(symmetric(), other.symmetric()) && Objects.equals(dukpt(), other.dukpt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReEncryptionAttributes").add("Symmetric", symmetric()).add("Dukpt", dukpt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Symmetric":
            return Optional.ofNullable(clazz.cast(symmetric()));
        case "Dukpt":
            return Optional.ofNullable(clazz.cast(dukpt()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #symmetric()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to encrypt data using symmetric keys.
     * </p>
     * 
     * @param symmetric
     *        Parameters that are required to encrypt data using symmetric keys.
     */
    public static ReEncryptionAttributes fromSymmetric(SymmetricEncryptionAttributes symmetric) {
        return builder().symmetric(symmetric).build();
    }

    /**
     * Create an instance of this class with {@link #symmetric()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to encrypt data using symmetric keys.
     * </p>
     * 
     * @param symmetric
     *        Parameters that are required to encrypt data using symmetric keys.
     */
    public static ReEncryptionAttributes fromSymmetric(Consumer<SymmetricEncryptionAttributes.Builder> symmetric) {
        SymmetricEncryptionAttributes.Builder builder = SymmetricEncryptionAttributes.builder();
        symmetric.accept(builder);
        return fromSymmetric(builder.build());
    }

    /**
     * Create an instance of this class with {@link #dukpt()} initialized to the given value.
     *
     * Sets the value of the Dukpt property for this object.
     *
     * @param dukpt
     *        The new value for the Dukpt property for this object.
     */
    public static ReEncryptionAttributes fromDukpt(DukptEncryptionAttributes dukpt) {
        return builder().dukpt(dukpt).build();
    }

    /**
     * Create an instance of this class with {@link #dukpt()} initialized to the given value.
     *
     * Sets the value of the Dukpt property for this object.
     *
     * @param dukpt
     *        The new value for the Dukpt property for this object.
     */
    public static ReEncryptionAttributes fromDukpt(Consumer<DukptEncryptionAttributes.Builder> dukpt) {
        DukptEncryptionAttributes.Builder builder = DukptEncryptionAttributes.builder();
        dukpt.accept(builder);
        return fromDukpt(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Symmetric", SYMMETRIC_FIELD);
        map.put("Dukpt", DUKPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReEncryptionAttributes, T> g) {
        return obj -> g.apply((ReEncryptionAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReEncryptionAttributes> {
        /**
         * <p>
         * Parameters that are required to encrypt data using symmetric keys.
         * </p>
         * 
         * @param symmetric
         *        Parameters that are required to encrypt data using symmetric keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder symmetric(SymmetricEncryptionAttributes symmetric);

        /**
         * <p>
         * Parameters that are required to encrypt data using symmetric keys.
         * </p>
         * This is a convenience method that creates an instance of the {@link SymmetricEncryptionAttributes.Builder}
         * avoiding the need to create one manually via {@link SymmetricEncryptionAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SymmetricEncryptionAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #symmetric(SymmetricEncryptionAttributes)}.
         * 
         * @param symmetric
         *        a consumer that will call methods on {@link SymmetricEncryptionAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #symmetric(SymmetricEncryptionAttributes)
         */
        default Builder symmetric(Consumer<SymmetricEncryptionAttributes.Builder> symmetric) {
            return symmetric(SymmetricEncryptionAttributes.builder().applyMutation(symmetric).build());
        }

        /**
         * Sets the value of the Dukpt property for this object.
         *
         * @param dukpt
         *        The new value for the Dukpt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dukpt(DukptEncryptionAttributes dukpt);

        /**
         * Sets the value of the Dukpt property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DukptEncryptionAttributes.Builder}
         * avoiding the need to create one manually via {@link DukptEncryptionAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DukptEncryptionAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #dukpt(DukptEncryptionAttributes)}.
         * 
         * @param dukpt
         *        a consumer that will call methods on {@link DukptEncryptionAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dukpt(DukptEncryptionAttributes)
         */
        default Builder dukpt(Consumer<DukptEncryptionAttributes.Builder> dukpt) {
            return dukpt(DukptEncryptionAttributes.builder().applyMutation(dukpt).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SymmetricEncryptionAttributes symmetric;

        private DukptEncryptionAttributes dukpt;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ReEncryptionAttributes model) {
            symmetric(model.symmetric);
            dukpt(model.dukpt);
        }

        public final SymmetricEncryptionAttributes.Builder getSymmetric() {
            return symmetric != null ? symmetric.toBuilder() : null;
        }

        public final void setSymmetric(SymmetricEncryptionAttributes.BuilderImpl symmetric) {
            Object oldValue = this.symmetric;
            this.symmetric = symmetric != null ? symmetric.build() : null;
            handleUnionValueChange(Type.SYMMETRIC, oldValue, this.symmetric);
        }

        @Override
        public final Builder symmetric(SymmetricEncryptionAttributes symmetric) {
            Object oldValue = this.symmetric;
            this.symmetric = symmetric;
            handleUnionValueChange(Type.SYMMETRIC, oldValue, this.symmetric);
            return this;
        }

        public final DukptEncryptionAttributes.Builder getDukpt() {
            return dukpt != null ? dukpt.toBuilder() : null;
        }

        public final void setDukpt(DukptEncryptionAttributes.BuilderImpl dukpt) {
            Object oldValue = this.dukpt;
            this.dukpt = dukpt != null ? dukpt.build() : null;
            handleUnionValueChange(Type.DUKPT, oldValue, this.dukpt);
        }

        @Override
        public final Builder dukpt(DukptEncryptionAttributes dukpt) {
            Object oldValue = this.dukpt;
            this.dukpt = dukpt;
            handleUnionValueChange(Type.DUKPT, oldValue, this.dukpt);
            return this;
        }

        @Override
        public ReEncryptionAttributes build() {
            return new ReEncryptionAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ReEncryptionAttributes#type()
     */
    public enum Type {
        SYMMETRIC,

        DUKPT,

        UNKNOWN_TO_SDK_VERSION
    }
}
