/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameter information of a TR31KeyBlock wrapped using an ECDH derived key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncomingDiffieHellmanTr31KeyBlock implements SdkPojo, Serializable,
        ToCopyableBuilder<IncomingDiffieHellmanTr31KeyBlock.Builder, IncomingDiffieHellmanTr31KeyBlock> {
    private static final SdkField<String> PRIVATE_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateKeyIdentifier").getter(getter(IncomingDiffieHellmanTr31KeyBlock::privateKeyIdentifier))
            .setter(setter(Builder::privateKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKeyIdentifier").build())
            .build();

    private static final SdkField<String> CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CertificateAuthorityPublicKeyIdentifier")
            .getter(getter(IncomingDiffieHellmanTr31KeyBlock::certificateAuthorityPublicKeyIdentifier))
            .setter(setter(Builder::certificateAuthorityPublicKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CertificateAuthorityPublicKeyIdentifier").build()).build();

    private static final SdkField<String> PUBLIC_KEY_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicKeyCertificate").getter(getter(IncomingDiffieHellmanTr31KeyBlock::publicKeyCertificate))
            .setter(setter(Builder::publicKeyCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyCertificate").build())
            .build();

    private static final SdkField<String> DERIVE_KEY_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeriveKeyAlgorithm").getter(getter(IncomingDiffieHellmanTr31KeyBlock::deriveKeyAlgorithmAsString))
            .setter(setter(Builder::deriveKeyAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeriveKeyAlgorithm").build())
            .build();

    private static final SdkField<String> KEY_DERIVATION_FUNCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyDerivationFunction").getter(getter(IncomingDiffieHellmanTr31KeyBlock::keyDerivationFunctionAsString))
            .setter(setter(Builder::keyDerivationFunction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyDerivationFunction").build())
            .build();

    private static final SdkField<String> KEY_DERIVATION_HASH_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KeyDerivationHashAlgorithm")
            .getter(getter(IncomingDiffieHellmanTr31KeyBlock::keyDerivationHashAlgorithmAsString))
            .setter(setter(Builder::keyDerivationHashAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyDerivationHashAlgorithm").build())
            .build();

    private static final SdkField<DiffieHellmanDerivationData> DERIVATION_DATA_FIELD = SdkField
            .<DiffieHellmanDerivationData> builder(MarshallingType.SDK_POJO).memberName("DerivationData")
            .getter(getter(IncomingDiffieHellmanTr31KeyBlock::derivationData)).setter(setter(Builder::derivationData))
            .constructor(DiffieHellmanDerivationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DerivationData").build()).build();

    private static final SdkField<String> WRAPPED_KEY_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WrappedKeyBlock").getter(getter(IncomingDiffieHellmanTr31KeyBlock::wrappedKeyBlock))
            .setter(setter(Builder::wrappedKeyBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappedKeyBlock").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIVATE_KEY_IDENTIFIER_FIELD,
            CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD, PUBLIC_KEY_CERTIFICATE_FIELD, DERIVE_KEY_ALGORITHM_FIELD,
            KEY_DERIVATION_FUNCTION_FIELD, KEY_DERIVATION_HASH_ALGORITHM_FIELD, DERIVATION_DATA_FIELD, WRAPPED_KEY_BLOCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String privateKeyIdentifier;

    private final String certificateAuthorityPublicKeyIdentifier;

    private final String publicKeyCertificate;

    private final String deriveKeyAlgorithm;

    private final String keyDerivationFunction;

    private final String keyDerivationHashAlgorithm;

    private final DiffieHellmanDerivationData derivationData;

    private final String wrappedKeyBlock;

    private IncomingDiffieHellmanTr31KeyBlock(BuilderImpl builder) {
        this.privateKeyIdentifier = builder.privateKeyIdentifier;
        this.certificateAuthorityPublicKeyIdentifier = builder.certificateAuthorityPublicKeyIdentifier;
        this.publicKeyCertificate = builder.publicKeyCertificate;
        this.deriveKeyAlgorithm = builder.deriveKeyAlgorithm;
        this.keyDerivationFunction = builder.keyDerivationFunction;
        this.keyDerivationHashAlgorithm = builder.keyDerivationHashAlgorithm;
        this.derivationData = builder.derivationData;
        this.wrappedKeyBlock = builder.wrappedKeyBlock;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the asymmetric ECC key pair.
     * </p>
     * 
     * @return The <code>keyARN</code> of the asymmetric ECC key pair.
     */
    public final String privateKeyIdentifier() {
        return privateKeyIdentifier;
    }

    /**
     * <p>
     * The <code>keyArn</code> of the certificate that signed the client's <code>PublicKeyCertificate</code>.
     * </p>
     * 
     * @return The <code>keyArn</code> of the certificate that signed the client's <code>PublicKeyCertificate</code>.
     */
    public final String certificateAuthorityPublicKeyIdentifier() {
        return certificateAuthorityPublicKeyIdentifier;
    }

    /**
     * <p>
     * The client's public key certificate in PEM format (base64 encoded) to use for ECDH key derivation.
     * </p>
     * 
     * @return The client's public key certificate in PEM format (base64 encoded) to use for ECDH key derivation.
     */
    public final String publicKeyCertificate() {
        return publicKeyCertificate;
    }

    /**
     * <p>
     * The key algorithm of the derived ECDH key.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deriveKeyAlgorithm} will return {@link SymmetricKeyAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deriveKeyAlgorithmAsString}.
     * </p>
     * 
     * @return The key algorithm of the derived ECDH key.
     * @see SymmetricKeyAlgorithm
     */
    public final SymmetricKeyAlgorithm deriveKeyAlgorithm() {
        return SymmetricKeyAlgorithm.fromValue(deriveKeyAlgorithm);
    }

    /**
     * <p>
     * The key algorithm of the derived ECDH key.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deriveKeyAlgorithm} will return {@link SymmetricKeyAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deriveKeyAlgorithmAsString}.
     * </p>
     * 
     * @return The key algorithm of the derived ECDH key.
     * @see SymmetricKeyAlgorithm
     */
    public final String deriveKeyAlgorithmAsString() {
        return deriveKeyAlgorithm;
    }

    /**
     * <p>
     * The key derivation function to use for deriving a key using ECDH.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #keyDerivationFunction} will return {@link KeyDerivationFunction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #keyDerivationFunctionAsString}.
     * </p>
     * 
     * @return The key derivation function to use for deriving a key using ECDH.
     * @see KeyDerivationFunction
     */
    public final KeyDerivationFunction keyDerivationFunction() {
        return KeyDerivationFunction.fromValue(keyDerivationFunction);
    }

    /**
     * <p>
     * The key derivation function to use for deriving a key using ECDH.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #keyDerivationFunction} will return {@link KeyDerivationFunction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #keyDerivationFunctionAsString}.
     * </p>
     * 
     * @return The key derivation function to use for deriving a key using ECDH.
     * @see KeyDerivationFunction
     */
    public final String keyDerivationFunctionAsString() {
        return keyDerivationFunction;
    }

    /**
     * <p>
     * The hash type to use for deriving a key using ECDH.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #keyDerivationHashAlgorithm} will return {@link KeyDerivationHashAlgorithm#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #keyDerivationHashAlgorithmAsString}.
     * </p>
     * 
     * @return The hash type to use for deriving a key using ECDH.
     * @see KeyDerivationHashAlgorithm
     */
    public final KeyDerivationHashAlgorithm keyDerivationHashAlgorithm() {
        return KeyDerivationHashAlgorithm.fromValue(keyDerivationHashAlgorithm);
    }

    /**
     * <p>
     * The hash type to use for deriving a key using ECDH.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #keyDerivationHashAlgorithm} will return {@link KeyDerivationHashAlgorithm#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #keyDerivationHashAlgorithmAsString}.
     * </p>
     * 
     * @return The hash type to use for deriving a key using ECDH.
     * @see KeyDerivationHashAlgorithm
     */
    public final String keyDerivationHashAlgorithmAsString() {
        return keyDerivationHashAlgorithm;
    }

    /**
     * Returns the value of the DerivationData property for this object.
     * 
     * @return The value of the DerivationData property for this object.
     */
    public final DiffieHellmanDerivationData derivationData() {
        return derivationData;
    }

    /**
     * <p>
     * The WrappedKeyBlock containing the transaction key wrapped using an ECDH dervied key.
     * </p>
     * 
     * @return The WrappedKeyBlock containing the transaction key wrapped using an ECDH dervied key.
     */
    public final String wrappedKeyBlock() {
        return wrappedKeyBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(privateKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityPublicKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(publicKeyCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(deriveKeyAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyDerivationFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyDerivationHashAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(derivationData());
        hashCode = 31 * hashCode + Objects.hashCode(wrappedKeyBlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncomingDiffieHellmanTr31KeyBlock)) {
            return false;
        }
        IncomingDiffieHellmanTr31KeyBlock other = (IncomingDiffieHellmanTr31KeyBlock) obj;
        return Objects.equals(privateKeyIdentifier(), other.privateKeyIdentifier())
                && Objects.equals(certificateAuthorityPublicKeyIdentifier(), other.certificateAuthorityPublicKeyIdentifier())
                && Objects.equals(publicKeyCertificate(), other.publicKeyCertificate())
                && Objects.equals(deriveKeyAlgorithmAsString(), other.deriveKeyAlgorithmAsString())
                && Objects.equals(keyDerivationFunctionAsString(), other.keyDerivationFunctionAsString())
                && Objects.equals(keyDerivationHashAlgorithmAsString(), other.keyDerivationHashAlgorithmAsString())
                && Objects.equals(derivationData(), other.derivationData())
                && Objects.equals(wrappedKeyBlock(), other.wrappedKeyBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IncomingDiffieHellmanTr31KeyBlock").add("PrivateKeyIdentifier", privateKeyIdentifier())
                .add("CertificateAuthorityPublicKeyIdentifier", certificateAuthorityPublicKeyIdentifier())
                .add("PublicKeyCertificate", publicKeyCertificate()).add("DeriveKeyAlgorithm", deriveKeyAlgorithmAsString())
                .add("KeyDerivationFunction", keyDerivationFunctionAsString())
                .add("KeyDerivationHashAlgorithm", keyDerivationHashAlgorithmAsString()).add("DerivationData", derivationData())
                .add("WrappedKeyBlock", wrappedKeyBlock() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrivateKeyIdentifier":
            return Optional.ofNullable(clazz.cast(privateKeyIdentifier()));
        case "CertificateAuthorityPublicKeyIdentifier":
            return Optional.ofNullable(clazz.cast(certificateAuthorityPublicKeyIdentifier()));
        case "PublicKeyCertificate":
            return Optional.ofNullable(clazz.cast(publicKeyCertificate()));
        case "DeriveKeyAlgorithm":
            return Optional.ofNullable(clazz.cast(deriveKeyAlgorithmAsString()));
        case "KeyDerivationFunction":
            return Optional.ofNullable(clazz.cast(keyDerivationFunctionAsString()));
        case "KeyDerivationHashAlgorithm":
            return Optional.ofNullable(clazz.cast(keyDerivationHashAlgorithmAsString()));
        case "DerivationData":
            return Optional.ofNullable(clazz.cast(derivationData()));
        case "WrappedKeyBlock":
            return Optional.ofNullable(clazz.cast(wrappedKeyBlock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrivateKeyIdentifier", PRIVATE_KEY_IDENTIFIER_FIELD);
        map.put("CertificateAuthorityPublicKeyIdentifier", CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD);
        map.put("PublicKeyCertificate", PUBLIC_KEY_CERTIFICATE_FIELD);
        map.put("DeriveKeyAlgorithm", DERIVE_KEY_ALGORITHM_FIELD);
        map.put("KeyDerivationFunction", KEY_DERIVATION_FUNCTION_FIELD);
        map.put("KeyDerivationHashAlgorithm", KEY_DERIVATION_HASH_ALGORITHM_FIELD);
        map.put("DerivationData", DERIVATION_DATA_FIELD);
        map.put("WrappedKeyBlock", WRAPPED_KEY_BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IncomingDiffieHellmanTr31KeyBlock, T> g) {
        return obj -> g.apply((IncomingDiffieHellmanTr31KeyBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IncomingDiffieHellmanTr31KeyBlock> {
        /**
         * <p>
         * The <code>keyARN</code> of the asymmetric ECC key pair.
         * </p>
         * 
         * @param privateKeyIdentifier
         *        The <code>keyARN</code> of the asymmetric ECC key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKeyIdentifier(String privateKeyIdentifier);

        /**
         * <p>
         * The <code>keyArn</code> of the certificate that signed the client's <code>PublicKeyCertificate</code>.
         * </p>
         * 
         * @param certificateAuthorityPublicKeyIdentifier
         *        The <code>keyArn</code> of the certificate that signed the client's <code>PublicKeyCertificate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier);

        /**
         * <p>
         * The client's public key certificate in PEM format (base64 encoded) to use for ECDH key derivation.
         * </p>
         * 
         * @param publicKeyCertificate
         *        The client's public key certificate in PEM format (base64 encoded) to use for ECDH key derivation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyCertificate(String publicKeyCertificate);

        /**
         * <p>
         * The key algorithm of the derived ECDH key.
         * </p>
         * 
         * @param deriveKeyAlgorithm
         *        The key algorithm of the derived ECDH key.
         * @see SymmetricKeyAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SymmetricKeyAlgorithm
         */
        Builder deriveKeyAlgorithm(String deriveKeyAlgorithm);

        /**
         * <p>
         * The key algorithm of the derived ECDH key.
         * </p>
         * 
         * @param deriveKeyAlgorithm
         *        The key algorithm of the derived ECDH key.
         * @see SymmetricKeyAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SymmetricKeyAlgorithm
         */
        Builder deriveKeyAlgorithm(SymmetricKeyAlgorithm deriveKeyAlgorithm);

        /**
         * <p>
         * The key derivation function to use for deriving a key using ECDH.
         * </p>
         * 
         * @param keyDerivationFunction
         *        The key derivation function to use for deriving a key using ECDH.
         * @see KeyDerivationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyDerivationFunction
         */
        Builder keyDerivationFunction(String keyDerivationFunction);

        /**
         * <p>
         * The key derivation function to use for deriving a key using ECDH.
         * </p>
         * 
         * @param keyDerivationFunction
         *        The key derivation function to use for deriving a key using ECDH.
         * @see KeyDerivationFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyDerivationFunction
         */
        Builder keyDerivationFunction(KeyDerivationFunction keyDerivationFunction);

        /**
         * <p>
         * The hash type to use for deriving a key using ECDH.
         * </p>
         * 
         * @param keyDerivationHashAlgorithm
         *        The hash type to use for deriving a key using ECDH.
         * @see KeyDerivationHashAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyDerivationHashAlgorithm
         */
        Builder keyDerivationHashAlgorithm(String keyDerivationHashAlgorithm);

        /**
         * <p>
         * The hash type to use for deriving a key using ECDH.
         * </p>
         * 
         * @param keyDerivationHashAlgorithm
         *        The hash type to use for deriving a key using ECDH.
         * @see KeyDerivationHashAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KeyDerivationHashAlgorithm
         */
        Builder keyDerivationHashAlgorithm(KeyDerivationHashAlgorithm keyDerivationHashAlgorithm);

        /**
         * Sets the value of the DerivationData property for this object.
         *
         * @param derivationData
         *        The new value for the DerivationData property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder derivationData(DiffieHellmanDerivationData derivationData);

        /**
         * Sets the value of the DerivationData property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DiffieHellmanDerivationData.Builder}
         * avoiding the need to create one manually via {@link DiffieHellmanDerivationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DiffieHellmanDerivationData.Builder#build()} is called
         * immediately and its result is passed to {@link #derivationData(DiffieHellmanDerivationData)}.
         * 
         * @param derivationData
         *        a consumer that will call methods on {@link DiffieHellmanDerivationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #derivationData(DiffieHellmanDerivationData)
         */
        default Builder derivationData(Consumer<DiffieHellmanDerivationData.Builder> derivationData) {
            return derivationData(DiffieHellmanDerivationData.builder().applyMutation(derivationData).build());
        }

        /**
         * <p>
         * The WrappedKeyBlock containing the transaction key wrapped using an ECDH dervied key.
         * </p>
         * 
         * @param wrappedKeyBlock
         *        The WrappedKeyBlock containing the transaction key wrapped using an ECDH dervied key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wrappedKeyBlock(String wrappedKeyBlock);
    }

    static final class BuilderImpl implements Builder {
        private String privateKeyIdentifier;

        private String certificateAuthorityPublicKeyIdentifier;

        private String publicKeyCertificate;

        private String deriveKeyAlgorithm;

        private String keyDerivationFunction;

        private String keyDerivationHashAlgorithm;

        private DiffieHellmanDerivationData derivationData;

        private String wrappedKeyBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(IncomingDiffieHellmanTr31KeyBlock model) {
            privateKeyIdentifier(model.privateKeyIdentifier);
            certificateAuthorityPublicKeyIdentifier(model.certificateAuthorityPublicKeyIdentifier);
            publicKeyCertificate(model.publicKeyCertificate);
            deriveKeyAlgorithm(model.deriveKeyAlgorithm);
            keyDerivationFunction(model.keyDerivationFunction);
            keyDerivationHashAlgorithm(model.keyDerivationHashAlgorithm);
            derivationData(model.derivationData);
            wrappedKeyBlock(model.wrappedKeyBlock);
        }

        public final String getPrivateKeyIdentifier() {
            return privateKeyIdentifier;
        }

        public final void setPrivateKeyIdentifier(String privateKeyIdentifier) {
            this.privateKeyIdentifier = privateKeyIdentifier;
        }

        @Override
        public final Builder privateKeyIdentifier(String privateKeyIdentifier) {
            this.privateKeyIdentifier = privateKeyIdentifier;
            return this;
        }

        public final String getCertificateAuthorityPublicKeyIdentifier() {
            return certificateAuthorityPublicKeyIdentifier;
        }

        public final void setCertificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
        }

        @Override
        public final Builder certificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
            return this;
        }

        public final String getPublicKeyCertificate() {
            return publicKeyCertificate;
        }

        public final void setPublicKeyCertificate(String publicKeyCertificate) {
            this.publicKeyCertificate = publicKeyCertificate;
        }

        @Override
        public final Builder publicKeyCertificate(String publicKeyCertificate) {
            this.publicKeyCertificate = publicKeyCertificate;
            return this;
        }

        public final String getDeriveKeyAlgorithm() {
            return deriveKeyAlgorithm;
        }

        public final void setDeriveKeyAlgorithm(String deriveKeyAlgorithm) {
            this.deriveKeyAlgorithm = deriveKeyAlgorithm;
        }

        @Override
        public final Builder deriveKeyAlgorithm(String deriveKeyAlgorithm) {
            this.deriveKeyAlgorithm = deriveKeyAlgorithm;
            return this;
        }

        @Override
        public final Builder deriveKeyAlgorithm(SymmetricKeyAlgorithm deriveKeyAlgorithm) {
            this.deriveKeyAlgorithm(deriveKeyAlgorithm == null ? null : deriveKeyAlgorithm.toString());
            return this;
        }

        public final String getKeyDerivationFunction() {
            return keyDerivationFunction;
        }

        public final void setKeyDerivationFunction(String keyDerivationFunction) {
            this.keyDerivationFunction = keyDerivationFunction;
        }

        @Override
        public final Builder keyDerivationFunction(String keyDerivationFunction) {
            this.keyDerivationFunction = keyDerivationFunction;
            return this;
        }

        @Override
        public final Builder keyDerivationFunction(KeyDerivationFunction keyDerivationFunction) {
            this.keyDerivationFunction(keyDerivationFunction == null ? null : keyDerivationFunction.toString());
            return this;
        }

        public final String getKeyDerivationHashAlgorithm() {
            return keyDerivationHashAlgorithm;
        }

        public final void setKeyDerivationHashAlgorithm(String keyDerivationHashAlgorithm) {
            this.keyDerivationHashAlgorithm = keyDerivationHashAlgorithm;
        }

        @Override
        public final Builder keyDerivationHashAlgorithm(String keyDerivationHashAlgorithm) {
            this.keyDerivationHashAlgorithm = keyDerivationHashAlgorithm;
            return this;
        }

        @Override
        public final Builder keyDerivationHashAlgorithm(KeyDerivationHashAlgorithm keyDerivationHashAlgorithm) {
            this.keyDerivationHashAlgorithm(keyDerivationHashAlgorithm == null ? null : keyDerivationHashAlgorithm.toString());
            return this;
        }

        public final DiffieHellmanDerivationData.Builder getDerivationData() {
            return derivationData != null ? derivationData.toBuilder() : null;
        }

        public final void setDerivationData(DiffieHellmanDerivationData.BuilderImpl derivationData) {
            this.derivationData = derivationData != null ? derivationData.build() : null;
        }

        @Override
        public final Builder derivationData(DiffieHellmanDerivationData derivationData) {
            this.derivationData = derivationData;
            return this;
        }

        public final String getWrappedKeyBlock() {
            return wrappedKeyBlock;
        }

        public final void setWrappedKeyBlock(String wrappedKeyBlock) {
            this.wrappedKeyBlock = wrappedKeyBlock;
        }

        @Override
        public final Builder wrappedKeyBlock(String wrappedKeyBlock) {
            this.wrappedKeyBlock = wrappedKeyBlock;
            return this;
        }

        @Override
        public IncomingDiffieHellmanTr31KeyBlock build() {
            return new IncomingDiffieHellmanTr31KeyBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
