/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Pparameters that are required to generate or verify Ibm3624 PIN offset PIN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ibm3624PinOffset implements SdkPojo, Serializable,
        ToCopyableBuilder<Ibm3624PinOffset.Builder, Ibm3624PinOffset> {
    private static final SdkField<String> ENCRYPTED_PIN_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptedPinBlock").getter(getter(Ibm3624PinOffset::encryptedPinBlock))
            .setter(setter(Builder::encryptedPinBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedPinBlock").build()).build();

    private static final SdkField<String> DECIMALIZATION_TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DecimalizationTable").getter(getter(Ibm3624PinOffset::decimalizationTable))
            .setter(setter(Builder::decimalizationTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalizationTable").build())
            .build();

    private static final SdkField<String> PIN_VALIDATION_DATA_PAD_CHARACTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PinValidationDataPadCharacter")
            .getter(getter(Ibm3624PinOffset::pinValidationDataPadCharacter))
            .setter(setter(Builder::pinValidationDataPadCharacter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinValidationDataPadCharacter")
                    .build()).build();

    private static final SdkField<String> PIN_VALIDATION_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PinValidationData").getter(getter(Ibm3624PinOffset::pinValidationData))
            .setter(setter(Builder::pinValidationData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinValidationData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTED_PIN_BLOCK_FIELD,
            DECIMALIZATION_TABLE_FIELD, PIN_VALIDATION_DATA_PAD_CHARACTER_FIELD, PIN_VALIDATION_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String encryptedPinBlock;

    private final String decimalizationTable;

    private final String pinValidationDataPadCharacter;

    private final String pinValidationData;

    private Ibm3624PinOffset(BuilderImpl builder) {
        this.encryptedPinBlock = builder.encryptedPinBlock;
        this.decimalizationTable = builder.decimalizationTable;
        this.pinValidationDataPadCharacter = builder.pinValidationDataPadCharacter;
        this.pinValidationData = builder.pinValidationData;
    }

    /**
     * <p>
     * The encrypted PIN block data. According to ISO 9564 standard, a PIN Block is an encoded representation of a
     * payment card Personal Account Number (PAN) and the cardholder Personal Identification Number (PIN).
     * </p>
     * 
     * @return The encrypted PIN block data. According to ISO 9564 standard, a PIN Block is an encoded representation of
     *         a payment card Personal Account Number (PAN) and the cardholder Personal Identification Number (PIN).
     */
    public final String encryptedPinBlock() {
        return encryptedPinBlock;
    }

    /**
     * <p>
     * The decimalization table to use for IBM 3624 PIN algorithm. The table is used to convert the algorithm
     * intermediate result from hexadecimal characters to decimal.
     * </p>
     * 
     * @return The decimalization table to use for IBM 3624 PIN algorithm. The table is used to convert the algorithm
     *         intermediate result from hexadecimal characters to decimal.
     */
    public final String decimalizationTable() {
        return decimalizationTable;
    }

    /**
     * <p>
     * The padding character for validation data.
     * </p>
     * 
     * @return The padding character for validation data.
     */
    public final String pinValidationDataPadCharacter() {
        return pinValidationDataPadCharacter;
    }

    /**
     * <p>
     * The unique data for cardholder identification.
     * </p>
     * 
     * @return The unique data for cardholder identification.
     */
    public final String pinValidationData() {
        return pinValidationData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptedPinBlock());
        hashCode = 31 * hashCode + Objects.hashCode(decimalizationTable());
        hashCode = 31 * hashCode + Objects.hashCode(pinValidationDataPadCharacter());
        hashCode = 31 * hashCode + Objects.hashCode(pinValidationData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ibm3624PinOffset)) {
            return false;
        }
        Ibm3624PinOffset other = (Ibm3624PinOffset) obj;
        return Objects.equals(encryptedPinBlock(), other.encryptedPinBlock())
                && Objects.equals(decimalizationTable(), other.decimalizationTable())
                && Objects.equals(pinValidationDataPadCharacter(), other.pinValidationDataPadCharacter())
                && Objects.equals(pinValidationData(), other.pinValidationData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ibm3624PinOffset")
                .add("EncryptedPinBlock", encryptedPinBlock() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DecimalizationTable", decimalizationTable() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PinValidationDataPadCharacter", pinValidationDataPadCharacter())
                .add("PinValidationData", pinValidationData() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptedPinBlock":
            return Optional.ofNullable(clazz.cast(encryptedPinBlock()));
        case "DecimalizationTable":
            return Optional.ofNullable(clazz.cast(decimalizationTable()));
        case "PinValidationDataPadCharacter":
            return Optional.ofNullable(clazz.cast(pinValidationDataPadCharacter()));
        case "PinValidationData":
            return Optional.ofNullable(clazz.cast(pinValidationData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EncryptedPinBlock", ENCRYPTED_PIN_BLOCK_FIELD);
        map.put("DecimalizationTable", DECIMALIZATION_TABLE_FIELD);
        map.put("PinValidationDataPadCharacter", PIN_VALIDATION_DATA_PAD_CHARACTER_FIELD);
        map.put("PinValidationData", PIN_VALIDATION_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ibm3624PinOffset, T> g) {
        return obj -> g.apply((Ibm3624PinOffset) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ibm3624PinOffset> {
        /**
         * <p>
         * The encrypted PIN block data. According to ISO 9564 standard, a PIN Block is an encoded representation of a
         * payment card Personal Account Number (PAN) and the cardholder Personal Identification Number (PIN).
         * </p>
         * 
         * @param encryptedPinBlock
         *        The encrypted PIN block data. According to ISO 9564 standard, a PIN Block is an encoded representation
         *        of a payment card Personal Account Number (PAN) and the cardholder Personal Identification Number
         *        (PIN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptedPinBlock(String encryptedPinBlock);

        /**
         * <p>
         * The decimalization table to use for IBM 3624 PIN algorithm. The table is used to convert the algorithm
         * intermediate result from hexadecimal characters to decimal.
         * </p>
         * 
         * @param decimalizationTable
         *        The decimalization table to use for IBM 3624 PIN algorithm. The table is used to convert the algorithm
         *        intermediate result from hexadecimal characters to decimal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalizationTable(String decimalizationTable);

        /**
         * <p>
         * The padding character for validation data.
         * </p>
         * 
         * @param pinValidationDataPadCharacter
         *        The padding character for validation data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinValidationDataPadCharacter(String pinValidationDataPadCharacter);

        /**
         * <p>
         * The unique data for cardholder identification.
         * </p>
         * 
         * @param pinValidationData
         *        The unique data for cardholder identification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinValidationData(String pinValidationData);
    }

    static final class BuilderImpl implements Builder {
        private String encryptedPinBlock;

        private String decimalizationTable;

        private String pinValidationDataPadCharacter;

        private String pinValidationData;

        private BuilderImpl() {
        }

        private BuilderImpl(Ibm3624PinOffset model) {
            encryptedPinBlock(model.encryptedPinBlock);
            decimalizationTable(model.decimalizationTable);
            pinValidationDataPadCharacter(model.pinValidationDataPadCharacter);
            pinValidationData(model.pinValidationData);
        }

        public final String getEncryptedPinBlock() {
            return encryptedPinBlock;
        }

        public final void setEncryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
        }

        @Override
        public final Builder encryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
            return this;
        }

        public final String getDecimalizationTable() {
            return decimalizationTable;
        }

        public final void setDecimalizationTable(String decimalizationTable) {
            this.decimalizationTable = decimalizationTable;
        }

        @Override
        public final Builder decimalizationTable(String decimalizationTable) {
            this.decimalizationTable = decimalizationTable;
            return this;
        }

        public final String getPinValidationDataPadCharacter() {
            return pinValidationDataPadCharacter;
        }

        public final void setPinValidationDataPadCharacter(String pinValidationDataPadCharacter) {
            this.pinValidationDataPadCharacter = pinValidationDataPadCharacter;
        }

        @Override
        public final Builder pinValidationDataPadCharacter(String pinValidationDataPadCharacter) {
            this.pinValidationDataPadCharacter = pinValidationDataPadCharacter;
            return this;
        }

        public final String getPinValidationData() {
            return pinValidationData;
        }

        public final void setPinValidationData(String pinValidationData) {
            this.pinValidationData = pinValidationData;
        }

        @Override
        public final Builder pinValidationData(String pinValidationData) {
            this.pinValidationData = pinValidationData;
            return this;
        }

        @Override
        public Ibm3624PinOffset build() {
            return new Ibm3624PinOffset(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
