/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateMacEmvPinChangeRequest extends PaymentCryptographyDataRequest implements
        ToCopyableBuilder<GenerateMacEmvPinChangeRequest.Builder, GenerateMacEmvPinChangeRequest> {
    private static final SdkField<String> NEW_PIN_PEK_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewPinPekIdentifier").getter(getter(GenerateMacEmvPinChangeRequest::newPinPekIdentifier))
            .setter(setter(Builder::newPinPekIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewPinPekIdentifier").build())
            .build();

    private static final SdkField<String> NEW_ENCRYPTED_PIN_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewEncryptedPinBlock").getter(getter(GenerateMacEmvPinChangeRequest::newEncryptedPinBlock))
            .setter(setter(Builder::newEncryptedPinBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewEncryptedPinBlock").build())
            .build();

    private static final SdkField<String> PIN_BLOCK_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PinBlockFormat").getter(getter(GenerateMacEmvPinChangeRequest::pinBlockFormatAsString))
            .setter(setter(Builder::pinBlockFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinBlockFormat").build()).build();

    private static final SdkField<String> SECURE_MESSAGING_INTEGRITY_KEY_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecureMessagingIntegrityKeyIdentifier")
            .getter(getter(GenerateMacEmvPinChangeRequest::secureMessagingIntegrityKeyIdentifier))
            .setter(setter(Builder::secureMessagingIntegrityKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SecureMessagingIntegrityKeyIdentifier").build()).build();

    private static final SdkField<String> SECURE_MESSAGING_CONFIDENTIALITY_KEY_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecureMessagingConfidentialityKeyIdentifier")
            .getter(getter(GenerateMacEmvPinChangeRequest::secureMessagingConfidentialityKeyIdentifier))
            .setter(setter(Builder::secureMessagingConfidentialityKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SecureMessagingConfidentialityKeyIdentifier").build()).build();

    private static final SdkField<String> MESSAGE_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageData").getter(getter(GenerateMacEmvPinChangeRequest::messageData))
            .setter(setter(Builder::messageData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageData").build()).build();

    private static final SdkField<DerivationMethodAttributes> DERIVATION_METHOD_ATTRIBUTES_FIELD = SdkField
            .<DerivationMethodAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("DerivationMethodAttributes")
            .getter(getter(GenerateMacEmvPinChangeRequest::derivationMethodAttributes))
            .setter(setter(Builder::derivationMethodAttributes))
            .constructor(DerivationMethodAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DerivationMethodAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEW_PIN_PEK_IDENTIFIER_FIELD,
            NEW_ENCRYPTED_PIN_BLOCK_FIELD, PIN_BLOCK_FORMAT_FIELD, SECURE_MESSAGING_INTEGRITY_KEY_IDENTIFIER_FIELD,
            SECURE_MESSAGING_CONFIDENTIALITY_KEY_IDENTIFIER_FIELD, MESSAGE_DATA_FIELD, DERIVATION_METHOD_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String newPinPekIdentifier;

    private final String newEncryptedPinBlock;

    private final String pinBlockFormat;

    private final String secureMessagingIntegrityKeyIdentifier;

    private final String secureMessagingConfidentialityKeyIdentifier;

    private final String messageData;

    private final DerivationMethodAttributes derivationMethodAttributes;

    private GenerateMacEmvPinChangeRequest(BuilderImpl builder) {
        super(builder);
        this.newPinPekIdentifier = builder.newPinPekIdentifier;
        this.newEncryptedPinBlock = builder.newEncryptedPinBlock;
        this.pinBlockFormat = builder.pinBlockFormat;
        this.secureMessagingIntegrityKeyIdentifier = builder.secureMessagingIntegrityKeyIdentifier;
        this.secureMessagingConfidentialityKeyIdentifier = builder.secureMessagingConfidentialityKeyIdentifier;
        this.messageData = builder.messageData;
        this.derivationMethodAttributes = builder.derivationMethodAttributes;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the PEK protecting the incoming new encrypted PIN block.
     * </p>
     * 
     * @return The <code>keyARN</code> of the PEK protecting the incoming new encrypted PIN block.
     */
    public final String newPinPekIdentifier() {
        return newPinPekIdentifier;
    }

    /**
     * <p>
     * The incoming new encrypted PIN block data for offline pin change on an EMV card.
     * </p>
     * 
     * @return The incoming new encrypted PIN block data for offline pin change on an EMV card.
     */
    public final String newEncryptedPinBlock() {
        return newEncryptedPinBlock;
    }

    /**
     * <p>
     * The PIN encoding format of the incoming new encrypted PIN block as specified in ISO 9564.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pinBlockFormat}
     * will return {@link PinBlockFormatForEmvPinChange#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #pinBlockFormatAsString}.
     * </p>
     * 
     * @return The PIN encoding format of the incoming new encrypted PIN block as specified in ISO 9564.
     * @see PinBlockFormatForEmvPinChange
     */
    public final PinBlockFormatForEmvPinChange pinBlockFormat() {
        return PinBlockFormatForEmvPinChange.fromValue(pinBlockFormat);
    }

    /**
     * <p>
     * The PIN encoding format of the incoming new encrypted PIN block as specified in ISO 9564.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pinBlockFormat}
     * will return {@link PinBlockFormatForEmvPinChange#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #pinBlockFormatAsString}.
     * </p>
     * 
     * @return The PIN encoding format of the incoming new encrypted PIN block as specified in ISO 9564.
     * @see PinBlockFormatForEmvPinChange
     */
    public final String pinBlockFormatAsString() {
        return pinBlockFormat;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the issuer master key (IMK-SMI) used to authenticate the issuer script response.
     * </p>
     * 
     * @return The <code>keyARN</code> of the issuer master key (IMK-SMI) used to authenticate the issuer script
     *         response.
     */
    public final String secureMessagingIntegrityKeyIdentifier() {
        return secureMessagingIntegrityKeyIdentifier;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the issuer master key (IMK-SMC) used to protect the PIN block data in the issuer
     * script response.
     * </p>
     * 
     * @return The <code>keyARN</code> of the issuer master key (IMK-SMC) used to protect the PIN block data in the
     *         issuer script response.
     */
    public final String secureMessagingConfidentialityKeyIdentifier() {
        return secureMessagingConfidentialityKeyIdentifier;
    }

    /**
     * <p>
     * The message data is the APDU command from the card reader or terminal. The target encrypted PIN block, after
     * translation to ISO2 format, is appended to this message data to generate an issuer script response.
     * </p>
     * 
     * @return The message data is the APDU command from the card reader or terminal. The target encrypted PIN block,
     *         after translation to ISO2 format, is appended to this message data to generate an issuer script response.
     */
    public final String messageData() {
        return messageData;
    }

    /**
     * <p>
     * The attributes and data values to derive payment card specific confidentiality and integrity keys.
     * </p>
     * 
     * @return The attributes and data values to derive payment card specific confidentiality and integrity keys.
     */
    public final DerivationMethodAttributes derivationMethodAttributes() {
        return derivationMethodAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(newPinPekIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(newEncryptedPinBlock());
        hashCode = 31 * hashCode + Objects.hashCode(pinBlockFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(secureMessagingIntegrityKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(secureMessagingConfidentialityKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(messageData());
        hashCode = 31 * hashCode + Objects.hashCode(derivationMethodAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateMacEmvPinChangeRequest)) {
            return false;
        }
        GenerateMacEmvPinChangeRequest other = (GenerateMacEmvPinChangeRequest) obj;
        return Objects.equals(newPinPekIdentifier(), other.newPinPekIdentifier())
                && Objects.equals(newEncryptedPinBlock(), other.newEncryptedPinBlock())
                && Objects.equals(pinBlockFormatAsString(), other.pinBlockFormatAsString())
                && Objects.equals(secureMessagingIntegrityKeyIdentifier(), other.secureMessagingIntegrityKeyIdentifier())
                && Objects.equals(secureMessagingConfidentialityKeyIdentifier(),
                        other.secureMessagingConfidentialityKeyIdentifier())
                && Objects.equals(messageData(), other.messageData())
                && Objects.equals(derivationMethodAttributes(), other.derivationMethodAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateMacEmvPinChangeRequest").add("NewPinPekIdentifier", newPinPekIdentifier())
                .add("NewEncryptedPinBlock", newEncryptedPinBlock() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PinBlockFormat", pinBlockFormatAsString())
                .add("SecureMessagingIntegrityKeyIdentifier", secureMessagingIntegrityKeyIdentifier())
                .add("SecureMessagingConfidentialityKeyIdentifier", secureMessagingConfidentialityKeyIdentifier())
                .add("MessageData", messageData() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DerivationMethodAttributes", derivationMethodAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NewPinPekIdentifier":
            return Optional.ofNullable(clazz.cast(newPinPekIdentifier()));
        case "NewEncryptedPinBlock":
            return Optional.ofNullable(clazz.cast(newEncryptedPinBlock()));
        case "PinBlockFormat":
            return Optional.ofNullable(clazz.cast(pinBlockFormatAsString()));
        case "SecureMessagingIntegrityKeyIdentifier":
            return Optional.ofNullable(clazz.cast(secureMessagingIntegrityKeyIdentifier()));
        case "SecureMessagingConfidentialityKeyIdentifier":
            return Optional.ofNullable(clazz.cast(secureMessagingConfidentialityKeyIdentifier()));
        case "MessageData":
            return Optional.ofNullable(clazz.cast(messageData()));
        case "DerivationMethodAttributes":
            return Optional.ofNullable(clazz.cast(derivationMethodAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NewPinPekIdentifier", NEW_PIN_PEK_IDENTIFIER_FIELD);
        map.put("NewEncryptedPinBlock", NEW_ENCRYPTED_PIN_BLOCK_FIELD);
        map.put("PinBlockFormat", PIN_BLOCK_FORMAT_FIELD);
        map.put("SecureMessagingIntegrityKeyIdentifier", SECURE_MESSAGING_INTEGRITY_KEY_IDENTIFIER_FIELD);
        map.put("SecureMessagingConfidentialityKeyIdentifier", SECURE_MESSAGING_CONFIDENTIALITY_KEY_IDENTIFIER_FIELD);
        map.put("MessageData", MESSAGE_DATA_FIELD);
        map.put("DerivationMethodAttributes", DERIVATION_METHOD_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateMacEmvPinChangeRequest, T> g) {
        return obj -> g.apply((GenerateMacEmvPinChangeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PaymentCryptographyDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GenerateMacEmvPinChangeRequest> {
        /**
         * <p>
         * The <code>keyARN</code> of the PEK protecting the incoming new encrypted PIN block.
         * </p>
         * 
         * @param newPinPekIdentifier
         *        The <code>keyARN</code> of the PEK protecting the incoming new encrypted PIN block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newPinPekIdentifier(String newPinPekIdentifier);

        /**
         * <p>
         * The incoming new encrypted PIN block data for offline pin change on an EMV card.
         * </p>
         * 
         * @param newEncryptedPinBlock
         *        The incoming new encrypted PIN block data for offline pin change on an EMV card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newEncryptedPinBlock(String newEncryptedPinBlock);

        /**
         * <p>
         * The PIN encoding format of the incoming new encrypted PIN block as specified in ISO 9564.
         * </p>
         * 
         * @param pinBlockFormat
         *        The PIN encoding format of the incoming new encrypted PIN block as specified in ISO 9564.
         * @see PinBlockFormatForEmvPinChange
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PinBlockFormatForEmvPinChange
         */
        Builder pinBlockFormat(String pinBlockFormat);

        /**
         * <p>
         * The PIN encoding format of the incoming new encrypted PIN block as specified in ISO 9564.
         * </p>
         * 
         * @param pinBlockFormat
         *        The PIN encoding format of the incoming new encrypted PIN block as specified in ISO 9564.
         * @see PinBlockFormatForEmvPinChange
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PinBlockFormatForEmvPinChange
         */
        Builder pinBlockFormat(PinBlockFormatForEmvPinChange pinBlockFormat);

        /**
         * <p>
         * The <code>keyARN</code> of the issuer master key (IMK-SMI) used to authenticate the issuer script response.
         * </p>
         * 
         * @param secureMessagingIntegrityKeyIdentifier
         *        The <code>keyARN</code> of the issuer master key (IMK-SMI) used to authenticate the issuer script
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secureMessagingIntegrityKeyIdentifier(String secureMessagingIntegrityKeyIdentifier);

        /**
         * <p>
         * The <code>keyARN</code> of the issuer master key (IMK-SMC) used to protect the PIN block data in the issuer
         * script response.
         * </p>
         * 
         * @param secureMessagingConfidentialityKeyIdentifier
         *        The <code>keyARN</code> of the issuer master key (IMK-SMC) used to protect the PIN block data in the
         *        issuer script response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secureMessagingConfidentialityKeyIdentifier(String secureMessagingConfidentialityKeyIdentifier);

        /**
         * <p>
         * The message data is the APDU command from the card reader or terminal. The target encrypted PIN block, after
         * translation to ISO2 format, is appended to this message data to generate an issuer script response.
         * </p>
         * 
         * @param messageData
         *        The message data is the APDU command from the card reader or terminal. The target encrypted PIN block,
         *        after translation to ISO2 format, is appended to this message data to generate an issuer script
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageData(String messageData);

        /**
         * <p>
         * The attributes and data values to derive payment card specific confidentiality and integrity keys.
         * </p>
         * 
         * @param derivationMethodAttributes
         *        The attributes and data values to derive payment card specific confidentiality and integrity keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder derivationMethodAttributes(DerivationMethodAttributes derivationMethodAttributes);

        /**
         * <p>
         * The attributes and data values to derive payment card specific confidentiality and integrity keys.
         * </p>
         * This is a convenience method that creates an instance of the {@link DerivationMethodAttributes.Builder}
         * avoiding the need to create one manually via {@link DerivationMethodAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DerivationMethodAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #derivationMethodAttributes(DerivationMethodAttributes)}.
         * 
         * @param derivationMethodAttributes
         *        a consumer that will call methods on {@link DerivationMethodAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #derivationMethodAttributes(DerivationMethodAttributes)
         */
        default Builder derivationMethodAttributes(Consumer<DerivationMethodAttributes.Builder> derivationMethodAttributes) {
            return derivationMethodAttributes(DerivationMethodAttributes.builder().applyMutation(derivationMethodAttributes)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyDataRequest.BuilderImpl implements Builder {
        private String newPinPekIdentifier;

        private String newEncryptedPinBlock;

        private String pinBlockFormat;

        private String secureMessagingIntegrityKeyIdentifier;

        private String secureMessagingConfidentialityKeyIdentifier;

        private String messageData;

        private DerivationMethodAttributes derivationMethodAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateMacEmvPinChangeRequest model) {
            super(model);
            newPinPekIdentifier(model.newPinPekIdentifier);
            newEncryptedPinBlock(model.newEncryptedPinBlock);
            pinBlockFormat(model.pinBlockFormat);
            secureMessagingIntegrityKeyIdentifier(model.secureMessagingIntegrityKeyIdentifier);
            secureMessagingConfidentialityKeyIdentifier(model.secureMessagingConfidentialityKeyIdentifier);
            messageData(model.messageData);
            derivationMethodAttributes(model.derivationMethodAttributes);
        }

        public final String getNewPinPekIdentifier() {
            return newPinPekIdentifier;
        }

        public final void setNewPinPekIdentifier(String newPinPekIdentifier) {
            this.newPinPekIdentifier = newPinPekIdentifier;
        }

        @Override
        public final Builder newPinPekIdentifier(String newPinPekIdentifier) {
            this.newPinPekIdentifier = newPinPekIdentifier;
            return this;
        }

        public final String getNewEncryptedPinBlock() {
            return newEncryptedPinBlock;
        }

        public final void setNewEncryptedPinBlock(String newEncryptedPinBlock) {
            this.newEncryptedPinBlock = newEncryptedPinBlock;
        }

        @Override
        public final Builder newEncryptedPinBlock(String newEncryptedPinBlock) {
            this.newEncryptedPinBlock = newEncryptedPinBlock;
            return this;
        }

        public final String getPinBlockFormat() {
            return pinBlockFormat;
        }

        public final void setPinBlockFormat(String pinBlockFormat) {
            this.pinBlockFormat = pinBlockFormat;
        }

        @Override
        public final Builder pinBlockFormat(String pinBlockFormat) {
            this.pinBlockFormat = pinBlockFormat;
            return this;
        }

        @Override
        public final Builder pinBlockFormat(PinBlockFormatForEmvPinChange pinBlockFormat) {
            this.pinBlockFormat(pinBlockFormat == null ? null : pinBlockFormat.toString());
            return this;
        }

        public final String getSecureMessagingIntegrityKeyIdentifier() {
            return secureMessagingIntegrityKeyIdentifier;
        }

        public final void setSecureMessagingIntegrityKeyIdentifier(String secureMessagingIntegrityKeyIdentifier) {
            this.secureMessagingIntegrityKeyIdentifier = secureMessagingIntegrityKeyIdentifier;
        }

        @Override
        public final Builder secureMessagingIntegrityKeyIdentifier(String secureMessagingIntegrityKeyIdentifier) {
            this.secureMessagingIntegrityKeyIdentifier = secureMessagingIntegrityKeyIdentifier;
            return this;
        }

        public final String getSecureMessagingConfidentialityKeyIdentifier() {
            return secureMessagingConfidentialityKeyIdentifier;
        }

        public final void setSecureMessagingConfidentialityKeyIdentifier(String secureMessagingConfidentialityKeyIdentifier) {
            this.secureMessagingConfidentialityKeyIdentifier = secureMessagingConfidentialityKeyIdentifier;
        }

        @Override
        public final Builder secureMessagingConfidentialityKeyIdentifier(String secureMessagingConfidentialityKeyIdentifier) {
            this.secureMessagingConfidentialityKeyIdentifier = secureMessagingConfidentialityKeyIdentifier;
            return this;
        }

        public final String getMessageData() {
            return messageData;
        }

        public final void setMessageData(String messageData) {
            this.messageData = messageData;
        }

        @Override
        public final Builder messageData(String messageData) {
            this.messageData = messageData;
            return this;
        }

        public final DerivationMethodAttributes.Builder getDerivationMethodAttributes() {
            return derivationMethodAttributes != null ? derivationMethodAttributes.toBuilder() : null;
        }

        public final void setDerivationMethodAttributes(DerivationMethodAttributes.BuilderImpl derivationMethodAttributes) {
            this.derivationMethodAttributes = derivationMethodAttributes != null ? derivationMethodAttributes.build() : null;
        }

        @Override
        public final Builder derivationMethodAttributes(DerivationMethodAttributes derivationMethodAttributes) {
            this.derivationMethodAttributes = derivationMethodAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateMacEmvPinChangeRequest build() {
            return new GenerateMacEmvPinChangeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
