/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are required to perform encryption and decryption operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionDecryptionAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionDecryptionAttributes.Builder, EncryptionDecryptionAttributes> {
    private static final SdkField<SymmetricEncryptionAttributes> SYMMETRIC_FIELD = SdkField
            .<SymmetricEncryptionAttributes> builder(MarshallingType.SDK_POJO).memberName("Symmetric")
            .getter(getter(EncryptionDecryptionAttributes::symmetric)).setter(setter(Builder::symmetric))
            .constructor(SymmetricEncryptionAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Symmetric").build()).build();

    private static final SdkField<AsymmetricEncryptionAttributes> ASYMMETRIC_FIELD = SdkField
            .<AsymmetricEncryptionAttributes> builder(MarshallingType.SDK_POJO).memberName("Asymmetric")
            .getter(getter(EncryptionDecryptionAttributes::asymmetric)).setter(setter(Builder::asymmetric))
            .constructor(AsymmetricEncryptionAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Asymmetric").build()).build();

    private static final SdkField<DukptEncryptionAttributes> DUKPT_FIELD = SdkField
            .<DukptEncryptionAttributes> builder(MarshallingType.SDK_POJO).memberName("Dukpt")
            .getter(getter(EncryptionDecryptionAttributes::dukpt)).setter(setter(Builder::dukpt))
            .constructor(DukptEncryptionAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dukpt").build()).build();

    private static final SdkField<EmvEncryptionAttributes> EMV_FIELD = SdkField
            .<EmvEncryptionAttributes> builder(MarshallingType.SDK_POJO).memberName("Emv")
            .getter(getter(EncryptionDecryptionAttributes::emv)).setter(setter(Builder::emv))
            .constructor(EmvEncryptionAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Emv").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYMMETRIC_FIELD,
            ASYMMETRIC_FIELD, DUKPT_FIELD, EMV_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SymmetricEncryptionAttributes symmetric;

    private final AsymmetricEncryptionAttributes asymmetric;

    private final DukptEncryptionAttributes dukpt;

    private final EmvEncryptionAttributes emv;

    private final Type type;

    private EncryptionDecryptionAttributes(BuilderImpl builder) {
        this.symmetric = builder.symmetric;
        this.asymmetric = builder.asymmetric;
        this.dukpt = builder.dukpt;
        this.emv = builder.emv;
        this.type = builder.type;
    }

    /**
     * <p>
     * Parameters that are required to perform encryption and decryption using symmetric keys.
     * </p>
     * 
     * @return Parameters that are required to perform encryption and decryption using symmetric keys.
     */
    public final SymmetricEncryptionAttributes symmetric() {
        return symmetric;
    }

    /**
     * Returns the value of the Asymmetric property for this object.
     * 
     * @return The value of the Asymmetric property for this object.
     */
    public final AsymmetricEncryptionAttributes asymmetric() {
        return asymmetric;
    }

    /**
     * Returns the value of the Dukpt property for this object.
     * 
     * @return The value of the Dukpt property for this object.
     */
    public final DukptEncryptionAttributes dukpt() {
        return dukpt;
    }

    /**
     * <p>
     * Parameters for plaintext encryption using EMV keys.
     * </p>
     * 
     * @return Parameters for plaintext encryption using EMV keys.
     */
    public final EmvEncryptionAttributes emv() {
        return emv;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(symmetric());
        hashCode = 31 * hashCode + Objects.hashCode(asymmetric());
        hashCode = 31 * hashCode + Objects.hashCode(dukpt());
        hashCode = 31 * hashCode + Objects.hashCode(emv());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionDecryptionAttributes)) {
            return false;
        }
        EncryptionDecryptionAttributes other = (EncryptionDecryptionAttributes) obj;
        return Objects.equals(symmetric(), other.symmetric()) && Objects.equals(asymmetric(), other.asymmetric())
                && Objects.equals(dukpt(), other.dukpt()) && Objects.equals(emv(), other.emv());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionDecryptionAttributes").add("Symmetric", symmetric()).add("Asymmetric", asymmetric())
                .add("Dukpt", dukpt()).add("Emv", emv()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Symmetric":
            return Optional.ofNullable(clazz.cast(symmetric()));
        case "Asymmetric":
            return Optional.ofNullable(clazz.cast(asymmetric()));
        case "Dukpt":
            return Optional.ofNullable(clazz.cast(dukpt()));
        case "Emv":
            return Optional.ofNullable(clazz.cast(emv()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #symmetric()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to perform encryption and decryption using symmetric keys.
     * </p>
     * 
     * @param symmetric
     *        Parameters that are required to perform encryption and decryption using symmetric keys.
     */
    public static EncryptionDecryptionAttributes fromSymmetric(SymmetricEncryptionAttributes symmetric) {
        return builder().symmetric(symmetric).build();
    }

    /**
     * Create an instance of this class with {@link #symmetric()} initialized to the given value.
     *
     * <p>
     * Parameters that are required to perform encryption and decryption using symmetric keys.
     * </p>
     * 
     * @param symmetric
     *        Parameters that are required to perform encryption and decryption using symmetric keys.
     */
    public static EncryptionDecryptionAttributes fromSymmetric(Consumer<SymmetricEncryptionAttributes.Builder> symmetric) {
        SymmetricEncryptionAttributes.Builder builder = SymmetricEncryptionAttributes.builder();
        symmetric.accept(builder);
        return fromSymmetric(builder.build());
    }

    /**
     * Create an instance of this class with {@link #asymmetric()} initialized to the given value.
     *
     * Sets the value of the Asymmetric property for this object.
     *
     * @param asymmetric
     *        The new value for the Asymmetric property for this object.
     */
    public static EncryptionDecryptionAttributes fromAsymmetric(AsymmetricEncryptionAttributes asymmetric) {
        return builder().asymmetric(asymmetric).build();
    }

    /**
     * Create an instance of this class with {@link #asymmetric()} initialized to the given value.
     *
     * Sets the value of the Asymmetric property for this object.
     *
     * @param asymmetric
     *        The new value for the Asymmetric property for this object.
     */
    public static EncryptionDecryptionAttributes fromAsymmetric(Consumer<AsymmetricEncryptionAttributes.Builder> asymmetric) {
        AsymmetricEncryptionAttributes.Builder builder = AsymmetricEncryptionAttributes.builder();
        asymmetric.accept(builder);
        return fromAsymmetric(builder.build());
    }

    /**
     * Create an instance of this class with {@link #dukpt()} initialized to the given value.
     *
     * Sets the value of the Dukpt property for this object.
     *
     * @param dukpt
     *        The new value for the Dukpt property for this object.
     */
    public static EncryptionDecryptionAttributes fromDukpt(DukptEncryptionAttributes dukpt) {
        return builder().dukpt(dukpt).build();
    }

    /**
     * Create an instance of this class with {@link #dukpt()} initialized to the given value.
     *
     * Sets the value of the Dukpt property for this object.
     *
     * @param dukpt
     *        The new value for the Dukpt property for this object.
     */
    public static EncryptionDecryptionAttributes fromDukpt(Consumer<DukptEncryptionAttributes.Builder> dukpt) {
        DukptEncryptionAttributes.Builder builder = DukptEncryptionAttributes.builder();
        dukpt.accept(builder);
        return fromDukpt(builder.build());
    }

    /**
     * Create an instance of this class with {@link #emv()} initialized to the given value.
     *
     * <p>
     * Parameters for plaintext encryption using EMV keys.
     * </p>
     * 
     * @param emv
     *        Parameters for plaintext encryption using EMV keys.
     */
    public static EncryptionDecryptionAttributes fromEmv(EmvEncryptionAttributes emv) {
        return builder().emv(emv).build();
    }

    /**
     * Create an instance of this class with {@link #emv()} initialized to the given value.
     *
     * <p>
     * Parameters for plaintext encryption using EMV keys.
     * </p>
     * 
     * @param emv
     *        Parameters for plaintext encryption using EMV keys.
     */
    public static EncryptionDecryptionAttributes fromEmv(Consumer<EmvEncryptionAttributes.Builder> emv) {
        EmvEncryptionAttributes.Builder builder = EmvEncryptionAttributes.builder();
        emv.accept(builder);
        return fromEmv(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Symmetric", SYMMETRIC_FIELD);
        map.put("Asymmetric", ASYMMETRIC_FIELD);
        map.put("Dukpt", DUKPT_FIELD);
        map.put("Emv", EMV_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EncryptionDecryptionAttributes, T> g) {
        return obj -> g.apply((EncryptionDecryptionAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionDecryptionAttributes> {
        /**
         * <p>
         * Parameters that are required to perform encryption and decryption using symmetric keys.
         * </p>
         * 
         * @param symmetric
         *        Parameters that are required to perform encryption and decryption using symmetric keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder symmetric(SymmetricEncryptionAttributes symmetric);

        /**
         * <p>
         * Parameters that are required to perform encryption and decryption using symmetric keys.
         * </p>
         * This is a convenience method that creates an instance of the {@link SymmetricEncryptionAttributes.Builder}
         * avoiding the need to create one manually via {@link SymmetricEncryptionAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SymmetricEncryptionAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #symmetric(SymmetricEncryptionAttributes)}.
         * 
         * @param symmetric
         *        a consumer that will call methods on {@link SymmetricEncryptionAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #symmetric(SymmetricEncryptionAttributes)
         */
        default Builder symmetric(Consumer<SymmetricEncryptionAttributes.Builder> symmetric) {
            return symmetric(SymmetricEncryptionAttributes.builder().applyMutation(symmetric).build());
        }

        /**
         * Sets the value of the Asymmetric property for this object.
         *
         * @param asymmetric
         *        The new value for the Asymmetric property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asymmetric(AsymmetricEncryptionAttributes asymmetric);

        /**
         * Sets the value of the Asymmetric property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AsymmetricEncryptionAttributes.Builder}
         * avoiding the need to create one manually via {@link AsymmetricEncryptionAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AsymmetricEncryptionAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #asymmetric(AsymmetricEncryptionAttributes)}.
         * 
         * @param asymmetric
         *        a consumer that will call methods on {@link AsymmetricEncryptionAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #asymmetric(AsymmetricEncryptionAttributes)
         */
        default Builder asymmetric(Consumer<AsymmetricEncryptionAttributes.Builder> asymmetric) {
            return asymmetric(AsymmetricEncryptionAttributes.builder().applyMutation(asymmetric).build());
        }

        /**
         * Sets the value of the Dukpt property for this object.
         *
         * @param dukpt
         *        The new value for the Dukpt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dukpt(DukptEncryptionAttributes dukpt);

        /**
         * Sets the value of the Dukpt property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DukptEncryptionAttributes.Builder}
         * avoiding the need to create one manually via {@link DukptEncryptionAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DukptEncryptionAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #dukpt(DukptEncryptionAttributes)}.
         * 
         * @param dukpt
         *        a consumer that will call methods on {@link DukptEncryptionAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dukpt(DukptEncryptionAttributes)
         */
        default Builder dukpt(Consumer<DukptEncryptionAttributes.Builder> dukpt) {
            return dukpt(DukptEncryptionAttributes.builder().applyMutation(dukpt).build());
        }

        /**
         * <p>
         * Parameters for plaintext encryption using EMV keys.
         * </p>
         * 
         * @param emv
         *        Parameters for plaintext encryption using EMV keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emv(EmvEncryptionAttributes emv);

        /**
         * <p>
         * Parameters for plaintext encryption using EMV keys.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmvEncryptionAttributes.Builder} avoiding
         * the need to create one manually via {@link EmvEncryptionAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmvEncryptionAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #emv(EmvEncryptionAttributes)}.
         * 
         * @param emv
         *        a consumer that will call methods on {@link EmvEncryptionAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emv(EmvEncryptionAttributes)
         */
        default Builder emv(Consumer<EmvEncryptionAttributes.Builder> emv) {
            return emv(EmvEncryptionAttributes.builder().applyMutation(emv).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SymmetricEncryptionAttributes symmetric;

        private AsymmetricEncryptionAttributes asymmetric;

        private DukptEncryptionAttributes dukpt;

        private EmvEncryptionAttributes emv;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionDecryptionAttributes model) {
            symmetric(model.symmetric);
            asymmetric(model.asymmetric);
            dukpt(model.dukpt);
            emv(model.emv);
        }

        public final SymmetricEncryptionAttributes.Builder getSymmetric() {
            return symmetric != null ? symmetric.toBuilder() : null;
        }

        public final void setSymmetric(SymmetricEncryptionAttributes.BuilderImpl symmetric) {
            Object oldValue = this.symmetric;
            this.symmetric = symmetric != null ? symmetric.build() : null;
            handleUnionValueChange(Type.SYMMETRIC, oldValue, this.symmetric);
        }

        @Override
        public final Builder symmetric(SymmetricEncryptionAttributes symmetric) {
            Object oldValue = this.symmetric;
            this.symmetric = symmetric;
            handleUnionValueChange(Type.SYMMETRIC, oldValue, this.symmetric);
            return this;
        }

        public final AsymmetricEncryptionAttributes.Builder getAsymmetric() {
            return asymmetric != null ? asymmetric.toBuilder() : null;
        }

        public final void setAsymmetric(AsymmetricEncryptionAttributes.BuilderImpl asymmetric) {
            Object oldValue = this.asymmetric;
            this.asymmetric = asymmetric != null ? asymmetric.build() : null;
            handleUnionValueChange(Type.ASYMMETRIC, oldValue, this.asymmetric);
        }

        @Override
        public final Builder asymmetric(AsymmetricEncryptionAttributes asymmetric) {
            Object oldValue = this.asymmetric;
            this.asymmetric = asymmetric;
            handleUnionValueChange(Type.ASYMMETRIC, oldValue, this.asymmetric);
            return this;
        }

        public final DukptEncryptionAttributes.Builder getDukpt() {
            return dukpt != null ? dukpt.toBuilder() : null;
        }

        public final void setDukpt(DukptEncryptionAttributes.BuilderImpl dukpt) {
            Object oldValue = this.dukpt;
            this.dukpt = dukpt != null ? dukpt.build() : null;
            handleUnionValueChange(Type.DUKPT, oldValue, this.dukpt);
        }

        @Override
        public final Builder dukpt(DukptEncryptionAttributes dukpt) {
            Object oldValue = this.dukpt;
            this.dukpt = dukpt;
            handleUnionValueChange(Type.DUKPT, oldValue, this.dukpt);
            return this;
        }

        public final EmvEncryptionAttributes.Builder getEmv() {
            return emv != null ? emv.toBuilder() : null;
        }

        public final void setEmv(EmvEncryptionAttributes.BuilderImpl emv) {
            Object oldValue = this.emv;
            this.emv = emv != null ? emv.build() : null;
            handleUnionValueChange(Type.EMV, oldValue, this.emv);
        }

        @Override
        public final Builder emv(EmvEncryptionAttributes emv) {
            Object oldValue = this.emv;
            this.emv = emv;
            handleUnionValueChange(Type.EMV, oldValue, this.emv);
            return this;
        }

        @Override
        public EncryptionDecryptionAttributes build() {
            return new EncryptionDecryptionAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EncryptionDecryptionAttributes#type()
     */
    public enum Type {
        SYMMETRIC,

        ASYMMETRIC,

        DUKPT,

        EMV,

        UNKNOWN_TO_SDK_VERSION
    }
}
