/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters to derive the confidentiality and integrity keys for an Emv common payment card.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmvCommonAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<EmvCommonAttributes.Builder, EmvCommonAttributes> {
    private static final SdkField<String> MAJOR_KEY_DERIVATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MajorKeyDerivationMode").getter(getter(EmvCommonAttributes::majorKeyDerivationModeAsString))
            .setter(setter(Builder::majorKeyDerivationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorKeyDerivationMode").build())
            .build();

    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryAccountNumber").getter(getter(EmvCommonAttributes::primaryAccountNumber))
            .setter(setter(Builder::primaryAccountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build())
            .build();

    private static final SdkField<String> PAN_SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PanSequenceNumber").getter(getter(EmvCommonAttributes::panSequenceNumber))
            .setter(setter(Builder::panSequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PanSequenceNumber").build()).build();

    private static final SdkField<String> APPLICATION_CRYPTOGRAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationCryptogram").getter(getter(EmvCommonAttributes::applicationCryptogram))
            .setter(setter(Builder::applicationCryptogram))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCryptogram").build())
            .build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(EmvCommonAttributes::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> PIN_BLOCK_PADDING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PinBlockPaddingType").getter(getter(EmvCommonAttributes::pinBlockPaddingTypeAsString))
            .setter(setter(Builder::pinBlockPaddingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinBlockPaddingType").build())
            .build();

    private static final SdkField<String> PIN_BLOCK_LENGTH_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PinBlockLengthPosition").getter(getter(EmvCommonAttributes::pinBlockLengthPositionAsString))
            .setter(setter(Builder::pinBlockLengthPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinBlockLengthPosition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAJOR_KEY_DERIVATION_MODE_FIELD, PRIMARY_ACCOUNT_NUMBER_FIELD, PAN_SEQUENCE_NUMBER_FIELD,
            APPLICATION_CRYPTOGRAM_FIELD, MODE_FIELD, PIN_BLOCK_PADDING_TYPE_FIELD, PIN_BLOCK_LENGTH_POSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String majorKeyDerivationMode;

    private final String primaryAccountNumber;

    private final String panSequenceNumber;

    private final String applicationCryptogram;

    private final String mode;

    private final String pinBlockPaddingType;

    private final String pinBlockLengthPosition;

    private EmvCommonAttributes(BuilderImpl builder) {
        this.majorKeyDerivationMode = builder.majorKeyDerivationMode;
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.panSequenceNumber = builder.panSequenceNumber;
        this.applicationCryptogram = builder.applicationCryptogram;
        this.mode = builder.mode;
        this.pinBlockPaddingType = builder.pinBlockPaddingType;
        this.pinBlockLengthPosition = builder.pinBlockLengthPosition;
    }

    /**
     * <p>
     * The method to use when deriving the master key for the payment card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #majorKeyDerivationMode} will return {@link MajorKeyDerivationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #majorKeyDerivationModeAsString}.
     * </p>
     * 
     * @return The method to use when deriving the master key for the payment card.
     * @see MajorKeyDerivationMode
     */
    public final MajorKeyDerivationMode majorKeyDerivationMode() {
        return MajorKeyDerivationMode.fromValue(majorKeyDerivationMode);
    }

    /**
     * <p>
     * The method to use when deriving the master key for the payment card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #majorKeyDerivationMode} will return {@link MajorKeyDerivationMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #majorKeyDerivationModeAsString}.
     * </p>
     * 
     * @return The method to use when deriving the master key for the payment card.
     * @see MajorKeyDerivationMode
     */
    public final String majorKeyDerivationModeAsString() {
        return majorKeyDerivationMode;
    }

    /**
     * <p>
     * The Primary Account Number (PAN) of the cardholder.
     * </p>
     * 
     * @return The Primary Account Number (PAN) of the cardholder.
     */
    public final String primaryAccountNumber() {
        return primaryAccountNumber;
    }

    /**
     * <p>
     * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN). Typically
     * 00 is used, if no value is provided by the terminal.
     * </p>
     * 
     * @return A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     *         Typically 00 is used, if no value is provided by the terminal.
     */
    public final String panSequenceNumber() {
        return panSequenceNumber;
    }

    /**
     * <p>
     * The application cryptogram for the current transaction that is provided by the terminal during transaction
     * processing.
     * </p>
     * 
     * @return The application cryptogram for the current transaction that is provided by the terminal during
     *         transaction processing.
     */
    public final String applicationCryptogram() {
        return applicationCryptogram;
    }

    /**
     * <p>
     * The block cipher method to use for encryption.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link EmvEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The block cipher method to use for encryption.
     * @see EmvEncryptionMode
     */
    public final EmvEncryptionMode mode() {
        return EmvEncryptionMode.fromValue(mode);
    }

    /**
     * <p>
     * The block cipher method to use for encryption.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link EmvEncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The block cipher method to use for encryption.
     * @see EmvEncryptionMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The padding to be added to the PIN block prior to encryption.
     * </p>
     * <p>
     * Padding type should be <code>ISO_IEC_7816_4</code>, if <code>PinBlockLengthPosition</code> is set to
     * <code>FRONT_OF_PIN_BLOCK</code>. No padding is required, if <code>PinBlockLengthPosition</code> is set to
     * <code>NONE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pinBlockPaddingType} will return {@link PinBlockPaddingType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #pinBlockPaddingTypeAsString}.
     * </p>
     * 
     * @return The padding to be added to the PIN block prior to encryption.</p>
     *         <p>
     *         Padding type should be <code>ISO_IEC_7816_4</code>, if <code>PinBlockLengthPosition</code> is set to
     *         <code>FRONT_OF_PIN_BLOCK</code>. No padding is required, if <code>PinBlockLengthPosition</code> is set to
     *         <code>NONE</code>.
     * @see PinBlockPaddingType
     */
    public final PinBlockPaddingType pinBlockPaddingType() {
        return PinBlockPaddingType.fromValue(pinBlockPaddingType);
    }

    /**
     * <p>
     * The padding to be added to the PIN block prior to encryption.
     * </p>
     * <p>
     * Padding type should be <code>ISO_IEC_7816_4</code>, if <code>PinBlockLengthPosition</code> is set to
     * <code>FRONT_OF_PIN_BLOCK</code>. No padding is required, if <code>PinBlockLengthPosition</code> is set to
     * <code>NONE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pinBlockPaddingType} will return {@link PinBlockPaddingType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #pinBlockPaddingTypeAsString}.
     * </p>
     * 
     * @return The padding to be added to the PIN block prior to encryption.</p>
     *         <p>
     *         Padding type should be <code>ISO_IEC_7816_4</code>, if <code>PinBlockLengthPosition</code> is set to
     *         <code>FRONT_OF_PIN_BLOCK</code>. No padding is required, if <code>PinBlockLengthPosition</code> is set to
     *         <code>NONE</code>.
     * @see PinBlockPaddingType
     */
    public final String pinBlockPaddingTypeAsString() {
        return pinBlockPaddingType;
    }

    /**
     * <p>
     * Specifies if PIN block length should be added to front of the pin block.
     * </p>
     * <p>
     * If value is set to <code>FRONT_OF_PIN_BLOCK</code>, then PIN block padding type should be
     * <code>ISO_IEC_7816_4</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pinBlockLengthPosition} will return {@link PinBlockLengthPosition#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #pinBlockLengthPositionAsString}.
     * </p>
     * 
     * @return Specifies if PIN block length should be added to front of the pin block. </p>
     *         <p>
     *         If value is set to <code>FRONT_OF_PIN_BLOCK</code>, then PIN block padding type should be
     *         <code>ISO_IEC_7816_4</code>.
     * @see PinBlockLengthPosition
     */
    public final PinBlockLengthPosition pinBlockLengthPosition() {
        return PinBlockLengthPosition.fromValue(pinBlockLengthPosition);
    }

    /**
     * <p>
     * Specifies if PIN block length should be added to front of the pin block.
     * </p>
     * <p>
     * If value is set to <code>FRONT_OF_PIN_BLOCK</code>, then PIN block padding type should be
     * <code>ISO_IEC_7816_4</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pinBlockLengthPosition} will return {@link PinBlockLengthPosition#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #pinBlockLengthPositionAsString}.
     * </p>
     * 
     * @return Specifies if PIN block length should be added to front of the pin block. </p>
     *         <p>
     *         If value is set to <code>FRONT_OF_PIN_BLOCK</code>, then PIN block padding type should be
     *         <code>ISO_IEC_7816_4</code>.
     * @see PinBlockLengthPosition
     */
    public final String pinBlockLengthPositionAsString() {
        return pinBlockLengthPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(majorKeyDerivationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(panSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(applicationCryptogram());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pinBlockPaddingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pinBlockLengthPositionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmvCommonAttributes)) {
            return false;
        }
        EmvCommonAttributes other = (EmvCommonAttributes) obj;
        return Objects.equals(majorKeyDerivationModeAsString(), other.majorKeyDerivationModeAsString())
                && Objects.equals(primaryAccountNumber(), other.primaryAccountNumber())
                && Objects.equals(panSequenceNumber(), other.panSequenceNumber())
                && Objects.equals(applicationCryptogram(), other.applicationCryptogram())
                && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(pinBlockPaddingTypeAsString(), other.pinBlockPaddingTypeAsString())
                && Objects.equals(pinBlockLengthPositionAsString(), other.pinBlockLengthPositionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmvCommonAttributes").add("MajorKeyDerivationMode", majorKeyDerivationModeAsString())
                .add("PrimaryAccountNumber", primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PanSequenceNumber", panSequenceNumber())
                .add("ApplicationCryptogram", applicationCryptogram() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Mode", modeAsString()).add("PinBlockPaddingType", pinBlockPaddingTypeAsString())
                .add("PinBlockLengthPosition", pinBlockLengthPositionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MajorKeyDerivationMode":
            return Optional.ofNullable(clazz.cast(majorKeyDerivationModeAsString()));
        case "PrimaryAccountNumber":
            return Optional.ofNullable(clazz.cast(primaryAccountNumber()));
        case "PanSequenceNumber":
            return Optional.ofNullable(clazz.cast(panSequenceNumber()));
        case "ApplicationCryptogram":
            return Optional.ofNullable(clazz.cast(applicationCryptogram()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "PinBlockPaddingType":
            return Optional.ofNullable(clazz.cast(pinBlockPaddingTypeAsString()));
        case "PinBlockLengthPosition":
            return Optional.ofNullable(clazz.cast(pinBlockLengthPositionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MajorKeyDerivationMode", MAJOR_KEY_DERIVATION_MODE_FIELD);
        map.put("PrimaryAccountNumber", PRIMARY_ACCOUNT_NUMBER_FIELD);
        map.put("PanSequenceNumber", PAN_SEQUENCE_NUMBER_FIELD);
        map.put("ApplicationCryptogram", APPLICATION_CRYPTOGRAM_FIELD);
        map.put("Mode", MODE_FIELD);
        map.put("PinBlockPaddingType", PIN_BLOCK_PADDING_TYPE_FIELD);
        map.put("PinBlockLengthPosition", PIN_BLOCK_LENGTH_POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmvCommonAttributes, T> g) {
        return obj -> g.apply((EmvCommonAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmvCommonAttributes> {
        /**
         * <p>
         * The method to use when deriving the master key for the payment card.
         * </p>
         * 
         * @param majorKeyDerivationMode
         *        The method to use when deriving the master key for the payment card.
         * @see MajorKeyDerivationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MajorKeyDerivationMode
         */
        Builder majorKeyDerivationMode(String majorKeyDerivationMode);

        /**
         * <p>
         * The method to use when deriving the master key for the payment card.
         * </p>
         * 
         * @param majorKeyDerivationMode
         *        The method to use when deriving the master key for the payment card.
         * @see MajorKeyDerivationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MajorKeyDerivationMode
         */
        Builder majorKeyDerivationMode(MajorKeyDerivationMode majorKeyDerivationMode);

        /**
         * <p>
         * The Primary Account Number (PAN) of the cardholder.
         * </p>
         * 
         * @param primaryAccountNumber
         *        The Primary Account Number (PAN) of the cardholder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryAccountNumber(String primaryAccountNumber);

        /**
         * <p>
         * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         * Typically 00 is used, if no value is provided by the terminal.
         * </p>
         * 
         * @param panSequenceNumber
         *        A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         *        Typically 00 is used, if no value is provided by the terminal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder panSequenceNumber(String panSequenceNumber);

        /**
         * <p>
         * The application cryptogram for the current transaction that is provided by the terminal during transaction
         * processing.
         * </p>
         * 
         * @param applicationCryptogram
         *        The application cryptogram for the current transaction that is provided by the terminal during
         *        transaction processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationCryptogram(String applicationCryptogram);

        /**
         * <p>
         * The block cipher method to use for encryption.
         * </p>
         * 
         * @param mode
         *        The block cipher method to use for encryption.
         * @see EmvEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmvEncryptionMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The block cipher method to use for encryption.
         * </p>
         * 
         * @param mode
         *        The block cipher method to use for encryption.
         * @see EmvEncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmvEncryptionMode
         */
        Builder mode(EmvEncryptionMode mode);

        /**
         * <p>
         * The padding to be added to the PIN block prior to encryption.
         * </p>
         * <p>
         * Padding type should be <code>ISO_IEC_7816_4</code>, if <code>PinBlockLengthPosition</code> is set to
         * <code>FRONT_OF_PIN_BLOCK</code>. No padding is required, if <code>PinBlockLengthPosition</code> is set to
         * <code>NONE</code>.
         * </p>
         * 
         * @param pinBlockPaddingType
         *        The padding to be added to the PIN block prior to encryption.</p>
         *        <p>
         *        Padding type should be <code>ISO_IEC_7816_4</code>, if <code>PinBlockLengthPosition</code> is set to
         *        <code>FRONT_OF_PIN_BLOCK</code>. No padding is required, if <code>PinBlockLengthPosition</code> is set
         *        to <code>NONE</code>.
         * @see PinBlockPaddingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PinBlockPaddingType
         */
        Builder pinBlockPaddingType(String pinBlockPaddingType);

        /**
         * <p>
         * The padding to be added to the PIN block prior to encryption.
         * </p>
         * <p>
         * Padding type should be <code>ISO_IEC_7816_4</code>, if <code>PinBlockLengthPosition</code> is set to
         * <code>FRONT_OF_PIN_BLOCK</code>. No padding is required, if <code>PinBlockLengthPosition</code> is set to
         * <code>NONE</code>.
         * </p>
         * 
         * @param pinBlockPaddingType
         *        The padding to be added to the PIN block prior to encryption.</p>
         *        <p>
         *        Padding type should be <code>ISO_IEC_7816_4</code>, if <code>PinBlockLengthPosition</code> is set to
         *        <code>FRONT_OF_PIN_BLOCK</code>. No padding is required, if <code>PinBlockLengthPosition</code> is set
         *        to <code>NONE</code>.
         * @see PinBlockPaddingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PinBlockPaddingType
         */
        Builder pinBlockPaddingType(PinBlockPaddingType pinBlockPaddingType);

        /**
         * <p>
         * Specifies if PIN block length should be added to front of the pin block.
         * </p>
         * <p>
         * If value is set to <code>FRONT_OF_PIN_BLOCK</code>, then PIN block padding type should be
         * <code>ISO_IEC_7816_4</code>.
         * </p>
         * 
         * @param pinBlockLengthPosition
         *        Specifies if PIN block length should be added to front of the pin block. </p>
         *        <p>
         *        If value is set to <code>FRONT_OF_PIN_BLOCK</code>, then PIN block padding type should be
         *        <code>ISO_IEC_7816_4</code>.
         * @see PinBlockLengthPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PinBlockLengthPosition
         */
        Builder pinBlockLengthPosition(String pinBlockLengthPosition);

        /**
         * <p>
         * Specifies if PIN block length should be added to front of the pin block.
         * </p>
         * <p>
         * If value is set to <code>FRONT_OF_PIN_BLOCK</code>, then PIN block padding type should be
         * <code>ISO_IEC_7816_4</code>.
         * </p>
         * 
         * @param pinBlockLengthPosition
         *        Specifies if PIN block length should be added to front of the pin block. </p>
         *        <p>
         *        If value is set to <code>FRONT_OF_PIN_BLOCK</code>, then PIN block padding type should be
         *        <code>ISO_IEC_7816_4</code>.
         * @see PinBlockLengthPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PinBlockLengthPosition
         */
        Builder pinBlockLengthPosition(PinBlockLengthPosition pinBlockLengthPosition);
    }

    static final class BuilderImpl implements Builder {
        private String majorKeyDerivationMode;

        private String primaryAccountNumber;

        private String panSequenceNumber;

        private String applicationCryptogram;

        private String mode;

        private String pinBlockPaddingType;

        private String pinBlockLengthPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(EmvCommonAttributes model) {
            majorKeyDerivationMode(model.majorKeyDerivationMode);
            primaryAccountNumber(model.primaryAccountNumber);
            panSequenceNumber(model.panSequenceNumber);
            applicationCryptogram(model.applicationCryptogram);
            mode(model.mode);
            pinBlockPaddingType(model.pinBlockPaddingType);
            pinBlockLengthPosition(model.pinBlockLengthPosition);
        }

        public final String getMajorKeyDerivationMode() {
            return majorKeyDerivationMode;
        }

        public final void setMajorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
        }

        @Override
        public final Builder majorKeyDerivationMode(String majorKeyDerivationMode) {
            this.majorKeyDerivationMode = majorKeyDerivationMode;
            return this;
        }

        @Override
        public final Builder majorKeyDerivationMode(MajorKeyDerivationMode majorKeyDerivationMode) {
            this.majorKeyDerivationMode(majorKeyDerivationMode == null ? null : majorKeyDerivationMode.toString());
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final String getPanSequenceNumber() {
            return panSequenceNumber;
        }

        public final void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        @Override
        public final Builder panSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
            return this;
        }

        public final String getApplicationCryptogram() {
            return applicationCryptogram;
        }

        public final void setApplicationCryptogram(String applicationCryptogram) {
            this.applicationCryptogram = applicationCryptogram;
        }

        @Override
        public final Builder applicationCryptogram(String applicationCryptogram) {
            this.applicationCryptogram = applicationCryptogram;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(EmvEncryptionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getPinBlockPaddingType() {
            return pinBlockPaddingType;
        }

        public final void setPinBlockPaddingType(String pinBlockPaddingType) {
            this.pinBlockPaddingType = pinBlockPaddingType;
        }

        @Override
        public final Builder pinBlockPaddingType(String pinBlockPaddingType) {
            this.pinBlockPaddingType = pinBlockPaddingType;
            return this;
        }

        @Override
        public final Builder pinBlockPaddingType(PinBlockPaddingType pinBlockPaddingType) {
            this.pinBlockPaddingType(pinBlockPaddingType == null ? null : pinBlockPaddingType.toString());
            return this;
        }

        public final String getPinBlockLengthPosition() {
            return pinBlockLengthPosition;
        }

        public final void setPinBlockLengthPosition(String pinBlockLengthPosition) {
            this.pinBlockLengthPosition = pinBlockLengthPosition;
        }

        @Override
        public final Builder pinBlockLengthPosition(String pinBlockLengthPosition) {
            this.pinBlockLengthPosition = pinBlockLengthPosition;
            return this;
        }

        @Override
        public final Builder pinBlockLengthPosition(PinBlockLengthPosition pinBlockLengthPosition) {
            this.pinBlockLengthPosition(pinBlockLengthPosition == null ? null : pinBlockLengthPosition.toString());
            return this;
        }

        @Override
        public EmvCommonAttributes build() {
            return new EmvCommonAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
