/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DukptKeyVariant {
    BIDIRECTIONAL("BIDIRECTIONAL"),
    REQUEST("REQUEST"),
    RESPONSE("RESPONSE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DukptKeyVariant> VALUE_MAP;
    private final String value;

    private DukptKeyVariant(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DukptKeyVariant fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DukptKeyVariant> knownValues() {
        EnumSet<DukptKeyVariant> knownValues = EnumSet.allOf(DukptKeyVariant.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DukptKeyVariant.class, DukptKeyVariant::toString);
    }
}

