/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaymentCryptographyDataRequest;
import software.amazon.awssdk.services.paymentcryptographydata.model.PinBlockFormatForPinData;
import software.amazon.awssdk.services.paymentcryptographydata.model.PinGenerationAttributes;
import software.amazon.awssdk.services.paymentcryptographydata.model.WrappedKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeneratePinDataRequest
extends PaymentCryptographyDataRequest
implements ToCopyableBuilder<Builder, GeneratePinDataRequest> {
    private static final SdkField<String> GENERATION_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GenerationKeyIdentifier").getter(GeneratePinDataRequest.getter(GeneratePinDataRequest::generationKeyIdentifier)).setter(GeneratePinDataRequest.setter(Builder::generationKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationKeyIdentifier").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyIdentifier").getter(GeneratePinDataRequest.getter(GeneratePinDataRequest::encryptionKeyIdentifier)).setter(GeneratePinDataRequest.setter(Builder::encryptionKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyIdentifier").build()}).build();
    private static final SdkField<PinGenerationAttributes> GENERATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GenerationAttributes").getter(GeneratePinDataRequest.getter(GeneratePinDataRequest::generationAttributes)).setter(GeneratePinDataRequest.setter(Builder::generationAttributes)).constructor(PinGenerationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationAttributes").build()}).build();
    private static final SdkField<Integer> PIN_DATA_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PinDataLength").getter(GeneratePinDataRequest.getter(GeneratePinDataRequest::pinDataLength)).setter(GeneratePinDataRequest.setter(Builder::pinDataLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinDataLength").build()}).build();
    private static final SdkField<String> PRIMARY_ACCOUNT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryAccountNumber").getter(GeneratePinDataRequest.getter(GeneratePinDataRequest::primaryAccountNumber)).setter(GeneratePinDataRequest.setter(Builder::primaryAccountNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountNumber").build()}).build();
    private static final SdkField<String> PIN_BLOCK_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PinBlockFormat").getter(GeneratePinDataRequest.getter(GeneratePinDataRequest::pinBlockFormatAsString)).setter(GeneratePinDataRequest.setter(Builder::pinBlockFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinBlockFormat").build()}).build();
    private static final SdkField<WrappedKey> ENCRYPTION_WRAPPED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionWrappedKey").getter(GeneratePinDataRequest.getter(GeneratePinDataRequest::encryptionWrappedKey)).setter(GeneratePinDataRequest.setter(Builder::encryptionWrappedKey)).constructor(WrappedKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionWrappedKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATION_KEY_IDENTIFIER_FIELD, ENCRYPTION_KEY_IDENTIFIER_FIELD, GENERATION_ATTRIBUTES_FIELD, PIN_DATA_LENGTH_FIELD, PRIMARY_ACCOUNT_NUMBER_FIELD, PIN_BLOCK_FORMAT_FIELD, ENCRYPTION_WRAPPED_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GenerationKeyIdentifier", GENERATION_KEY_IDENTIFIER_FIELD);
            this.put("EncryptionKeyIdentifier", ENCRYPTION_KEY_IDENTIFIER_FIELD);
            this.put("GenerationAttributes", GENERATION_ATTRIBUTES_FIELD);
            this.put("PinDataLength", PIN_DATA_LENGTH_FIELD);
            this.put("PrimaryAccountNumber", PRIMARY_ACCOUNT_NUMBER_FIELD);
            this.put("PinBlockFormat", PIN_BLOCK_FORMAT_FIELD);
            this.put("EncryptionWrappedKey", ENCRYPTION_WRAPPED_KEY_FIELD);
        }
    });
    private final String generationKeyIdentifier;
    private final String encryptionKeyIdentifier;
    private final PinGenerationAttributes generationAttributes;
    private final Integer pinDataLength;
    private final String primaryAccountNumber;
    private final String pinBlockFormat;
    private final WrappedKey encryptionWrappedKey;

    private GeneratePinDataRequest(BuilderImpl builder) {
        super(builder);
        this.generationKeyIdentifier = builder.generationKeyIdentifier;
        this.encryptionKeyIdentifier = builder.encryptionKeyIdentifier;
        this.generationAttributes = builder.generationAttributes;
        this.pinDataLength = builder.pinDataLength;
        this.primaryAccountNumber = builder.primaryAccountNumber;
        this.pinBlockFormat = builder.pinBlockFormat;
        this.encryptionWrappedKey = builder.encryptionWrappedKey;
    }

    public final String generationKeyIdentifier() {
        return this.generationKeyIdentifier;
    }

    public final String encryptionKeyIdentifier() {
        return this.encryptionKeyIdentifier;
    }

    public final PinGenerationAttributes generationAttributes() {
        return this.generationAttributes;
    }

    public final Integer pinDataLength() {
        return this.pinDataLength;
    }

    public final String primaryAccountNumber() {
        return this.primaryAccountNumber;
    }

    public final PinBlockFormatForPinData pinBlockFormat() {
        return PinBlockFormatForPinData.fromValue(this.pinBlockFormat);
    }

    public final String pinBlockFormatAsString() {
        return this.pinBlockFormat;
    }

    public final WrappedKey encryptionWrappedKey() {
        return this.encryptionWrappedKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.generationKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.pinDataLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.pinBlockFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionWrappedKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratePinDataRequest)) {
            return false;
        }
        GeneratePinDataRequest other = (GeneratePinDataRequest)((Object)obj);
        return Objects.equals(this.generationKeyIdentifier(), other.generationKeyIdentifier()) && Objects.equals(this.encryptionKeyIdentifier(), other.encryptionKeyIdentifier()) && Objects.equals(this.generationAttributes(), other.generationAttributes()) && Objects.equals(this.pinDataLength(), other.pinDataLength()) && Objects.equals(this.primaryAccountNumber(), other.primaryAccountNumber()) && Objects.equals(this.pinBlockFormatAsString(), other.pinBlockFormatAsString()) && Objects.equals(this.encryptionWrappedKey(), other.encryptionWrappedKey());
    }

    public final String toString() {
        return ToString.builder((String)"GeneratePinDataRequest").add("GenerationKeyIdentifier", (Object)this.generationKeyIdentifier()).add("EncryptionKeyIdentifier", (Object)this.encryptionKeyIdentifier()).add("GenerationAttributes", (Object)this.generationAttributes()).add("PinDataLength", (Object)this.pinDataLength()).add("PrimaryAccountNumber", (Object)(this.primaryAccountNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("PinBlockFormat", (Object)this.pinBlockFormatAsString()).add("EncryptionWrappedKey", (Object)this.encryptionWrappedKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GenerationKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.generationKeyIdentifier()));
            }
            case "EncryptionKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyIdentifier()));
            }
            case "GenerationAttributes": {
                return Optional.ofNullable(clazz.cast(this.generationAttributes()));
            }
            case "PinDataLength": {
                return Optional.ofNullable(clazz.cast(this.pinDataLength()));
            }
            case "PrimaryAccountNumber": {
                return Optional.ofNullable(clazz.cast(this.primaryAccountNumber()));
            }
            case "PinBlockFormat": {
                return Optional.ofNullable(clazz.cast(this.pinBlockFormatAsString()));
            }
            case "EncryptionWrappedKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionWrappedKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GeneratePinDataRequest, T> g) {
        return obj -> g.apply((GeneratePinDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyDataRequest.BuilderImpl
    implements Builder {
        private String generationKeyIdentifier;
        private String encryptionKeyIdentifier;
        private PinGenerationAttributes generationAttributes;
        private Integer pinDataLength;
        private String primaryAccountNumber;
        private String pinBlockFormat;
        private WrappedKey encryptionWrappedKey;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratePinDataRequest model) {
            super(model);
            this.generationKeyIdentifier(model.generationKeyIdentifier);
            this.encryptionKeyIdentifier(model.encryptionKeyIdentifier);
            this.generationAttributes(model.generationAttributes);
            this.pinDataLength(model.pinDataLength);
            this.primaryAccountNumber(model.primaryAccountNumber);
            this.pinBlockFormat(model.pinBlockFormat);
            this.encryptionWrappedKey(model.encryptionWrappedKey);
        }

        public final String getGenerationKeyIdentifier() {
            return this.generationKeyIdentifier;
        }

        public final void setGenerationKeyIdentifier(String generationKeyIdentifier) {
            this.generationKeyIdentifier = generationKeyIdentifier;
        }

        @Override
        public final Builder generationKeyIdentifier(String generationKeyIdentifier) {
            this.generationKeyIdentifier = generationKeyIdentifier;
            return this;
        }

        public final String getEncryptionKeyIdentifier() {
            return this.encryptionKeyIdentifier;
        }

        public final void setEncryptionKeyIdentifier(String encryptionKeyIdentifier) {
            this.encryptionKeyIdentifier = encryptionKeyIdentifier;
        }

        @Override
        public final Builder encryptionKeyIdentifier(String encryptionKeyIdentifier) {
            this.encryptionKeyIdentifier = encryptionKeyIdentifier;
            return this;
        }

        public final PinGenerationAttributes.Builder getGenerationAttributes() {
            return this.generationAttributes != null ? this.generationAttributes.toBuilder() : null;
        }

        public final void setGenerationAttributes(PinGenerationAttributes.BuilderImpl generationAttributes) {
            this.generationAttributes = generationAttributes != null ? generationAttributes.build() : null;
        }

        @Override
        public final Builder generationAttributes(PinGenerationAttributes generationAttributes) {
            this.generationAttributes = generationAttributes;
            return this;
        }

        public final Integer getPinDataLength() {
            return this.pinDataLength;
        }

        public final void setPinDataLength(Integer pinDataLength) {
            this.pinDataLength = pinDataLength;
        }

        @Override
        public final Builder pinDataLength(Integer pinDataLength) {
            this.pinDataLength = pinDataLength;
            return this;
        }

        public final String getPrimaryAccountNumber() {
            return this.primaryAccountNumber;
        }

        public final void setPrimaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
        }

        @Override
        public final Builder primaryAccountNumber(String primaryAccountNumber) {
            this.primaryAccountNumber = primaryAccountNumber;
            return this;
        }

        public final String getPinBlockFormat() {
            return this.pinBlockFormat;
        }

        public final void setPinBlockFormat(String pinBlockFormat) {
            this.pinBlockFormat = pinBlockFormat;
        }

        @Override
        public final Builder pinBlockFormat(String pinBlockFormat) {
            this.pinBlockFormat = pinBlockFormat;
            return this;
        }

        @Override
        public final Builder pinBlockFormat(PinBlockFormatForPinData pinBlockFormat) {
            this.pinBlockFormat(pinBlockFormat == null ? null : pinBlockFormat.toString());
            return this;
        }

        public final WrappedKey.Builder getEncryptionWrappedKey() {
            return this.encryptionWrappedKey != null ? this.encryptionWrappedKey.toBuilder() : null;
        }

        public final void setEncryptionWrappedKey(WrappedKey.BuilderImpl encryptionWrappedKey) {
            this.encryptionWrappedKey = encryptionWrappedKey != null ? encryptionWrappedKey.build() : null;
        }

        @Override
        public final Builder encryptionWrappedKey(WrappedKey encryptionWrappedKey) {
            this.encryptionWrappedKey = encryptionWrappedKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GeneratePinDataRequest build() {
            return new GeneratePinDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PaymentCryptographyDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GeneratePinDataRequest> {
        public Builder generationKeyIdentifier(String var1);

        public Builder encryptionKeyIdentifier(String var1);

        public Builder generationAttributes(PinGenerationAttributes var1);

        default public Builder generationAttributes(Consumer<PinGenerationAttributes.Builder> generationAttributes) {
            return this.generationAttributes((PinGenerationAttributes)((PinGenerationAttributes.Builder)PinGenerationAttributes.builder().applyMutation(generationAttributes)).build());
        }

        public Builder pinDataLength(Integer var1);

        public Builder primaryAccountNumber(String var1);

        public Builder pinBlockFormat(String var1);

        public Builder pinBlockFormat(PinBlockFormatForPinData var1);

        public Builder encryptionWrappedKey(WrappedKey var1);

        default public Builder encryptionWrappedKey(Consumer<WrappedKey.Builder> encryptionWrappedKey) {
            return this.encryptionWrappedKey((WrappedKey)((WrappedKey.Builder)WrappedKey.builder().applyMutation(encryptionWrappedKey)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

