/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptographydata.model.EncryptionMode;
import software.amazon.awssdk.services.paymentcryptographydata.model.PaddingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SymmetricEncryptionAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SymmetricEncryptionAttributes> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(SymmetricEncryptionAttributes.getter(SymmetricEncryptionAttributes::modeAsString)).setter(SymmetricEncryptionAttributes.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> INITIALIZATION_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitializationVector").getter(SymmetricEncryptionAttributes.getter(SymmetricEncryptionAttributes::initializationVector)).setter(SymmetricEncryptionAttributes.setter(Builder::initializationVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitializationVector").build()}).build();
    private static final SdkField<String> PADDING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaddingType").getter(SymmetricEncryptionAttributes.getter(SymmetricEncryptionAttributes::paddingTypeAsString)).setter(SymmetricEncryptionAttributes.setter(Builder::paddingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaddingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, INITIALIZATION_VECTOR_FIELD, PADDING_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final String initializationVector;
    private final String paddingType;

    private SymmetricEncryptionAttributes(BuilderImpl builder) {
        this.mode = builder.mode;
        this.initializationVector = builder.initializationVector;
        this.paddingType = builder.paddingType;
    }

    public final EncryptionMode mode() {
        return EncryptionMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final String initializationVector() {
        return this.initializationVector;
    }

    public final PaddingType paddingType() {
        return PaddingType.fromValue(this.paddingType);
    }

    public final String paddingTypeAsString() {
        return this.paddingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(this.paddingTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SymmetricEncryptionAttributes)) {
            return false;
        }
        SymmetricEncryptionAttributes other = (SymmetricEncryptionAttributes)obj;
        return Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.initializationVector(), other.initializationVector()) && Objects.equals(this.paddingTypeAsString(), other.paddingTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SymmetricEncryptionAttributes").add("Mode", (Object)this.modeAsString()).add("InitializationVector", (Object)(this.initializationVector() == null ? null : "*** Sensitive Data Redacted ***")).add("PaddingType", (Object)this.paddingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "InitializationVector": {
                return Optional.ofNullable(clazz.cast(this.initializationVector()));
            }
            case "PaddingType": {
                return Optional.ofNullable(clazz.cast(this.paddingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SymmetricEncryptionAttributes, T> g) {
        return obj -> g.apply((SymmetricEncryptionAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private String initializationVector;
        private String paddingType;

        private BuilderImpl() {
        }

        private BuilderImpl(SymmetricEncryptionAttributes model) {
            this.mode(model.mode);
            this.initializationVector(model.initializationVector);
            this.paddingType(model.paddingType);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(EncryptionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getInitializationVector() {
            return this.initializationVector;
        }

        public final void setInitializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
        }

        @Override
        public final Builder initializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
            return this;
        }

        public final String getPaddingType() {
            return this.paddingType;
        }

        public final void setPaddingType(String paddingType) {
            this.paddingType = paddingType;
        }

        @Override
        public final Builder paddingType(String paddingType) {
            this.paddingType = paddingType;
            return this;
        }

        @Override
        public final Builder paddingType(PaddingType paddingType) {
            this.paddingType(paddingType == null ? null : paddingType.toString());
            return this;
        }

        public SymmetricEncryptionAttributes build() {
            return new SymmetricEncryptionAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SymmetricEncryptionAttributes> {
        public Builder mode(String var1);

        public Builder mode(EncryptionMode var1);

        public Builder initializationVector(String var1);

        public Builder paddingType(String var1);

        public Builder paddingType(PaddingType var1);
    }
}

