/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionKeyDerivationValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionKeyDerivationValue> {
    private static final SdkField<String> APPLICATION_CRYPTOGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationCryptogram").getter(SessionKeyDerivationValue.getter(SessionKeyDerivationValue::applicationCryptogram)).setter(SessionKeyDerivationValue.setter(Builder::applicationCryptogram)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCryptogram").build()}).build();
    private static final SdkField<String> APPLICATION_TRANSACTION_COUNTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationTransactionCounter").getter(SessionKeyDerivationValue.getter(SessionKeyDerivationValue::applicationTransactionCounter)).setter(SessionKeyDerivationValue.setter(Builder::applicationTransactionCounter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationTransactionCounter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_CRYPTOGRAM_FIELD, APPLICATION_TRANSACTION_COUNTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationCryptogram;
    private final String applicationTransactionCounter;
    private final Type type;

    private SessionKeyDerivationValue(BuilderImpl builder) {
        this.applicationCryptogram = builder.applicationCryptogram;
        this.applicationTransactionCounter = builder.applicationTransactionCounter;
        this.type = builder.type;
    }

    public final String applicationCryptogram() {
        return this.applicationCryptogram;
    }

    public final String applicationTransactionCounter() {
        return this.applicationTransactionCounter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationCryptogram());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationTransactionCounter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionKeyDerivationValue)) {
            return false;
        }
        SessionKeyDerivationValue other = (SessionKeyDerivationValue)obj;
        return Objects.equals(this.applicationCryptogram(), other.applicationCryptogram()) && Objects.equals(this.applicationTransactionCounter(), other.applicationTransactionCounter());
    }

    public final String toString() {
        return ToString.builder((String)"SessionKeyDerivationValue").add("ApplicationCryptogram", (Object)(this.applicationCryptogram() == null ? null : "*** Sensitive Data Redacted ***")).add("ApplicationTransactionCounter", (Object)this.applicationTransactionCounter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationCryptogram": {
                return Optional.ofNullable(clazz.cast(this.applicationCryptogram()));
            }
            case "ApplicationTransactionCounter": {
                return Optional.ofNullable(clazz.cast(this.applicationTransactionCounter()));
            }
        }
        return Optional.empty();
    }

    public static SessionKeyDerivationValue fromApplicationCryptogram(String applicationCryptogram) {
        return (SessionKeyDerivationValue)SessionKeyDerivationValue.builder().applicationCryptogram(applicationCryptogram).build();
    }

    public static SessionKeyDerivationValue fromApplicationTransactionCounter(String applicationTransactionCounter) {
        return (SessionKeyDerivationValue)SessionKeyDerivationValue.builder().applicationTransactionCounter(applicationTransactionCounter).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionKeyDerivationValue, T> g) {
        return obj -> g.apply((SessionKeyDerivationValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        APPLICATION_CRYPTOGRAM,
        APPLICATION_TRANSACTION_COUNTER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String applicationCryptogram;
        private String applicationTransactionCounter;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SessionKeyDerivationValue model) {
            this.applicationCryptogram(model.applicationCryptogram);
            this.applicationTransactionCounter(model.applicationTransactionCounter);
        }

        public final String getApplicationCryptogram() {
            return this.applicationCryptogram;
        }

        public final void setApplicationCryptogram(String applicationCryptogram) {
            String oldValue = this.applicationCryptogram;
            this.applicationCryptogram = applicationCryptogram;
            this.handleUnionValueChange(Type.APPLICATION_CRYPTOGRAM, oldValue, this.applicationCryptogram);
        }

        @Override
        public final Builder applicationCryptogram(String applicationCryptogram) {
            String oldValue = this.applicationCryptogram;
            this.applicationCryptogram = applicationCryptogram;
            this.handleUnionValueChange(Type.APPLICATION_CRYPTOGRAM, oldValue, this.applicationCryptogram);
            return this;
        }

        public final String getApplicationTransactionCounter() {
            return this.applicationTransactionCounter;
        }

        public final void setApplicationTransactionCounter(String applicationTransactionCounter) {
            String oldValue = this.applicationTransactionCounter;
            this.applicationTransactionCounter = applicationTransactionCounter;
            this.handleUnionValueChange(Type.APPLICATION_TRANSACTION_COUNTER, oldValue, this.applicationTransactionCounter);
        }

        @Override
        public final Builder applicationTransactionCounter(String applicationTransactionCounter) {
            String oldValue = this.applicationTransactionCounter;
            this.applicationTransactionCounter = applicationTransactionCounter;
            this.handleUnionValueChange(Type.APPLICATION_TRANSACTION_COUNTER, oldValue, this.applicationTransactionCounter);
            return this;
        }

        public SessionKeyDerivationValue build() {
            return new SessionKeyDerivationValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionKeyDerivationValue> {
        public Builder applicationCryptogram(String var1);

        public Builder applicationTransactionCounter(String var1);
    }
}

