/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyAmex;
import software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyEmv2000;
import software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyEmvCommon;
import software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyMastercard;
import software.amazon.awssdk.services.paymentcryptographydata.model.SessionKeyVisa;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionKeyDerivation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionKeyDerivation> {
    private static final SdkField<SessionKeyEmvCommon> EMV_COMMON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmvCommon").getter(SessionKeyDerivation.getter(SessionKeyDerivation::emvCommon)).setter(SessionKeyDerivation.setter(Builder::emvCommon)).constructor(SessionKeyEmvCommon::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmvCommon").build()}).build();
    private static final SdkField<SessionKeyMastercard> MASTERCARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Mastercard").getter(SessionKeyDerivation.getter(SessionKeyDerivation::mastercard)).setter(SessionKeyDerivation.setter(Builder::mastercard)).constructor(SessionKeyMastercard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mastercard").build()}).build();
    private static final SdkField<SessionKeyEmv2000> EMV2000_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Emv2000").getter(SessionKeyDerivation.getter(SessionKeyDerivation::emv2000)).setter(SessionKeyDerivation.setter(Builder::emv2000)).constructor(SessionKeyEmv2000::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Emv2000").build()}).build();
    private static final SdkField<SessionKeyAmex> AMEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Amex").getter(SessionKeyDerivation.getter(SessionKeyDerivation::amex)).setter(SessionKeyDerivation.setter(Builder::amex)).constructor(SessionKeyAmex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amex").build()}).build();
    private static final SdkField<SessionKeyVisa> VISA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Visa").getter(SessionKeyDerivation.getter(SessionKeyDerivation::visa)).setter(SessionKeyDerivation.setter(Builder::visa)).constructor(SessionKeyVisa::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visa").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMV_COMMON_FIELD, MASTERCARD_FIELD, EMV2000_FIELD, AMEX_FIELD, VISA_FIELD));
    private static final long serialVersionUID = 1L;
    private final SessionKeyEmvCommon emvCommon;
    private final SessionKeyMastercard mastercard;
    private final SessionKeyEmv2000 emv2000;
    private final SessionKeyAmex amex;
    private final SessionKeyVisa visa;
    private final Type type;

    private SessionKeyDerivation(BuilderImpl builder) {
        this.emvCommon = builder.emvCommon;
        this.mastercard = builder.mastercard;
        this.emv2000 = builder.emv2000;
        this.amex = builder.amex;
        this.visa = builder.visa;
        this.type = builder.type;
    }

    public final SessionKeyEmvCommon emvCommon() {
        return this.emvCommon;
    }

    public final SessionKeyMastercard mastercard() {
        return this.mastercard;
    }

    public final SessionKeyEmv2000 emv2000() {
        return this.emv2000;
    }

    public final SessionKeyAmex amex() {
        return this.amex;
    }

    public final SessionKeyVisa visa() {
        return this.visa;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.emvCommon());
        hashCode = 31 * hashCode + Objects.hashCode(this.mastercard());
        hashCode = 31 * hashCode + Objects.hashCode(this.emv2000());
        hashCode = 31 * hashCode + Objects.hashCode(this.amex());
        hashCode = 31 * hashCode + Objects.hashCode(this.visa());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionKeyDerivation)) {
            return false;
        }
        SessionKeyDerivation other = (SessionKeyDerivation)obj;
        return Objects.equals(this.emvCommon(), other.emvCommon()) && Objects.equals(this.mastercard(), other.mastercard()) && Objects.equals(this.emv2000(), other.emv2000()) && Objects.equals(this.amex(), other.amex()) && Objects.equals(this.visa(), other.visa());
    }

    public final String toString() {
        return ToString.builder((String)"SessionKeyDerivation").add("EmvCommon", (Object)this.emvCommon()).add("Mastercard", (Object)this.mastercard()).add("Emv2000", (Object)this.emv2000()).add("Amex", (Object)this.amex()).add("Visa", (Object)this.visa()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmvCommon": {
                return Optional.ofNullable(clazz.cast(this.emvCommon()));
            }
            case "Mastercard": {
                return Optional.ofNullable(clazz.cast(this.mastercard()));
            }
            case "Emv2000": {
                return Optional.ofNullable(clazz.cast(this.emv2000()));
            }
            case "Amex": {
                return Optional.ofNullable(clazz.cast(this.amex()));
            }
            case "Visa": {
                return Optional.ofNullable(clazz.cast(this.visa()));
            }
        }
        return Optional.empty();
    }

    public static SessionKeyDerivation fromEmvCommon(SessionKeyEmvCommon emvCommon) {
        return (SessionKeyDerivation)SessionKeyDerivation.builder().emvCommon(emvCommon).build();
    }

    public static SessionKeyDerivation fromEmvCommon(Consumer<SessionKeyEmvCommon.Builder> emvCommon) {
        SessionKeyEmvCommon.Builder builder = SessionKeyEmvCommon.builder();
        emvCommon.accept(builder);
        return SessionKeyDerivation.fromEmvCommon((SessionKeyEmvCommon)builder.build());
    }

    public static SessionKeyDerivation fromMastercard(SessionKeyMastercard mastercard) {
        return (SessionKeyDerivation)SessionKeyDerivation.builder().mastercard(mastercard).build();
    }

    public static SessionKeyDerivation fromMastercard(Consumer<SessionKeyMastercard.Builder> mastercard) {
        SessionKeyMastercard.Builder builder = SessionKeyMastercard.builder();
        mastercard.accept(builder);
        return SessionKeyDerivation.fromMastercard((SessionKeyMastercard)builder.build());
    }

    public static SessionKeyDerivation fromEmv2000(SessionKeyEmv2000 emv2000) {
        return (SessionKeyDerivation)SessionKeyDerivation.builder().emv2000(emv2000).build();
    }

    public static SessionKeyDerivation fromEmv2000(Consumer<SessionKeyEmv2000.Builder> emv2000) {
        SessionKeyEmv2000.Builder builder = SessionKeyEmv2000.builder();
        emv2000.accept(builder);
        return SessionKeyDerivation.fromEmv2000((SessionKeyEmv2000)builder.build());
    }

    public static SessionKeyDerivation fromAmex(SessionKeyAmex amex) {
        return (SessionKeyDerivation)SessionKeyDerivation.builder().amex(amex).build();
    }

    public static SessionKeyDerivation fromAmex(Consumer<SessionKeyAmex.Builder> amex) {
        SessionKeyAmex.Builder builder = SessionKeyAmex.builder();
        amex.accept(builder);
        return SessionKeyDerivation.fromAmex((SessionKeyAmex)builder.build());
    }

    public static SessionKeyDerivation fromVisa(SessionKeyVisa visa) {
        return (SessionKeyDerivation)SessionKeyDerivation.builder().visa(visa).build();
    }

    public static SessionKeyDerivation fromVisa(Consumer<SessionKeyVisa.Builder> visa) {
        SessionKeyVisa.Builder builder = SessionKeyVisa.builder();
        visa.accept(builder);
        return SessionKeyDerivation.fromVisa((SessionKeyVisa)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionKeyDerivation, T> g) {
        return obj -> g.apply((SessionKeyDerivation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EMV_COMMON,
        MASTERCARD,
        EMV2000,
        AMEX,
        VISA,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SessionKeyEmvCommon emvCommon;
        private SessionKeyMastercard mastercard;
        private SessionKeyEmv2000 emv2000;
        private SessionKeyAmex amex;
        private SessionKeyVisa visa;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SessionKeyDerivation model) {
            this.emvCommon(model.emvCommon);
            this.mastercard(model.mastercard);
            this.emv2000(model.emv2000);
            this.amex(model.amex);
            this.visa(model.visa);
        }

        public final SessionKeyEmvCommon.Builder getEmvCommon() {
            return this.emvCommon != null ? this.emvCommon.toBuilder() : null;
        }

        public final void setEmvCommon(SessionKeyEmvCommon.BuilderImpl emvCommon) {
            SessionKeyEmvCommon oldValue = this.emvCommon;
            this.emvCommon = emvCommon != null ? emvCommon.build() : null;
            this.handleUnionValueChange(Type.EMV_COMMON, oldValue, this.emvCommon);
        }

        @Override
        public final Builder emvCommon(SessionKeyEmvCommon emvCommon) {
            SessionKeyEmvCommon oldValue = this.emvCommon;
            this.emvCommon = emvCommon;
            this.handleUnionValueChange(Type.EMV_COMMON, oldValue, this.emvCommon);
            return this;
        }

        public final SessionKeyMastercard.Builder getMastercard() {
            return this.mastercard != null ? this.mastercard.toBuilder() : null;
        }

        public final void setMastercard(SessionKeyMastercard.BuilderImpl mastercard) {
            SessionKeyMastercard oldValue = this.mastercard;
            this.mastercard = mastercard != null ? mastercard.build() : null;
            this.handleUnionValueChange(Type.MASTERCARD, oldValue, this.mastercard);
        }

        @Override
        public final Builder mastercard(SessionKeyMastercard mastercard) {
            SessionKeyMastercard oldValue = this.mastercard;
            this.mastercard = mastercard;
            this.handleUnionValueChange(Type.MASTERCARD, oldValue, this.mastercard);
            return this;
        }

        public final SessionKeyEmv2000.Builder getEmv2000() {
            return this.emv2000 != null ? this.emv2000.toBuilder() : null;
        }

        public final void setEmv2000(SessionKeyEmv2000.BuilderImpl emv2000) {
            SessionKeyEmv2000 oldValue = this.emv2000;
            this.emv2000 = emv2000 != null ? emv2000.build() : null;
            this.handleUnionValueChange(Type.EMV2000, oldValue, this.emv2000);
        }

        @Override
        public final Builder emv2000(SessionKeyEmv2000 emv2000) {
            SessionKeyEmv2000 oldValue = this.emv2000;
            this.emv2000 = emv2000;
            this.handleUnionValueChange(Type.EMV2000, oldValue, this.emv2000);
            return this;
        }

        public final SessionKeyAmex.Builder getAmex() {
            return this.amex != null ? this.amex.toBuilder() : null;
        }

        public final void setAmex(SessionKeyAmex.BuilderImpl amex) {
            SessionKeyAmex oldValue = this.amex;
            this.amex = amex != null ? amex.build() : null;
            this.handleUnionValueChange(Type.AMEX, oldValue, this.amex);
        }

        @Override
        public final Builder amex(SessionKeyAmex amex) {
            SessionKeyAmex oldValue = this.amex;
            this.amex = amex;
            this.handleUnionValueChange(Type.AMEX, oldValue, this.amex);
            return this;
        }

        public final SessionKeyVisa.Builder getVisa() {
            return this.visa != null ? this.visa.toBuilder() : null;
        }

        public final void setVisa(SessionKeyVisa.BuilderImpl visa) {
            SessionKeyVisa oldValue = this.visa;
            this.visa = visa != null ? visa.build() : null;
            this.handleUnionValueChange(Type.VISA, oldValue, this.visa);
        }

        @Override
        public final Builder visa(SessionKeyVisa visa) {
            SessionKeyVisa oldValue = this.visa;
            this.visa = visa;
            this.handleUnionValueChange(Type.VISA, oldValue, this.visa);
            return this;
        }

        public SessionKeyDerivation build() {
            return new SessionKeyDerivation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionKeyDerivation> {
        public Builder emvCommon(SessionKeyEmvCommon var1);

        default public Builder emvCommon(Consumer<SessionKeyEmvCommon.Builder> emvCommon) {
            return this.emvCommon((SessionKeyEmvCommon)((SessionKeyEmvCommon.Builder)SessionKeyEmvCommon.builder().applyMutation(emvCommon)).build());
        }

        public Builder mastercard(SessionKeyMastercard var1);

        default public Builder mastercard(Consumer<SessionKeyMastercard.Builder> mastercard) {
            return this.mastercard((SessionKeyMastercard)((SessionKeyMastercard.Builder)SessionKeyMastercard.builder().applyMutation(mastercard)).build());
        }

        public Builder emv2000(SessionKeyEmv2000 var1);

        default public Builder emv2000(Consumer<SessionKeyEmv2000.Builder> emv2000) {
            return this.emv2000((SessionKeyEmv2000)((SessionKeyEmv2000.Builder)SessionKeyEmv2000.builder().applyMutation(emv2000)).build());
        }

        public Builder amex(SessionKeyAmex var1);

        default public Builder amex(Consumer<SessionKeyAmex.Builder> amex) {
            return this.amex((SessionKeyAmex)((SessionKeyAmex.Builder)SessionKeyAmex.builder().applyMutation(amex)).build());
        }

        public Builder visa(SessionKeyVisa var1);

        default public Builder visa(Consumer<SessionKeyVisa.Builder> visa) {
            return this.visa((SessionKeyVisa)((SessionKeyVisa.Builder)SessionKeyVisa.builder().applyMutation(visa)).build());
        }
    }
}

